# How to contribute

We welcome everyone to submit pull requests with:

* fixes for issues
* change suggestions
* updating of documentation

Please NOTE:

Not every pull request will automatically be accepted. I will review each carefully to make sure it is in line with the direction I want the package to continue in. This might mean that some pull requests are not accepted, or might stay unmerged until a place for them can be determined.

## Coding standards

You MUST use the following coding standards:

* [PSR-1](http://www.php-fig.org/psr/1/)
* [PSR-2](http://www.php-fig.org/psr/2/)
* [PSR-4](http://www.php-fig.org/psr/4/)

We use StyleCI to ensure these coding standards are consistently achieved.

## Documentation

You SHOULD update any relevant documentation.

## Making changes

You MUST do the following:

* Run `composer test` and ensure everything passes.

We use Code Climate to help us achieve correct code quality.

## Pull requests

You SHOULD do the following when preparing your request:

* Rebase your branch before submitting pull request
* Add a descriptive header that explains in a single sentence what problem the PR solves.
* Add a detailed description with animated screen-grab GIFs visualizing how it works.
* Explain why you think it should be implemented one way vs. another, highlight performance improvements, etc.

Thanks!
Rocco Howard, H&H|Digital