<title>Edit Company</title>

<link rel="stylesheet" href="<?php echo e(URL::asset('css/multi-select/jquery.multiselect.css')); ?>">
<style type="text/css">
        ul,
        li {
            margin: 0;
            /* padding: 0; */
            list-style: inline;
        }

        .label {
            color: #000;
            font-size: 16px;
        }

        select+.select2-container {
            width: 100% !important;
        }
    </style>
<?php $__env->startSection('contents'); ?>
    <h1 class="page-title">Edit Company</h1>
    
    <!-- Breadcrumb -->
    <ol class="breadcrumb breadcrumb-2">
        <li><a href="<?php echo e(asset('dashboard')); ?>"><i class="fa fa-home"></i>Home</a></li>
        <li><a href="<?php echo e(asset('account-group')); ?>">Companies</a></li>
        <li class="active"><strong>Edit Company</strong></li>
    </ol>
    
    <div class="row">
        <div class="col-lg-12">
            <div class="panel panel-default">
                <div class="panel-heading clearfix">
                    <h3 class="panel-title">Edit Company</h3>
                    <ul class="panel-tool-options">
                        <li><a data-rel="collapse" href="#"><i class="icon-down-open"></i></a></li>
                        <li><a data-rel="reload" href="#"><i class="icon-arrows-ccw"></i></a></li>
                        <li><a data-rel="close" href="#"><i class="icon-cancel"></i></a></li>
                    </ul>
                </div>
                
                <div class="panel-body">
                    <?php echo $__env->make('errors.validation', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    
                    <?php echo Form::model($edit, [
                        'method' => 'PATCH',
                        'action' => ['App\Http\Controllers\CompanyController@update', $edit->id],
                        'class' => 'form-horizontal',
                        'files' => 'true',
                        'enctype' => 'multipart/form-data',
                    ]); ?>

                    
                    <?php echo Form::hidden('biller_id', Auth::User()->id, ['id' => 'biller_id', 'class' => 'form-control']); ?>

                    
                    <!-- Company Information Section -->
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group row">
                                <?php echo Form::label('name', 'Name', ['class' => 'col-md-4 col-form-label']); ?>

                                <div class="col-md-8">
                                    <?php echo Form::text('CompanyName', null, ['id' => 'CompanyName', 'class' => 'form-control', 'autofocus' => 'autofocus']); ?>

                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="form-group row">
                                <?php echo Form::label('phone', 'Phone', ['class' => 'col-md-4 col-form-label']); ?>

                                <div class="col-md-8">
                                    <?php echo Form::text('phone', null, ['id' => 'phone', 'class' => 'form-control']); ?>

                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Address Section -->
                    <div class="row mt-3">
                        <div class="col-md-6">
                            <div class="form-group row">
                                <?php echo Form::label('address', 'Address', ['class' => 'col-md-4 col-form-label']); ?>

                                <div class="col-md-8">
                                    <?php echo Form::text('address', null, ['id' => 'address', 'class' => 'form-control']); ?>

                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="form-group row">
                                <?php echo Form::label('Province', 'Province', ['class' => 'col-md-4 col-form-label']); ?>

                                <div class="col-md-8">
                                    <?php echo Form::select('province', [
                                        'Punjab' => 'Punjab', 
                                        'Sindh' => 'Sindh', 
                                        'Balochistan' => 'Balochistan', 
                                        'Khyber Pakhtunkhwa' => 'Khyber Pakhtunkhwa'
                                    ], null, ['id' => 'province', 'class' => 'form-control']); ?>

                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Business Type Section -->
                    <div class="row mt-3">
                        <div class="col-md-6">
                            <div class="form-group row">
                                <?php echo Form::label('type', 'Type', ['class' => 'col-md-4 col-form-label']); ?>

                                <div class="col-md-8">
                                    <?php echo Form::select('type', [
                                        'Invoice Only' => 'Invoice Only', 
                                        'Inventory' => 'Inventory', 
                                        'Trader' => 'Trader', 
                                        'Manufacturer' => 'Manufacturer'
                                    ], null, ['id' => 'type', 'class' => 'form-control']); ?>

                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="form-group row">
                                <?php echo Form::label('bill_type', 'Bill Type', ['class' => 'col-md-4 col-form-label']); ?>

                                <div class="col-md-8">
                                    <?php echo Form::select('bill_type', [
                                        'Thermal' => 'Thermal', 
                                        'A4' => 'A4'
                                    ], null, ['id' => 'bill_type', 'class' => 'form-control']); ?>

                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Tax Information Section -->
                    <div class="row mt-3">
                        <div class="col-md-6">
                            <div class="form-group row">
                                <?php echo Form::label('Ntn', 'NTN', ['class' => 'col-md-4 col-form-label']); ?>

                                <div class="col-md-8">
                                <small class="text-danger d-block mb-1">NTN (9937038) - CNIC (3520133847501)</small>
                                    <?php echo Form::text('ntn', null, ['id' => 'ntn', 'class' => 'form-control']); ?>

                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="form-group row">
                                <?php echo Form::label('ntn_show', 'Show Customer NTN', ['class' => 'col-md-4 col-form-label']); ?>

                                <div class="col-md-8">
                                    <?php echo Form::select('ntn_show', [1 => 'Yes', 0 => 'No'], null, ['id' => 'ntn_show', 'class' => 'form-control']); ?>

                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row mt-3">
                        <div class="col-md-6">
                            <div class="form-group row">
                                <?php echo Form::label('Strn', 'STRN', ['class' => 'col-md-4 col-form-label']); ?>

                                <div class="col-md-8">
                                    <?php echo Form::text('strn', null, ['id' => 'strn', 'class' => 'form-control']); ?>

                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="form-group row">
                                <?php echo Form::label('strn_show', 'Show Customer STRN', ['class' => 'col-md-4 col-form-label']); ?>

                                <div class="col-md-8">
                                    <?php echo Form::select('strn_show', [1 => 'Yes', 0 => 'No'], null, ['id' => 'strn_show', 'class' => 'form-control']); ?>

                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Settings Section -->
                    <div class="row mt-3">
                        <div class="col-md-6">
                            <div class="form-group row">
                                <?php echo Form::label('discount', 'Discount', ['class' => 'col-md-4 col-form-label']); ?>

                                <div class="col-md-8">
                                    <?php echo Form::select('discount', ['0' => 'No', '1' => 'Yes'], null, ['id' => 'discount', 'class' => 'form-control']); ?>

                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="form-group row">
                                <?php echo Form::label('extra_tax', 'Extra Tax', ['class' => 'col-md-4 col-form-label']); ?>

                                <div class="col-md-8">
                                    <?php echo Form::select('extra_tax', ['0' => 'No', '1' => 'Yes'], null, ['id' => 'extra_tax', 'class' => 'form-control']); ?>

                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Dates Section -->
                    <div class="row mt-3">
                        <div class="col-md-6">
                            <div class="form-group row">
                                <?php echo Form::label('start_date', 'Start Date', ['class' => 'col-md-4 col-form-label']); ?>

                                <div class="col-md-8">
                                    <?php echo Form::date('start_date', date('Y-m-d'), ['id' => 'start_date', 'class' => 'form-control']); ?>

                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="form-group row">
                                <?php echo Form::label('expire_date', 'Expiry Date', ['class' => 'col-md-4 col-form-label']); ?>

                                <div class="col-md-8">
                                    <?php echo Form::date('expire_date', date('Y-m-d', strtotime("+1 year")), ['id' => 'expire_date', 'class' => 'form-control']); ?>

                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <hr class="my-4">
                    
                    <!-- Payment Tokens Section -->
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group row">
                                <?php echo Form::label('sandbox_token', 'SandBox Token', ['class' => 'col-md-4 col-form-label']); ?>

                                <div class="col-md-8">
                                    <small class="text-danger d-block mb-1">Please Enter the exact SandBox Token</small>
                                    <?php echo Form::text('sandbox_token', null, ['id' => 'sandbox_token', 'class' => 'form-control']); ?>

                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="form-group row">
                                <?php echo Form::label('token', 'Live TOKEN', ['class' => 'col-md-4 col-form-label']); ?>

                                <div class="col-md-8">
                                    <small class="text-danger d-block mb-1">Please Enter the exact Live TOKEN</small>
                                    <?php echo Form::text('token', null, ['id' => 'token', 'class' => 'form-control']); ?>

                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Invoice Settings Section -->
                    <div class="row mt-3">
                        <div class="col-md-6">
                            <div class="form-group row">
                                <?php echo Form::label('invoice_type', 'Invoice Type', ['class' => 'col-md-4 col-form-label']); ?>

                                <div class="col-md-8">
                                    <?php echo Form::select('invoice_type', [
                                        'SandBox' => 'SandBox', 
                                        'Live' => 'Live'
                                    ], null, ['id' => 'invoice_type', 'class' => 'form-control']); ?>

                                </div>
                            </div>
                        </div>
                        
                        <!-- <div class="col-md-6">
                            <div class="form-group row">
                                <?php echo Form::label('sale_type', 'Sale Type', ['class' => 'col-md-4 col-form-label']); ?>

                                <div class="col-md-8">
                                    <?php echo Form::select('sale_type', $saletypes, null, ['id' => 'sale_type', 'class' => 'form-control']); ?>

                                </div>
                            </div>
                        </div> -->
                    </div>

                    <div class="row mt-3">
                    <?php
                            // Decode the JSON string and extract size values
                            $selectedSizes = json_decode($edit->scenario, true);
                            $selectedSizeValues = array_column($selectedSizes, 'scenario');
                            ?>
                        <div class="col-md-6">
                            <div class="form-group row">
                                <?php echo Form::label('Scenario', 'Scenario', ['class' => 'col-md-4 col-form-label']); ?>

                                <div class="col-md-8">
                                    <!-- <?php echo Form::select('scenario', $Scenario, null, ['id' => 'scenario', 'class' => 'form-control']); ?> -->
                                    <?php echo Form::select('scenario[]', $Scenario, $selectedSizeValues, [
                                        'id' => 'langOpt3',
                                        'class' => 'form-control',
                                        'multiple' => 'multiple',
                                        'style' => 'width: auto; display: inline-block;'
                                    ]); ?>

                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Payment Information Section -->
                    <div class="row mt-3">
                        <div class="col-md-6">
                            <div class="form-group row">
                                <?php echo Form::label('client_payment', 'Client Payment', ['class' => 'col-md-4 col-form-label']); ?>

                                <div class="col-md-8">
                                    <?php echo Form::text('client_payment', null, ['id' => 'client_payment', 'class' => 'form-control']); ?>

                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="form-group row">
                                <?php echo Form::label('payment_terms', 'Payment Terms', ['class' => 'col-md-4 col-form-label']); ?>

                                <div class="col-md-8">
                                    <?php echo Form::select('payment_terms', [
                                        'Monthly' => 'Monthly', 
                                        'Annual' => 'Annual'
                                    ], null, ['id' => 'payment_terms', 'class' => 'form-control']); ?>

                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row mt-3">
                        <div class="col-md-6">
                            <div class="form-group row">
                                <?php echo Form::label('Email', 'Email', ['class' => 'col-md-4 col-form-label']); ?>

                                <div class="col-md-8">
                                    <?php echo Form::text('email12345', $user->email, ['id' => 'email12345', 'class' => 'form-control', 'disabled' => 'disabled']); ?>

                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="form-group row">
                                <?php echo Form::label('Password', 'Password', ['class' => 'col-md-4 col-form-label']); ?>

                                <div class="col-md-8">
                                <?php echo Form::text('password12345', $user->show_password, ['id' => 'password12345', 'class' => 'form-control', 'disabled' => 'disabled']); ?>

                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Submit Button -->
                    <div class="row mt-4">
                        <div class="col-md-12 text-center">
                            <button type="submit" class="btn btn-primary px-4">Update</button>
                        </div>
                    </div>
                    
                    <?php echo Form::close(); ?>

                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script src="<?php echo e(URL::asset('css/multi-select/jquery.multiselect.js')); ?>"></script>
    <script src="<?php echo e(asset('js/plugins/select2/select2.full.min.js')); ?>"></script>
    <script type="text/javascript">
        $("#sale_type").select2();
        $("#sale_type").next(".select2").find(".select2-selection").focus(function() {
            $("#sale_type").select2("open");
        });
        $("#scenario").select2();
        $("#scenario").next(".select2").find(".select2-selection").focus(function() {
            $("#scenario").select2("open");
        });

        $('#langOpt3').multiselect({
            columns: 1,
            placeholder: 'Select Size',
            search: true,
            selectAll: true
        });
        
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /homec/itlifeen/portal.fbrdigitalinvoice.pk/root/resources/views/companies/edit.blade.php ENDPATH**/ ?>