<?php
use App\Models\SystemLogo;
use App\Models\Setting;

$logo = SystemLogo::first();
$settings = Setting::first();
?>

<!DOCTYPE html>
<html lang="en" data-theme="light">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    
    <title><?php echo e($settings->title); ?> - Login</title>
    
    <!-- Favicon -->
    <link rel="shortcut icon" href="<?php echo e(asset('login-form-assets/img/favicon.ico')); ?>" type="image/x-icon">
    
    <!-- SEO Meta Tags -->
    <meta name="description" content="Login to your <?php echo e($settings->title); ?> account">
    
    <!-- Preconnect to external resources -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Jost:wght@300;400;500;600;700;800;900&family=Poppins:wght@400;500;700;800;900&display=swap" rel="stylesheet">
    
    <!-- CSS Assets -->
    <link rel="stylesheet" href="<?php echo e(asset('login-form-assets/css/bootstrap.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('login-form-assets/fonts/font-awesome/css/all.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('login-form-assets/css/main.min.css')); ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" />
    <!-- Inline Critical CSS -->
    <style>
        :root {
            --primary-color: #3b8fc8;
            --secondary-color: #252C3B;
            --text-color: #333;
            --light-bg: #f8f9fa;
            
        }
        
        body {
            font-family: 'Poppins', sans-serif;
            background-color: var(--light-bg);
            color: var(--text-color);
            overflow-x: hidden;
        }
        
        .login-container {
            min-height: 100vh;
            display: flex;
            align-items: center;
            background-color: var(--primary-color);
        }
        
        .login-card {
            border-radius: 12px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
            overflow: hidden;
        }
        
        .login-form {
            padding: 3rem;
            background: white;
        }
        
        .login-hero {
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 2rem;
        }
        
        .form-control {
            padding: 12px 15px;
            border-radius: 8px;
            border: 1px solid #ddd;
            transition: all 0.3s;
        }
        
        .form-control:focus {
            border-color: var(--primary-color);
            box-shadow: 0 0 0 0.25rem rgba(105, 137, 159, 0.25);
        }
        
        .btn-primary {
            background-color: var(--primary-color);
            border: none;
            padding: 12px 24px;
            font-weight: 600;
            transition: all 0.3s;
        }
        
        .btn-primary:hover {
            background-color: var(--secondary-color);
            transform: translateY(-2px);
        }
        
        .alert {
            border-radius: 8px;
        }
        
        @media (max-width: 992px) {
            .login-hero {
                display: none;
            }
        }
    </style>
</head>

<body>
    <!-- Google Tag Manager (noscript) -->
    <noscript>
        <iframe src="https://www.googletagmanager.com/ns.html?id=GTM-TAGCODE" height="0" width="0" style="display:none;visibility:hidden"></iframe>
    </noscript>
    
    <!-- Loading Indicator -->
    <div class="page-loader">
        <div class="spinner-border text-primary" role="status">
            <span class="visually-hidden">Loading...</span>
        </div>
    </div>
    
    <!-- Main Login Container -->
    <div class="login-container">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-10">
                    <div class="login-card">
                        <div class="row g-0">
                            <!-- Login Form Section -->
                            <div class="col-lg-6">
                                <div class="login-form">
                                    <?php if($settings->white_label == 0): ?>
                                        <div class="text-center mb-5">
                                            <img src="<?php echo e(asset('root/upload/logo/' . $logo->image)); ?>" 
                                                 alt="<?php echo e($settings->title); ?>" 
                                                 class="img-fluid" 
                                                 style="max-height: 80px">
                                        </div>
                                    <?php else: ?>
                                        <h1 class="text-center mb-4"><?php echo e($settings->title); ?></h1>
                                    <?php endif; ?>
                                    
                                    <h3 class="text-center mb-4">Sign In to Your Account</h3>
                                    
                                    <!-- Error Messages -->
                                    <?php if(session('error')): ?>
                                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                            <?php echo e(session('error')); ?>

                                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                        </div>
                                    <?php endif; ?>
                                    
                                    <?php if($errors->any()): ?>
                                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                            <ul class="mb-0">
                                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <li><?php echo e($error); ?></li>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </ul>
                                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                        </div>
                                    <?php endif; ?>
                                    
                                    <form method="POST" action="<?php echo e(route('login')); ?>" class="needs-validation" novalidate>
                                        <?php echo csrf_field(); ?>
                                        
                                        <div class="mb-4">
                                            <label for="email" class="form-label">Email Address</label>
                                            <input type="email" 
                                                   class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                                   id="email" 
                                                   name="email" 
                                                   value="<?php echo e(old('email')); ?>" 
                                                   required 
                                                   autofocus>
                                            <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <div class="invalid-feedback">
                                                    <?php echo e($message); ?>

                                                </div>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                        
                                        <div class="mb-4">
                                            <label for="password" class="form-label">Password</label>
                                            <div class="input-group">
                                                <input type="password" 
                                                       class="form-control <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                                       id="password" 
                                                       name="password" 
                                                       required>
                                                <button class="btn btn-outline-secondary toggle-password" type="button">
                                                    <i class="far fa-eye"></i>
                                                </button>
                                                <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="invalid-feedback">
                                                        <?php echo e($message); ?>

                                                    </div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>
                                        
                                        <!-- <div class="d-flex justify-content-between align-items-center mb-4">
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" name="remember" id="remember">
                                                <label class="form-check-label" for="remember">
                                                    Remember Me
                                                </label>
                                            </div>
                                            <a href="<?php echo e(route('password.request')); ?>" class="text-primary">Forgot Password?</a>
                                        </div> -->
                                        
                                        <button type="submit" class="btn btn-primary w-100 py-2 mb-3">
                                            <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
                                            Login
                                        </button>
                                        
                                        <?php if($settings->white_label == 0): ?>
                                        <div class="social-login text-center mt-4">
                                            <p class="mb-3">Or connect with</p>
                                            <div class="d-flex justify-content-center gap-3">
                                                <a href="https://fbrdigitalinvoice.pk" target="_blank" class="btn btn-outline-primary rounded-circle">
                                                    <i class="fas fa-globe"></i>
                                                </a>
                                                <a href="https://www.facebook.com/itlifee.net" target="_blank" class="btn btn-outline-primary rounded-circle">
                                                    <i class="fab fa-facebook-f"></i>
                                                </a>
                                                <a href="https://www.instagram.com/it.lifee" target="_blank" class="btn btn-outline-primary rounded-circle">
                                                    <i class="fab fa-instagram"></i>
                                                </a>
                                            </div>
                                        </div>
                                        <?php endif; ?>
                                    </form>
                                    
                                    <div class="text-center mt-4">
                                        <p>Need FBR Digital Invoicing, POS service?</p>
                                        <p><a href="tel:<?php echo e($settings->phone); ?>" class="text-primary"><?php echo e($settings->phone); ?></a></p>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Hero Image Section -->
                            <div class="col-lg-6 d-none d-lg-block">
                                <div class="login-hero h-100">
                                    <div class="text-center text-white p-4">
                                        <img src="<?php echo e(asset('login-form-assets/img/img-4.png')); ?>" alt="Welcome" class="img-fluid mb-4">
                                        <h2>Welcome Back!</h2>
                                        <p class="lead">Sign in to access your dashboard and manage your account.</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- JavaScript Libraries -->
    <script src="<?php echo e(asset('login-form-assets/js/bootstrap.bundle.min.js')); ?>"></script>
    
    <!-- Custom Script -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Toggle password visibility
            document.querySelectorAll('.toggle-password').forEach(button => {
                button.addEventListener('click', function() {
                    const passwordInput = this.previousElementSibling;
                    const icon = this.querySelector('i');
                    
                    if (passwordInput.type === 'password') {
                        passwordInput.type = 'text';
                        icon.classList.replace('fa-eye', 'fa-eye-slash');
                    } else {
                        passwordInput.type = 'password';
                        icon.classList.replace('fa-eye-slash', 'fa-eye');
                    }
                });
            });
            
            // Form submission loading state
            const forms = document.querySelectorAll('.needs-validation');
            forms.forEach(form => {
                form.addEventListener('submit', function(event) {
                    if (!form.checkValidity()) {
                        event.preventDefault();
                        event.stopPropagation();
                    } else {
                        const submitButton = form.querySelector('button[type="submit"]');
                        const spinner = submitButton.querySelector('.spinner-border');
                        
                        submitButton.disabled = true;
                        spinner.classList.remove('d-none');
                    }
                    
                    form.classList.add('was-validated');
                }, false);
            });
            
            // Hide loader when page is loaded
            window.addEventListener('load', function() {
                document.querySelector('.page-loader').style.display = 'none';
            });
        });
    </script>
</body>
</html><?php /**PATH /homec/itlifeen/portal.fbrdigitalinvoice.pk/root/resources/views/auth/login.blade.php ENDPATH**/ ?>