@extends('app')
@section('contents')
<head>
<link href="{{asset('css/select2.min.css')}}" rel="stylesheet" />
    <meta name="csrf-token" content="{{ csrf_token() }}" />
</head>

    <body>
        <div class="container-fluid">
            @if (Session::has('flash_message'))
                <button type="button" class="close" data-dismiss="alert" aria-hidden="true"
                    style="margin-right: 20px;margin-top: 15px;">&times;</button>
                <div class="alert alert-success"> {{ Session::get('flash_message') }} </div>
            @endif
        </div>
        <div class="row">
            <div class="col-lg-12">
                <div class="panel panel-default">
                    <div class="panel-heading clearfix" id="panelbg">
                        <h2 class="panel-title"><b>Add Journal Voucher</b></h2>
                    </div>
                    <div class="panel-body">
                        <input id="token" type="hidden" value="{{ $encrypted_token }}">
                        @include('errors.validation')
                        {!! Form::open(['url' => 'general-voucher', 'class' => 'form-horizontal']) !!}
                        {!! Form::hidden('company_id', session()->get('company_id'), ['id' => 'company_id']) !!}
                        <div class="row">
                            <div class="form-group" style="margin-left: 1%; margin-right: 1%;">
                                <label class="col-sm-1 control-label">Vr. No</label>
                                <div class="col-sm-2">
                                    <div id="year-view" class="input-group date">
                                        {!! Form::text('voucher_no', $codes, ['id' => 'voucher_no', 'class' => 'form-control', 'disabled' => 'disabled']) !!}
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group" style="margin-left: 1%; margin-right: 1%;">
                                <label class="col-sm-1 control-label">Vr. Date</label>
                                <div class="col-sm-2">
                                    <div id="year-view" class="input-group date">
                                        <input id="voucher_date" type="date" name="voucher_date" value="<?php echo date('Y-m-d'); ?>"
                                            class="form-control" autofocus>
                                        <!-- <span class="input-group-addon"><i class="fa fa-calendar"></i></span>  -->
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row" style="display: none;">
                            <div class="form-group" style="margin-left: 1%; margin-right: 1%;">
                                <label class="col-sm-1 control-label">Voucher Type</label>
                                <div class="col-sm-5" style="height: 40px;">
                                    {!! Form::text('v_type', 'Journal Voucher', ['id' => 'v_type', 'class' => 'form-control']) !!}
                                </div>
                            </div>
                        </div>

                        <div class="row" style="display:none;">
                            <div class="form-group" style="margin-left: 1%; margin-right: 1%;">
                                <label class="col-sm-1 control-label">Biller</label>
                                <div class="col-sm-3" style="height: 40px;">
                                    <select name="biller" id="biller" class="form-control" disabled>
                                        <option value="{{ Auth::user()->id }}">{{ Auth::user()->name }}</option>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="panel panel-default">
                            <div class="panel-body">
                                <div class="form-group">
                                    <table id="myTable">
                                        <div class="container-fluid">
                                            <div class="row">
                                                <tr>
                                                    {!! Form::hidden('product_id', null, ['id' => 'product_id', 'class' => 'form-control']) !!}
                                                    <div class="col-md-2" style="margin-left: 1%; margin-right: 1%;">
                                                        <div class="form-group">
                                                            <label for="H.S" class="control-label">Date</label>
                                                            <input id="date" type="date" name="date"
                                                                value="<?php echo date('Y-m-d'); ?>" class="form-control">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-1"
                                                        style="margin-left: 1%; margin-right: 1%; display:none;">
                                                        <div class="form-group">
                                                            <label for="password"
                                                                class="control-label">Voucher&nbsp;No</label>
                                                            {!! Form::text('voucher_no', $codes, ['id' => 'voucher_no', 'class' => 'form-control']) !!}
                                                        </div>
                                                    </div>
                                                    <div class="col-md-2" style="display:none;">
                                                        <div class="form-group">
                                                            <label for="password" class="control-label">Type</label>
                                                            {!! Form::text('v_type', 'Journal Voucher', ['id' => 'v_type', 'class' => 'form-control']) !!}
                                                        </div>
                                                    </div>
                                                    <div class="col-md-1">
                                                        <div class="form-group">
                                                            <label for="Name" class="control-label">Account Type</label>
                                                            {!! Form::select('account_type', $accountGroups, null, ['id' => 'account_type', 'class' => 'form-control']) !!}
                                                        </div>
                                                    </div>
                                                    <div class="col-md-2" style="margin-left: 1%; margin-right: 1%;">
                                                        <div class="form-group">
                                                            <label for="Name"
                                                                class="control-label">Account&nbsp;Name</label>
                                                            {!! Form::select('account_head_id', $Heads, null, ['id' => 'account_head_id', 'class' => 'form-control']) !!}
                                                        </div>
                                                    </div>
                                                    <div class="col-md-2" style="margin-left: 1%; margin-right: 1%;">
                                                        <div class="form-group">
                                                            <label for="password" class="control-label">Description</label>
                                                            {!! Form::text('narration', null, ['id' => 'narration', 'class' => 'form-control']) !!}
                                                        </div>
                                                    </div>
                                                    <div class="col-md-1" style="margin-left: 1%; margin-right: 1%;">
                                                        <div class="form-group">
                                                            <label for="password" class="control-label">Debit</label>
                                                            {!! Form::text('debit', null, ['id' => 'debit', 'class' => 'form-control',  'onkeyup'=>'DebitUp(this.value)', 'onfocus' => 'this.value=""', 'onkeypress' => 'return onlyNumberKey(event)']) !!}
                                                        </div>
                                                    </div>
                                                    <div class="col-md-1" style="margin-left: 1%; margin-right: 1%;">
                                                        <div class="form-group">
                                                            <label for="password" class="control-label">Credit</label>
                                                            {!! Form::text('credit', null, ['id' => 'credit', 'class' => 'form-control', 'onkeyup'=>'CreditUp(this.value);',  'onfocus' => 'this.value=""', 'onkeypress' => 'return onlyNumberKey(event)']) !!}
                                                        </div>
                                                    </div>
                                                    <div class="col-md-1" style="margin-left: 1%; margin-right: 1%;">
                                                        <div class="form-group">
                                                            <label for="password" class="control-label">Add</label>

                                                            <button class="form-control" style="background: #e20707;"
                                                                type="button" class="btn btn-red"
                                                                onkeyup="AddGridData();">Add</button>
                                                            <!-- <button type="button" onclick="AddGridData()" class="btn btn-red"><i class="fa fa-plus"></i> </button> -->
                                                        </div>
                                                    </div>
                                                </tr>
                                            </div>
                                        </div>
                                    </table></br></br>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="panel panel-default">
                                    <div class="panel-heading clearfix">
                                        <h3 class="panel-title">General Voucher Grid</h3>
                                    </div>
                                    <div class="panel-body">
                                        <div class="table-responsive">
                                            <table class="table table-bordered">
                                                <thead>
                                                    <tr>
                                                        <th>Dlt</th>
                                                        <th style="display:none;">Head&nbsp;ID</th>
                                                        <th>Date</th>
                                                        <th>Voucher&nbsp;No</th>
                                                        <th style="display:none;">Type</th>
                                                        <th>Account&nbsp;Name</th>
                                                        <th>Narration</th>
                                                        <th>Debit</th>
                                                        <th>Credit</th>
                                                    </tr>
                                                </thead>
                                                <tbody id="GridTable">
                                                    <div class="row">
                                                        <!-- <th scope="row">1</th>
                                                                <td>Mark</td>
                                                                <td>Otto</td>
                                                                <td>@mdo</td>
                                                                <td>Mark</td>
                                                                <td>Otto</td>
                                                                <td>@mdo</td>
                                                                <td>Mark</td>
                                                                <td>Otto</td>
                                                                <td>@mdo</td>
                                                                <td>Mark</td>
                                                                <td>Otto</td>  -->
                                                    </div>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="panel panel-default">
                                    <div class="panel-heading clearfix" id="panelbg">
                                        <div class="container">
                                            <div class="col-xs-5"> </div>
                                            <!-- <div class="col-xs-3">  </div> -->
                                            <div class="col-xs-3"> <b>Total Debit</b> <input type="text" value="0"
                                                    id="TotalDebit" name="TotalRate" disabled> </div>
                                            <div class="col-xs-4"> <b>Total Credit</b> <input type="text" value="0"
                                                    id="TotalCredit" name="TotalAmount" disabled> </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <center>
                            <div class="form-actions">
                                <button type="button" class="btn btn-primary" id="btnSave" name="btnSave">Save</button>
                            </div>
                        </center>
                        <div class="col-lg-3">
                            <!-- <button type="button" onclick="AddRowFunction()" class="btn btn-success"><i class="fa fa-plus"></i> </button> -->
                            <!-- <button type="button" onclick="AddGridData()" class="btn btn-success"><i class="fa fa-plus"></i> </button>
                        <button type="button" onclick="TotalRecords()" class="btn btn-success">Total Records</button> -->
                        </div>
                        {!! Form::close() !!}
                    </div>
                </div>
            </div>
        </div>
    </body>
@stop
@section('scripts')
<script src="{{ asset('js/plugins/select2/select2.full.min.js') }}"></script>

<script type="text/javascript">
        // $("#account_type").select2();
        // $("#account_type").next(".select2").find(".select2-selection").focus(function() {
        //     $("#account_type").select2("open");
        // });

        $("#account_head_id").select2();
        $("#account_head_id").next(".select2").find(".select2-selection").focus(function() {
            $("#account_head_id").select2("open");
        });


        $("#account_type").select2();
        $("#account_type").next(".select2").find(".select2-selection").focus(function() {
            $("#account_type").select2("open");
        });



        $('#account_head_id').change(function() {
            $('#account_head_id').select2().trigger('select2:close');
            $("#narration").focus();
        });

        

        
    </script>

    <script type="text/javascript">

        // function DebitUp(debit){
        //     if(debit == ""){
        //         document.getElementById("debit").value = 0;
        //     }
        // }

        function CreditUp(debit){
            debit = document.getElementById("debit").value;
            // credit = document.getElementById("credit").value;
            if(debit == ""){
                document.getElementById("debit").value = 0;
            }
            
        }


        function AddGridData() {
            credit = document.getElementById("credit").value;
            if(credit == ""){
                document.getElementById("credit").value = 0;
            }
            debit = document.getElementById("debit").value;
            // credit = document.getElementById("credit").value;
            if(debit == ""){
                document.getElementById("debit").value = 0;
            }
            // if ($("#credit").val() == "" || $("#debit").val() == "" || $("#account_head_id").val() == "") {
            if ($("#credit").val() == "" && $("#debit").val() == "") {
                document.getElementById("debit").focus();
                Swal.fire('Must enter Debit or Credit Value!');
                e.preventdefault();
            }
            if ($("#credit").val() == "0" && $("#debit").val() == "0") {
                document.getElementById("debit").focus();
                Swal.fire('Debit and Credit both none be zero!');
                e.preventdefault();
            }
            var date = document.getElementById('date').value;
            var VoucherNo = document.getElementById('voucher_no').value;
            var Type = document.getElementById('v_type').value;
            var HeadTitle = document.getElementById('account_head_id').value.split("_").pop();
            var HeadId = document.getElementById('account_head_id').value.split("_")[0];
            var Narration = document.getElementById('narration').value;
            var Debit = document.getElementById('debit').value;
            var Credit = document.getElementById('credit').value;

            var TotalDebit = document.getElementById('TotalDebit').value;
            var grandDebit = parseInt(Debit) + parseInt(TotalDebit);
            document.getElementById('TotalDebit').value = grandDebit;

            var TotalCredit = document.getElementById('TotalCredit').value;
            var grandCredit = parseInt(Credit) + parseInt(TotalCredit);
            document.getElementById('TotalCredit').value = grandCredit;

            var tableHtml = '<tr>';
            tableHtml +=
                '<td class="text-center"><i onclick="javascript:myDeleteFunction($(this).closest(\'tr\'));" class="icon-cancel icon-larger red-color" title="Delete Row"></i> </td>';
            tableHtml += '<td style="display:none;">' + HeadId + '</td>';
            tableHtml += '<td>' + date + '</td>';
            tableHtml += '<td>' + VoucherNo + '</td>';
            tableHtml += '<td style="display:none;">' + Type + '</td>';
            tableHtml += '<td>' + HeadTitle + '</td>';
            tableHtml += '<td>' + Narration + '</td>';
            tableHtml += '<td>' + Debit + '</td>';
            tableHtml += '<td>' + Credit + '</td>';
            tableHtml += '</tr>';
            $('#GridTable').append(tableHtml);
            document.getElementById("date").focus();
        }

        // function TotalRecords() {
        // 	var rowCount = document.getElementById('myTable').rows.length;
        // 	alert("Total Number of Records Are: " + rowCount);
        // }

        function PartyKeyUp(partyId) {
            $.ajax({
                type: "GET",
                url: "{{ asset('partyonchange-ajax') }}?party_id=" + partyId,
                success: function(result) {
                    if (result.length > 0) {
                        $('#party_id').val(result[0].id);
                        $('#address').val(result[0].address);
                        $('#strn').val(result[0].strn);
                        $('#ntn').val(result[0].ntn);
                    }
                }
            })
        }

        function myDeleteFunction(row) {
            Swal.fire({
                    title: "Are You Sure?",
                    text: "Confirm Transaction?",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonText: 'Yes, Create it!',
                    confirmButtonColor: '#28A745',
                    cancelButtonText: 'No, cancel!',
                    cancelButtonColor: '#DC3545',
                }).then((result) => {
                    if (result.isConfirmed) {
                    var TotalDebit = document.getElementById('TotalDebit').value;
                    var CurrentDebit = $(row).find("td:eq('7')").text();
                    // alert(CurrentDebit)
                    var grand = parseInt(TotalDebit) - parseInt(CurrentDebit);
                    document.getElementById('TotalDebit').value = grand;

                    var TotalCredit = document.getElementById('TotalCredit').value;
                    var CurrentCredit = $(row).find("td:eq('8')").text();
                    var grandcredit = parseInt(TotalCredit) - parseInt(CurrentCredit);
                    document.getElementById('TotalCredit').value = grandcredit;
                    $(row).remove();
                    //alertify.alert("Row is Removed!");
                }
            });
            // if(confirm("Are you sure you want to delete this row?"))
            // {
            // 	$(row).remove();
            // }
        }

        $("#btnSave").click(function() {
            Swal.fire({
                    title: "Are You Sure?",
                    text: "Confirm Transaction?",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonText: 'Yes, Create it!',
                    confirmButtonColor: '#28A745',
                    cancelButtonText: 'No, cancel!',
                    cancelButtonColor: '#DC3545',
                }).then((result) => {
                    if (result.isConfirmed) {
            var voucher = new Object();
            voucher.voucher_no = $("#voucher_no").val();
            voucher.voucher_date = $("#voucher_date").val();
            voucher.v_type = $("#v_type").val();
            voucher.biller = $("#biller").val();
            voucher.company_id = $('#company_id').val();

            var products = [];
            $.each($("#GridTable tr"), function(index, row) {
                var columns = $(row).find("td");
                var product = new Object();
                // product.party_id = $("#party_id").val();
                product.head_id = $(columns[1]).text();
                product.date = $(columns[2]).text();
                product.voucher_no = $(columns[3]).text();
                product.v_type = $(columns[4]).text();
                product.narration = $(columns[6]).text();
                product.debit = $(columns[7]).text();
                product.credit = $(columns[8]).text();
                product.company_id = $('#company_id').val();
                products.push(product);
            });

            var $_token = jQuery('#token').val();
            if(products != ""){
            jQuery.ajax({
                url: "{{ asset('general-voucher') }}",
                method: "POST",
                cache: false,
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                data: {
                    voucher: JSON.stringify(voucher),
                    product_data: products
                },
                success: function(result) {
                    if (result == "saved")
                    //if(parseInt(result) > 0)
                    {
                        Swal.fire({
                        position: 'center',
                        icon: 'success',
                        title: 'Transaction Submitted!',
                        showConfirmButton: false,
                        timer: 1500
                        })
                        //window.open("/sales/print/"+result);
                        window.location.href = "{{ asset('general-voucher/create') }}";
                    }
                },
                error: function(xhr, ajaxOptions, thrownError) {
                    $("#spanWait").hide();
                    alert(xhr.status);
                    alert(thrownError);
                }
            });
                } else {
                    document.getElementById("date").focus();
                    Swal.fire('Add your Account in Grid');
                    
                }
            }
            });
        });

        //Select Account Type, SHow Related Acccounts
        $('#account_type').change(function() {
            var account_type = $(this).val();
            $.ajax({
                url: "{{ asset('get_account_group_parties') }}?id=" + account_type,
                type: 'get',
                dataType: 'json',
                success: function(response) {
                    console.log(response);
                    if (response.length == 0) {
                        $('#select2-account_head_id-container').text('Account Not Found');
                        $('#account_head_id').html('<option>Account Not Found</option>');
                    } else {
                        $('#select2-account_head_id-container').text('Select Value');
                        var str=`<option value="">Select Value</option>`;
                        $.each(response, function(i, v) {
                            str +=
                                `<option value="${v.id+'_'+v.party_name}">${v.party_name}</option>`;
                        });

                        $('#account_head_id').html(str);
                        $('#account_head_id').select2('open');
                    }
                }
            });
        });
        // End Here
    </script>
@stop
