<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>FBR Digital Invoicing System – e-Invoicing & Fast Tax Compliance</title>
    <meta name="description" content="FBR-approved digital invoicing system for Pakistan. Generate compliant e-invoices, file GST & sales tax fast, and meet FBR tax regulations seamlessly.">
    <meta name="keywords" content="FBR Digital Invoice, FBR e-Invoicing, Pakistan tax compliance, FBR invoice system, sales tax filing, GST invoicing, FBR registered invoice, digital tax invoice Pakistan">
    <style>
        :root {
            --fbr-blue: #005baa;
            --fbr-green: #2e7d32;
            --fbr-orange: #ff9800;
            --text-light: #ffffff;
            --text-dark: #333333;
            --topbar-bg: #003366;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        /* TOP CONTACT BAR */
        .top-contact-bar {
            background-color: var(--topbar-bg);
            color: var(--text-light);
            padding: 0.5rem 0;
            font-size: 0.9rem;
        }
        
        .contact-container {
            display: flex;
            justify-content: flex-end;
            align-items: center;
            flex-wrap: wrap;
            gap: 1.5rem;
        }
        
        .contact-item {
            display: flex;
            align-items: center;
        }
        
        .contact-item i {
            margin-right: 0.5rem;
            color: var(--fbr-orange);
        }
        
        .contact-item a {
            color: var(--text-light);
            text-decoration: none;
            transition: all 0.3s ease;
        }
        
        .contact-item a:hover {
            color: var(--fbr-orange);
        }
        
        /* Floating Buttons */
        .float-btn {
            position: fixed;
            width: 60px;
            height: 60px;
            bottom: 40px;
            border-radius: 50%;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 24px;
            z-index: 100;
            transition: all 0.3s ease;
        }
        
        .float-btn:hover {
            transform: scale(1.1);
        }
        
        .whatsapp-btn {
            right: 40px;
            background-color: #25D366;
            color: white;
        }
        
        .contact-btn {
            left: 40px;
            background-color: var(--fbr-orange);
            color: white;
        }
        
        /* Rest of your existing CSS remains the same */
        body {
            line-height: 1.6;
            color: var(--text-dark);
            background-color: #f5f5f5;
            padding-bottom: 80px; /* Space for floating buttons */
        }
        
        header {
            /* background: linear-gradient(135deg, var(--fbr-blue), #003366); */
            background: linear-gradient(135deg, #ffffff, #005baa);
            color: var(--text-light);
            padding: 1rem 0;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
        }
        
        .container {
            width: 90%;
            max-width: 1200px;
            margin: 0 auto;
        }
        
        .header-content {
            display: flex;
            justify-content: space-between;
            align-items: center;
            flex-wrap: wrap;
        }
        
        .logo {
            height: 70px;
        }
        
        nav ul {
            display: flex;
            list-style: none;
        }
        
        nav ul li {
            margin-left: 1.5rem;
        }
        
        nav ul li a {
            color: var(--text-light);
            text-decoration: none;
            font-weight: 500;
            transition: all 0.3s ease;
        }
        
        nav ul li a:hover {
            color: var(--fbr-orange);
        }
        
        .hero {
            background: url('https://via.placeholder.com/1920x600') no-repeat center center/cover;
            height: 400px;
            display: flex;
            align-items: center;
            text-align: center;
            color: var(--text-light);
            position: relative;
        }
        
        .hero::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.6);
        }
        
        .hero-content {
            position: relative;
            z-index: 1;
            width: 100%;
            padding: 2rem;
        }
        
        .hero h1 {
            font-size: 2.5rem;
            margin-bottom: 1rem;
        }
        
        .btn {
            display: inline-block;
            background-color: var(--fbr-orange);
            color: var(--text-light);
            padding: 0.8rem 1.8rem;
            text-decoration: none;
            border-radius: 4px;
            font-weight: bold;
            margin-top: 1rem;
            transition: all 0.3s ease;
        }
        
        .btn:hover {
            background-color: #e68a00;
            transform: translateY(-2px);
        }
        
        section {
            padding: 3rem 0;
        }
        
        .section-title {
            text-align: center;
            margin-bottom: 2rem;
            color: var(--fbr-blue);
        }
        
        .features {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 2rem;
            margin: 2rem 0;
        }
        
        .feature-card {
            background: var(--text-light);
            border-radius: 8px;
            padding: 1.5rem;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            transition: transform 0.3s ease;
        }
        
        .feature-card:hover {
            transform: translateY(-5px);
        }
        
        .feature-card h3 {
            color: var(--fbr-blue);
            margin-bottom: 1rem;
        }
        
        .feature-icon {
            font-size: 2.5rem;
            color: var(--fbr-green);
            margin-bottom: 1rem;
        }
        
        .compliance-section {
            background-color: var(--fbr-blue);
            color: var(--text-light);
            padding: 3rem 0;
        }
        
        .compliance-content {
            display: flex;
            flex-wrap: wrap;
            align-items: center;
            justify-content: space-between;
        }
        
        .compliance-text {
            flex: 1;
            min-width: 300px;
            padding-right: 2rem;
        }
        
        .compliance-image {
            flex: 1;
            min-width: 300px;
            text-align: center;
        }
        
        .compliance-image img {
            max-width: 100%;
            border-radius: 8px;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.2);
        }
        
        .steps {
            margin: 2rem 0;
        }
        
        .step {
            display: flex;
            margin-bottom: 1.5rem;
            align-items: flex-start;
        }
        
        .step-number {
            background-color: var(--fbr-orange);
            color: var(--text-light);
            width: 30px;
            height: 30px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-right: 1rem;
            flex-shrink: 0;
        }
        
        footer {
            background-color: var(--text-dark);
            color: var(--text-light);
            padding: 2rem 0;
            text-align: center;
        }
        
        .footer-links {
            display: flex;
            justify-content: center;
            flex-wrap: wrap;
            margin: 1rem 0;
        }
        
        .footer-links a {
            color: var(--text-light);
            margin: 0 1rem;
            text-decoration: none;
        }
        
        .footer-links a:hover {
            color: var(--fbr-orange);
        }
        
        @media (max-width: 768px) {
            .header-content {
                flex-direction: column;
                text-align: center;
            }
            
            nav ul {
                margin-top: 1rem;
                justify-content: center;
            }
            
            nav ul li {
                margin: 0 0.75rem;
            }
            
            .hero {
                height: 300px;
            }
            
            .hero h1 {
                font-size: 2rem;
            }
            
            .compliance-content {
                flex-direction: column;
            }
            
            .compliance-text {
                padding-right: 0;
                margin-bottom: 2rem;
            }
            
            /* Adjust floating buttons for mobile */
            .float-btn {
                width: 50px;
                height: 50px;
                font-size: 20px;
                bottom: 20px;
            }
            
            .whatsapp-btn {
                right: 20px;
            }
            
            .contact-btn {
                left: 20px;
            }
            
            /* Top contact bar mobile */
            .contact-container {
                justify-content: center;
                gap: 1rem;
            }
            
            .contact-item {
                font-size: 0.8rem;
            }
        }
    </style>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
</head>
<body>
    <!-- Top Contact Bar -->
    <div class="top-contact-bar">
        <div class="container contact-container">
            <div class="contact-item">
                <i class="fas fa-phone-alt"></i>
                <a href="tel:+92123456789">+92 321 4197290</a>
            </div>
            <div class="contact-item">
                <i class="fab fa-whatsapp"></i>
                <a href="https://wa.me/923214197290" target="_blank">+92 321 4197290</a>
            </div>
            <div class="contact-item">
                <i class="fas fa-envelope"></i>
                <a href="mailto:info@fbrdigitalinvoice.pk">info@fbrdigitalinvoice.pk</a>
            </div>
        </div>
    </div>

    <!-- Floating WhatsApp Button -->
    <a href="https://wa.me/923214197290" class="float-btn whatsapp-btn" target="_blank">
        <i class="fab fa-whatsapp"></i>
    </a>
    
    <!-- Floating Contact Button -->
    <!-- <a href="#contact" class="float-btn contact-btn">
        <i class="fas fa-headset"></i>
    </a> -->

    <header>
        <div class="container header-content">
            <!-- Official FBR Logo from their website -->
            <img src="{{ asset('images/fbrlogo.jpg') }}" alt="FBR Logo" class="logo" style="height: 70px;">
            <nav>
                <ul>
                    <li><a href="#home">Home</a></li>
                    <li><a href="#features">Features</a></li>
                    <li><a href="#compliance">Compliance</a></li>
                    <li><a href="#registration">Registration</a></li>
                    <li><a href="#contact">Contact</a></li>
                </ul>
            </nav>
        </div>
    </header>

    <section id="home" class="hero">
        <div class="hero-content">
            <h1>FBR Digital Invoicing System</h1>
            <p>Providing FBR-compliant digital invoicing solutions all over Pakistan.</p>
            <a href="{{asset('login')}}" class="btn">Login Now</a>
        </div>
    </section>

    <section id="features" class="container">
        <h2 class="section-title">Key Features</h2>
        <div class="features">
            <div class="feature-card">
                <div class="feature-icon">
                    <i class="fas fa-bolt"></i>
                </div>
                <h3>Real-Time Invoicing</h3>
                <p>Automatically transmit invoice data to FBR in real-time for seamless tax compliance and transparency.</p>
            </div>
            <div class="feature-card">
                <div class="feature-icon">
                    <i class="fas fa-shield-alt"></i>
                </div>
                <h3>Secure & Tamper-Proof</h3>
                <p>Digitally signed invoices with unique QR codes and cryptographic security to prevent fraud.</p>
            </div>
            <div class="feature-card">
                <div class="feature-icon">
                    <i class="fas fa-mobile-alt"></i>
                </div>
                <h3>Mobile Friendly</h3>
                <p>Generate, validate, and manage invoices from anywhere using our mobile-responsive platform.</p>
            </div>
        </div>
    </section>

    <section id="compliance" class="compliance-section">
        <div class="container compliance-content">
            <div class="compliance-text">
                <h2>FBR Compliance Made Simple</h2>
                <p>The FBR Digital Invoicing System is fully compliant with Pakistan's Sales Tax Act and Income Tax Ordinance. Our platform ensures you meet all regulatory requirements effortlessly.</p>
                
                <div class="steps">
                    <div class="step">
                        <div class="step-number">1</div>
                        <div>
                            <h3>Registration</h3>
                            <p>Enroll your business with FBR and obtain your unique digital invoicing credentials.</p>
                        </div>
                    </div>
                    <div class="step">
                        <div class="step-number">2</div>
                        <div>
                            <h3>Integration</h3>
                            <p>Connect your existing accounting software or use our web portal.</p>
                        </div>
                    </div>
                    <div class="step">
                        <div class="step-number">3</div>
                        <div>
                            <h3>Compliance</h3>
                            <p>Generate FBR-approved invoices that automatically report to tax authorities.</p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="compliance-image">
                <img src="https://via.placeholder.com/500x350?text=FBR+Compliance+Diagram" alt="FBR Compliance Process">
            </div>
        </div>
    </section>

    <!-- <section id="registration" class="container">
        <h2 class="section-title">Get Started Today</h2>
        <div style="max-width: 800px; margin: 0 auto; background: white; padding: 2rem; border-radius: 8px; box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);">
            <h3 style="color: var(--fbr-blue); margin-bottom: 1.5rem; text-align: center;">Register for FBR Digital Invoicing</h3>
            
            @if(session('success'))
                <div class="alert alert-success" style="padding: 1rem; margin-bottom: 1.5rem; background: #d4edda; color: #155724; border-radius: 4px;">
                    {{ session('success') }}
                </div>
            @endif
            
            @if($errors->any())
                <div class="alert alert-danger" style="padding: 1rem; margin-bottom: 1.5rem; background: #f8d7da; color: #721c24; border-radius: 4px;">
                    <ul style="margin: 0; padding-left: 1.5rem;">
                        @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <form method="post" action="{{ route('form.submit') }}">
                @csrf
                <div style="margin-bottom: 1rem;">
                    <label for="business_name" style="display: block; margin-bottom: 0.5rem; font-weight: 500;">Business Name</label>
                    <input type="text" id="business_name" name="business_name" 
                        value="{{ old('business_name') }}"
                        style="width: 100%; padding: 0.8rem; border: 1px solid #ddd; border-radius: 4px;"
                        required>
                </div>
                <div style="margin-bottom: 1rem;">
                    <label for="ntn_number" style="display: block; margin-bottom: 0.5rem; font-weight: 500;">NTN Number</label>
                    <input type="text" id="ntn_number" name="ntn_number" 
                        value="{{ old('ntn_number') }}"
                        style="width: 100%; padding: 0.8rem; border: 1px solid #ddd; border-radius: 4px;" required>
                </div>
                <div style="margin-bottom: 1rem;">
                    <label for="email" style="display: block; margin-bottom: 0.5rem; font-weight: 500;">Email Address</label>
                    <input type="email" id="email" name="email" 
                        value="{{ old('email') }}"
                        style="width: 100%; padding: 0.8rem; border: 1px solid #ddd; border-radius: 4px;"
                        required>
                </div>
                <div style="margin-bottom: 1.5rem;">
                    <label for="phone" style="display: block; margin-bottom: 0.5rem; font-weight: 500;">Phone Number</label>
                    <input type="tel" id="phone" name="phone" 
                        value="{{ old('phone') }}"
                        style="width: 100%; padding: 0.8rem; border: 1px solid #ddd; border-radius: 4px;"
                        required>
                </div>
                <button type="submit" style="background-color: var(--fbr-orange); color: white; border: none; padding: 1rem 2rem; border-radius: 4px; font-weight: bold; cursor: pointer; width: 100%;">Submit Registration</button>
            </form>
        </div>
    </section> -->

    <footer id="contact">
        <div class="container">
            <img src="{{ asset('images/fbrlogo.jpg') }}" alt="FBR Logo" style="height: 50px; margin-bottom: 1rem;">
            <!-- <div class="footer-links">
                <a href="#privacy">Privacy Policy</a>
                <a href="#terms">Terms of Service</a>
                <a href="#faq">FAQs</a>
                <a href="#contact">Contact Support</a>
            </div> -->
            <p style="margin-top: 1rem;">Federal Board of Revenue, Government of Pakistan</p>
            <p>© 2025 FBR Digital Invoicing System. All rights reserved.</p>
        </div>
    </footer>
</body>
</html>