@extends("app")

<head>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.3/css/select2.min.css" rel="stylesheet" />
    <link rel="stylesheet" href="https://ajax.googleapis.com/ajax/libs/jqueryui/1.8.9/themes/base/jquery-ui.css"
        type="text/css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/chosen/1.5.1/chosen.min.css">
    <meta name="csrf-token" content="{{ csrf_token() }}" />
</head>
@section('contents')
    <!-- <body onload="AddRowFunction()"> -->

    <body>
        <div class="container-fluid">
            @if (Session::has('flash_message'))
                <button type="button" class="close" data-dismiss="alert" aria-hidden="true"
                    style="margin-right: 20px;margin-top: 15px;">&times;</button>
                <div class="alert alert-success"> {{ Session::get('flash_message') }} </div>
            @endif
        </div>
        <div class="row">
            <div class="col-lg-12">
                <div class="panel panel-default">
                    <div class="panel-heading clearfix" id="panelbg">
                        <h2 class="panel-title"><b>Edit Cash Receipt</b></h2>
                    </div>
                    <div class="panel-body">
                        <input id="token" type="hidden" value="{{ $encrypted_token }}">
                        @include('errors.validation')
                        {!! Form::model($edit, ['method' => 'PATCH', 'action' => ['App\Http\Controllers\CashReceiptController@update', $edit->id], 'class' => 'form-horizontal']) !!}
                        {!! Form::hidden('company_id', session()->get('company_id'), ['id' => 'company_id']) !!}
                        {!! Form::hidden('shop_id', null, ['id' => 'shop_id', 'class' => 'form-control']) !!}
                        {!! Form::hidden('biller', null, ['id' => 'biller', 'class' => 'form-control']) !!}

                        <div class="row">
                            <div class="form-group" style="margin-left: 1%; margin-right: 1%;">
                                <label class="col-sm-1 control-label">Vr. No</label>
                                <div class="col-sm-2">
                                    <div id="year-view" class="input-group date">
                                        {!! Form::text('voucher_no', null, ['id' => 'voucher_no', 'class' => 'form-control', 'disabled' => 'disabled']) !!}
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group" style="margin-left: 1%; margin-right: 1%;">
                                <label class="col-sm-1 control-label">Vr. Date</label>
                                <div class="col-sm-2">
                                    <div id="year-view" class="input-group date">
                                        <input id="voucher_date" type="date" name="voucher_date" value="<?php echo date('Y-m-d'); ?>"
                                            class="form-control">
                                        <!-- <span class="input-group-addon"><i class="fa fa-calendar"></i></span>  -->
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row" style="display: none;">
                            <div class="form-group" style="margin-left: 1%; margin-right: 1%;">
                                <label class="col-sm-1 control-label">Voucher Type</label>
                                <div class="col-sm-5" style="height: 40px;">
                                    {!! Form::text('v_type', 'Cash Receipt', ['id' => 'v_type', 'class' => 'form-control']) !!}
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group" style="margin-left: 1%; margin-right: 1%;">
                                <label class="col-sm-1 control-label">Cash&nbsp;Account</label>
                                <div class="col-sm-3" style="height: 40px;">
                                    {!! Form::select('account_id', $cashAccount, null, ['id' => 'account_id', 'class' => 'form-control']) !!}
                                </div>
                            </div>
                        </div>
                        <!-- <div class="row" style="display:none;">
                    <div class="form-group" style="margin-left: 1%; margin-right: 1%;">
                     <label class="col-sm-1 control-label">Biller</label>
                     <div class="col-sm-3" style="height: 40px;">
                     <select name="biller" id="biller" class="form-control" disabled>
                     <option value="{{ Auth::user()->id }}">{{ Auth::user()->name }}</option>
                    </select>
                     </div>
                    </div>
                   </div> -->
                        <div class="panel panel-default">
                            <div class="panel-body">
                                <div class="form-group">
                                    <table>
                                        <div class="container-fluid">
                                            <div class="row" id="myTable">
                                                <tr>

                                                    <!-- <div class="col-md-3">
                 <div class="form-group">
                  <label for="H.S" class="control-label">Id</label> -->
                                                    {!! Form::hidden('product_id', null, ['id' => 'product_id', 'class' => 'form-control']) !!}
                                                    <!-- </div>
                </div>  -->
                                                    <div class="col-md-2" style="margin-left: 1%; margin-right: 1%;">
                                                        <div class="form-group">
                                                            <label for="H.S" class="control-label">Date</label>
                                                            <input id="date" type="date" name="date"
                                                                value="<?php echo date('Y-m-d'); ?>" class="form-control"
                                                                onkeyup="if(event.keyCode == 13) SaveFunction()" autofocus>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-1"
                                                        style="display:none; margin-left: 1%; margin-right: 1%;">
                                                        <div class="form-group">
                                                            <label for="password"
                                                                class="control-label">Voucher&nbsp;No</label>
                                                            {!! Form::text('voucher_no', $codes, ['id' => 'voucher_no', 'class' => 'form-control']) !!}
                                                        </div>
                                                    </div>
                                                    <div class="col-md-2" style="display:none;">
                                                        <div class="form-group">
                                                            <label for="password" class="control-label">Type</label>
                                                            {!! Form::text('v_type', 'Cash Receipt', ['id' => 'v_type', 'class' => 'form-control']) !!}
                                                        </div>
                                                    </div>
                                                    <div class="col-md-1">
                                                        <div class="form-group">
                                                            <label for="Name"
                                                                class="control-label">Account Type</label>
                                                            {!! Form::select('account_type', $accountGroups, null, ['id' => 'account_type', 'class' => 'form-control']) !!}
                                                        </div>
                                                    </div>
                                                    <div class="col-md-3" style="margin-left: 1%; margin-right: 1%;">
                                                        <div class="form-group">
                                                            <label for="Name"
                                                                class="control-label">Party&nbsp;/&nbsp;Customer</label>
                                                            {!! Form::select('account_head_id', $Accounts, null, ['id' => 'account_head_id', 'class' => 'form-control']) !!}
                                                        </div>
                                                    </div>
                                                    <div class="col-md-2" style="margin-left: 1%; margin-right: 1%;">
                                                        <div class="form-group">
                                                            <label for="password" class="control-label">Narration</label>
                                                            {!! Form::text('narration', 'CASH RECIEVED', ['id' => 'narration', 'class' => 'form-control']) !!}
                                                        </div>
                                                    </div>
                                                    <div class="col-md-2" style="margin-left: 1%; margin-right: 1%;">
                                                        <div class="form-group">
                                                            <label for="password" class="control-label">Amount</label>
                                                            {!! Form::text('amount', null, ['id' => 'amount', 'class' => 'form-control', 'onfocus' => 'this.value=""']) !!}
                                                        </div>
                                                    </div>
                                                    <!-- <div class="col-md-2">
                 <div class="form-group">
                  <label for="password" class="control-label">Credit</label>
                  {!! Form::text('credit', 0, ['id' => 'credit', 'class' => 'form-control']) !!}
                 </div>
                </div> -->
                                                    <div class="col-md-1">
                                                        <div class="form-group">
                                                            <label for="password" class="control-label">Add</label>
                                                            <button class="form-control" type="button"
                                                                class="btn btn-red" onkeyup="AddGridData();"
                                                                style="background: #e20707;">Add</button>
                                                        </div>
                                                    </div>
                                                </tr>
                                            </div></br>
                                            <table id="myData">
                                                <?php $totalRate = 0;
                                                $totalAmount = 0; ?>
                                                @foreach ($edit->voucher_details as $details)
                                                    @if ($details->credit != null)
                                                        <tr>
                                                            <td style="display:none;">
                                                                <input id="account_head_id"
                                                                    value="{{ $details->account_head_id }}" type="text"
                                                                    class="form-control" disabled>
                                                            </td>
                                                            <td style="margin-left: 1%; margin-right: 1%; padding-top:2%">
                                                                <input id="product_id" value="{{ $details->date }}"
                                                                    style="margin-left: 7%; width: 107%;" type="text"
                                                                    class="form-control" disabled>
                                                            </td>
                                                            <td style="display:none;">
                                                                <input id="voucher_no" value="{{ $details->voucher_no }}"
                                                                    type="text" class="form-control" disabled>
                                                            </td>
                                                            <td style="display:none;">
                                                                <input id="v_type" value="Cash Receipt" type="text"
                                                                    class="form-control" disabled>
                                                            </td>
                                                            <td style="margin-left: 1%; margin-right: 1%; padding-top:2%">
                                                                <input id="account_head_name"
                                                                    value="{{ $details->parties->party_name }}"
                                                                    style="margin-left: 22%; width: 165%;" type="text"
                                                                    class="form-control" disabled>
                                                            </td>
                                                            <td style="margin-left: 1%; margin-right: 1%; padding-top:2%">
                                                                <input id="product_id" value="{{ $details->narration }}"
                                                                    style="margin-left: 101%; width: 106%;" type="text"
                                                                    class="form-control">
                                                            </td>
                                                            <td style="margin-left: 1%; margin-right: 1%; padding-top:2%">
                                                                <input id="product_id" value="{{ $details->credit }}"
                                                                    style="margin-left: 120%; width: 108%;" type="text"
                                                                    class="form-control">
                                                            </td>
                                                            <td style="padding-top:2%"><button class="btn btn-red"
                                                                    type="button"
                                                                    style="margin-left: 655%; margin-top: -29%;"> <i
                                                                        onclick="javascript:myDeleteFunction($(this).closest('tr'));"
                                                                        class="icon-trash"
                                                                        title="Delete Row"></i></button></td>

                                                            <?php $totalAmount = $totalAmount + $details->credit; ?>

                                                            <!-- <div class="col-md-1" style="display:none; margin-left: 1%; margin-right: 1%;">
                 <div class="form-group">
                  <label for="password" class="control-label">Voucher&nbsp;No</label>
                  <input id="account_head_id" value="{{ $details->account_head_id }}" type="account_head_id" class="form-control"style="" disabled>
                 </div>
                </div>
                <div class="col-md-2" style="display:none;">
                 <div class="form-group">
                  <label for="password" class="control-label">Type</label>
                  {!! Form::text('v_type', 'Cash Receipt', ['id' => 'v_type', 'class' => 'form-control']) !!}
                 </div>
                </div>
                <td style="padding-top:20px;">
                 <input id="test" value="{{ $details->parties->party_name }}" type="text" class="form-control" style="margin-left: 60%;
                 width: 79%;" disabled>
                  </td>
                <div class="col-md-3" style="margin-left: 1%; margin-right: 1%;">
                 <div class="form-group">
                  <input id="date" value="{{ $details->parties->party_name }}" type="text" class="form-control" style="" disabled>
                 </div>
                </div>
                <div class="col-md-2" style="margin-left: 1%; margin-right: 1%;">
                 <div class="form-group">
                  <input id="date" value="{{ $details->narration }}" type="text" class="form-control"style="" disabled>
                 </div>
                </div>
                <div class="col-md-2" style="margin-left: 1%; margin-right: 1%;">
                 <div class="form-group">
                  <input id="date" value="{{ $details->credit }}" type="text" class="form-control"style="" disabled>
                 </div>
                </div> -->
                                                            <!--  <div class="col-md-1">
                 <div class="form-group">
                  <button class="btn btn-red" type="button"> <i onclick="javascript:myDeleteFunction($(this).closest('tr'));" class="icon-trash" title="Delete Row"></i></button>

                 </div>
                </div> -->

                                                        </tr> </br>
                                                    @endif
                                                @endforeach

                                            </table>
                                        </div>
                                    </table></br></br>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="panel panel-default">
                                    <div class="panel-heading clearfix" id="panelbg">
                                        <div class="container">
                                            <div class="col-lg-5"> </div>
                                            <!-- <div class="col-xs-3">  </div> -->
                                            <!-- <div class="col-xs-3"> <b>Total Rate</b> <input type="text" id="TotalRate" name="TotalRate" value="{{ $totalRate }}" disabled	></div> -->
                                            <div class="col-lg-3"> <b>Total&nbsp;Amount</b> <input type="text"
                                                    id="TotalAmount" name="TotalAmount" value="{{ $totalAmount }}"
                                                    disabled> </div>
                                        </div>
                                    </div>
                                    <!-- 		<div class="panel-body">
                   <div class="table-responsive">
                    <table class="table table-bordered">
                     <thead>
                      <tr>
                       <th></th>
                       <th>Product&nbsp;ID</th>
                       <th>Code</th>
                       <th>Product&nbsp;Name</th>
                       <th>Cost</th>
                       <th>Quantity</th>
                       <th>Cost&nbsp;Amount</th>
                       <th>Sale&nbsp;Rate</th>
                       <th>Sale&nbsp;Amount</th>
                      </tr>
                     </thead>
                     <tbody id="GridTable">
                     
                     </tbody>
                    </table>
                   </div>
                  </div> -->
                                </div>
                            </div>
                        </div>
                        <center>
                            <div class="form-actions">
                                <button type="button" class="btn btn-primary" id="btnSave" name="btnSave">Save</button>
                            </div>
                        </center>
                        <!-- <div class="col-lg-3">
                    <button type="button" onclick="AddRowFunction()" class="btn btn-success"><i class="fa fa-plus"></i> </button>
                    <button type="button" onclick="AddGridData()" class="btn btn-success"><i class="fa fa-plus"></i> </button>
                    <button type="button" onclick="TotalRecords()" class="btn btn-success">Total Records</button>
                   </div> -->
                        {!! Form::close() !!}
                    </div>
                </div>
            </div>
        </div>
    </body>
@stop
@section('scripts')
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
    <script type="text/javascript" src="https://ajax.googleapis.com/ajax/libs/jqueryui/1.10.2/jquery-ui.min.js"></script>
    <script src="{{ asset('js/plugins/nouislider/nouislider.min.js') }}"></script>
    <!-- Input Mask-->
    <script src="{{ asset('js/plugins/jasny/jasny-bootstrap.min.js') }}"></script>
    <!-- Select2-->
    <script src="{{ asset('js/plugins/select2/select2.full.min.js') }}"></script>
    <!--Bootstrap ColorPicker-->
    <script src="{{ asset('js/plugins/colorpicker/bootstrap-colorpicker.min.js') }}"></script>
    <!--Bootstrap DatePicker-->
    <script src="{{ asset('js/plugins/datepicker/bootstrap-datepicker.js') }}"></script>

    <script src="{{ asset('js/plugins/select2/select2.full.min.js') }}"></script>
    <script type="text/javascript">
        // $("#account_head_id").select2();
        // $("#account_head_id").next(".select2").find(".select2-selection").focus(function() {
        //     $("#account_head_id").select2("open");
        // });

        $("#account_id").select2();
        $("#account_id").next(".select2").find(".select2-selection").focus(function() {
            $("#account_id").select2("open");
        });
    </script>

    <script type="text/javascript">
        function AddGridData() {
            if ($("#amount").val() == "" || $("#account_head_id").val() == "") {
                alert('Account Name or Amount Value Cant be Empty!');
                document.getElementById("amount").focus();
                e.preventdefault();
            }
            var date = document.getElementById('date').value;
            var VoucherNo = document.getElementById('voucher_no').value;
            var v_type = document.getElementById('v_type').value
            var HeadTitle = document.getElementById('account_head_id').value.split("_").pop();
            var HeadId = document.getElementById('account_head_id').value.split("_")[0];
            var Narration = document.getElementById('narration').value;
            var Amount = document.getElementById('amount').value;
            var TotalAmount = document.getElementById('TotalAmount').value;
            var grand = parseInt(Amount) + parseInt(TotalAmount);
            document.getElementById('TotalAmount').value = grand;
            // var Credit = document.getElementById('credit').value;
            var tableHtml = '</br><tr>';
            //1
            tableHtml +=
                `<td style="display:none;"><input id="product_id" value="${HeadId}" type="text" class="form-control" disabled></td>`;
            //2
            tableHtml +=
                `<td style="margin-left: 1%; margin-right: 1%; padding-top:2%;"><input id="product_id" value="${date}" style="margin-left: 7%; width: 107%;" type="text" class="form-control" disabled></td>`;
            //3
            tableHtml +=
                `<td style="display:none;"><input id="product_id" value="${VoucherNo}" type="text" class="form-control" disabled></td>`;
            //4
            tableHtml +=
                `<td style="display:none;"><input id="product_id" value="${v_type}" type="text" class="form-control" disabled></td>`;

            //5
            tableHtml +=
                `<td style="margin-left: 1%; margin-right: 1%; padding-top:2%;"><input id="product_id" value="${HeadTitle}" style="margin-left: 22%; width: 165%;" type="text" class="form-control" disabled></td>`;
            //6
            tableHtml +=
                `<td style="margin-left: 1%; margin-right: 1%; padding-top:2%;"><input id="product_id" value="${Narration}" style="margin-left: 101%; width: 106%;" type="text" class="form-control"></td>`;
            //7
            tableHtml +=
                `<td style="margin-left: 1%; margin-right: 1%; padding-top:2%;"><input id="product_id" value="${Amount}" style="margin-left: 120%; width: 108%;" type="text" class="form-control"></td>`;
            //7
            tableHtml +=
                '<td style="padding-top:2%;"><button class="btn btn-red" type="button" style="margin-left: 655%; margin-top: -29%;"> <i onclick="javascript:myDeleteFunction($(this).closest(\'tr\'));" class="icon-trash" title="Delete Row"></i></button></td>';
            tableHtml += '</tr>';
            $('#myData').append(tableHtml);
            document.getElementById("date").focus();
        }




        function myDeleteFunction(row) {
            alertify.confirm("Are you sure you want to delete this Record?", function(e) {
                if (e) {
                    var TotalAmount = document.getElementById('TotalAmount').value;
                    var CurrentValue = $(row).find("td:eq('6')").find('input').val();
                    var grand = parseInt(TotalAmount) - parseInt(CurrentValue);
                    document.getElementById('TotalAmount').value = grand;
                    $(row).remove();
                    //alertify.alert("Row is Removed!");
                } else {
                    alertify.alert("Row Not Deleted!");
                }
            });
        }

        // $("#btnSave").click(function()
        function SaveFunction() {
            alertify.confirm("Are you sure you want update Cash Receipt Voucher?", function(e) {
                if (e) {
                    var voucher = new Object();
                    voucher.account_id = $("#account_id").val().split("_")[0];
                    voucher.shop_id = $("#shop_id").val();
                    voucher.voucher_no = $("#voucher_no").val();
                    voucher.voucher_date = $("#voucher_date").val();
                    voucher.v_type = $("#v_type").val();
                    voucher.biller = $("#biller").val();
                    voucher.company_id = $('#company_id').val();


                    var products = [];
                    $.each($("#myData tr"), function(index, row) {
                        var columns = $(row).find("td");
                        var product = new Object();
                        // product.party_id = $("#party_id").val();
                        product.head_id = $(columns[0]).find("input").val();
                        product.date = $(columns[1]).find("input").val();
                        product.voucher_no = $(columns[2]).find("input").val();
                        product.v_type = $(columns[3]).find("input").val();
                        product.narration = $(columns[5]).find("input").val();
                        product.amount = $(columns[6]).find("input").val();
                        product.company_id = $('#company_id').val();
                        products.push(product);
                    });

                    var $_token = jQuery('#token').val();
                    jQuery.ajax({
                        method: "PATCH",
                        cache: false,
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        data: {
                            voucher: JSON.stringify(voucher),
                            product_data: products
                        },
                        //url: "/cash-receipts",
                        url: "{{ asset('cash-receipts') }}/<?php echo $edit->id; ?>",

                        success: function(result) {
                            if (parseInt(result) > 0)
                            //if(parseInt(result) > 0)
                            {
                                //window.open("/sales/print/"+result);
                                window.location.href = "/{{ asset('cash-receipts') }}";
                                //alert("Cash Receipt successfully saved.");
                                //window.open("/sales/print/"+result);
                                //alert("Sale successfully saved.");
                                //Session::flash('flash_message', 'Sale Added Successfully!');
                                //window.location.href = "/sales";

                            }
                        },
                        error: function(xhr, ajaxOptions, thrownError) {
                            $("#spanWait").hide();
                            alert(xhr.status);
                            alert(thrownError);
                        }
                    });
                } else {
                    alertify.alert("Not Saved!");
                }
            });
        }


        

        //Select Account Type, SHow Related Acccounts
        $('#account_type').change(function(){
            var account_type = $(this).val();
            $.ajax({
                url:"{{ asset('get_account_group_parties') }}?id="+account_type,
                type:'get',
                dataType:'json',
                success:function(response){
                    if(response.length==0)
                    {
                        $('#select2-account_head_id-container').text('Account Not Found');
                        $('#account_head_id').html('<option>Account Not Found</option>');
                    }else{
                        var str = '';
                        $('#select2-account_head_id-container').text('Select Account');
                        $.each(response,function(i,v){
                            str+=`<option value="${v.id+'_'+v.party_name}">${v.party_name}</option>`;
                        });
  
                        $('#account_head_id').html(str);
                    }   
                }
            });
        });
        // End Here
    </script>
@stop
