<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Product;
use App\Models\Tax;
use App\Models\Party;
use App\Models\Scenario;
use App\Models\RawMaterialStock;
use App\Models\Companies;
use App\Models\SaleTypes;
use App\Models\Discount;
use App\Models\Setting;
use App\Models\Ledger;
use App\Models\DeliveryChallan;
use App\Models\SaleTax;
use App\Models\SaleTaxDetails;
use App\Models\GeneralVoucher;
use App\Models\LedgerDetailWise;
use App\Models\UOM;
use App\Models\StockRegisterSpecificItem;
use App\Models\SystemLogo;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use PDF;
use Carbon\Carbon;
use DateTime;

class CreditNoteController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    public function index()
    {
        // $sales = SaleTax::where('sale_type', 'SalesTax Invoice')->OrderBy('id', 'desc')->with(['saletax_details' => function ($query) {
        //     //$query->with('taxes');
        //     //$query->with('discount');
        //     //$query->with('parties');
        // }])->with('billers')->get();

        // return view('salestax.index', compact('sales'));

        $sales = SaleTax::OrderBy('id', 'desc')
        ->with(['saletax_details' => function ($query) {
            //$query->with('taxes');
            //$query->with('discount');
            //$query->with('parties');
        }])
        ->with('billers')
        ->where('company_id', session()->get('company_id'))
        ->where('sale_type','Credit Note')
        ->get();
    //return $sales;
    return view('credit-note.index', compact('sales'));

    }

    public function create()
    {
        //   $code = SaleTax::where('sale_type', 'SalesTax Invoice')->OrderBy('id', 'desc')->first();
        // //  $code = SaleTax::where('sale_type', 'Credit Note')->OrderBy('id', 'desc')->first();
        //  if (isset($code) > 0) {
        //      $codes = $code->invoice_no + 1;
        //  } else {
        //      $codes = 1;
        //  }
        $codes = 1;
        $code = SaleTax::where('company_id', session()->get('company_id'))
        ->where('sale_type', 'Credit Note')
            ->OrderBy('invoice_no', 'desc')
            ->first();
        //  return  $code;
        if (isset($code)) {
            $codes = $code->invoice_no + 1;
        }
        // $codes_new = 1;
        // $code_new = SaleTaxDetails::OrderBy('invoice_no', 'desc')
        //     ->first();
        // if (isset($code_new)) {
        //     $codes_new = $code_new->invoice_no + 1;
        // }

        $products = Product::where('company_id', session()->get('company_id'))
        ->select(DB::raw('CONCAT(`id`, "_", `product_code`, "_", `product_name`,"_", `tax`, "_", `product_price`,"_", `uom`) AS `id`, `product_code`, `product_name`,`tax`, `product_price`, `uom`'))
        ->OrderBy('id', 'asc')->pluck('product_name', 'id')
        ->prepend('Select Product', '0')
        ->toArray();
        $taxes = Tax::select(DB::raw('CONCAT(`id`, "_", `tax_rate`) AS `tax_rate`, `tax_title`'))->OrderBy('id', 'asc')->pluck('tax_title', 'tax_rate')->toArray();
        $discounts = Discount::select(DB::raw('CONCAT(`id`, "_", `discount`) AS `discount`, `title`'))->OrderBy('id', 'asc')->pluck('title', 'discount')->toArray();

        $customers = Party::where('company_id', session()->get('company_id'))
        // ->join('account_groups', 'account_groups.id', '=', 'parties.account_group_id')
            ->where('parties.account_group_id', '=', '1')
            ->orwhere('parties.account_group_id', '=', '7')
            ->OrderBy('party_name', 'asc')->pluck('party_name', 'parties.id')->prepend('Select Party', '0');
             $customers_address = Party::where('company_id', session()->get('company_id'))
            // ->join('account_groups', 'account_groups.id', '=', 'parties.account_group_id')
            ->where('parties.account_group_id', '=', '1')
            ->orwhere('parties.account_group_id', '=', '7')
            ->OrderBy('party_name', 'asc')
            // ->pluck('address', 'parties.id')
            ->first()
            ;

        $uoms = UOM::select(DB::raw('CONCAT(`id`, "_", `uom`) AS `id`, `uom`'))->OrderBy('id', 'asc')->pluck('uom', 'id')->toArray();
        $companyscenarios = Companies::where('id', session()->get('company_id'))->first('scenario');
        $decodedScenarios = json_decode($companyscenarios->scenario, true);
         $scenarioCodes = array_column($decodedScenarios, 'scenario');

         $scenarios = Scenario::select('id', DB::raw('CONCAT(`name`, " - ", `sale_type`) AS `scenario_name`'))
              ->whereIn('name', $scenarioCodes)
              ->orderBy('name', 'asc')
              ->pluck('scenario_name', 'id')
              ->toArray();
        $encrypter = app('Illuminate\Encryption\Encrypter');
        $encrypted_token = $encrypter->encrypt(csrf_token());

        return view('credit-note.create', compact('customers','customers_address', 'products', 'taxes', 'discounts', 'codes', 'uoms', 'encrypted_token', 'scenarios'));

    }

    public function store(Request $request)
    { 
        $this->validate($request, [
            'ref_usin' => 'required',
            'product_id1' => 'required',
            // 'product_code' => 'required',
            'product_name' => 'required',
            'quantity' => 'required',
            'stvalue' => 'required',
            'price_per_unit' => 'required|numeric',

        ]);
        // return $request;
         $CompanyID = session()->get('company_id');
        // $purchase = json_decode($request->get('purchase'), true);
        $sellerCompany = Companies::where('id', $CompanyID)->first();
        $saletype = SaleTypes::where('id', $sellerCompany->sale_type)->first();
        $buyerCompany = Party::where('id', $request->party_id)->first();
        $scenario = Scenario::where('id', $request->scenario_id)->first();
        $products = $request->get('product_data');
        $saleTypeData = json_decode($saletype);
        $count = count($request->product_code);
        //  return $count;
        for ($i = 0; $i < $count; $i++) {
            $curl = curl_init();
            curl_setopt_array($curl, [
                // CURLOPT_URL => 'https://gw.fbr.gov.pk/pdi/v1/HS_UOM?hs_code=$request->product_code[$i]&annexure_id=3',
                CURLOPT_URL => 'https://gw.fbr.gov.pk/pdi/v1/HS_UOM?hs_code=' . urlencode($request->product_code[$i]) . '&annexure_id=3',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'GET',
                CURLOPT_HTTPHEADER => [
                    'Authorization: Bearer "' . $sellerCompany['sandbox_token'] . '"',
                    // 'Content-Type: application/json',
                    'Cookie: key=value; JSESSIONID=IYFCgbVx4GhV2E-MMPlepV3DlG8b0HU4N_la2DUA.i01-irisdmz56; cookiesession1=678B2A2CB3F1FF7FD24B6E462AB80DD1'
                ],
            ]);
            $response = curl_exec($curl);
            $uomData = json_decode($response, true);
            $items[] = [
                "hsCode" => $request->product_code[$i],
                "productDescription" => $request->product_name[$i],
                "rate" => $request->stvalue[$i].'%',
                "uoM" => $request->uom_id[$i],
                "quantity" => $request->quantity[$i],
                "totalValues" => $request->incvalue[$i],
                "valueSalesExcludingST" => $request->excvalue[$i],
                "fixedNotifiedValueOrRetailPrice" => $request->rate[$i],
                "salesTaxApplicable" => $request->taxvalue[$i],
                "salesTaxWithheldAtSource" => 0,
                "extraTax" => 0,
                "furtherTax" => $request->extraTaxValue[$i],
                "sroScheduleNo" => "",
                "fedPayable" => 0,
                "discount" => 0,
                "saleType" => $scenario->sale_type,
                "sroItemSerialNo" => ""
            ];
            $fbr_uom_id[] = $uomData[0]['uoM_ID'];
            $fbr_uom_desc[] = $uomData[0]['description'];
        }
        $fbr_uoms = [
            "fbr_uom_id" => array_map('strval', $fbr_uom_id),
            "fbr_uom_desc" => array_map('strval', $fbr_uom_desc)
        ];

      $payload = [
          "invoiceType" => "Debit Note",
        //   "invoiceType" => "Sale Invoice",
          "invoiceDate" => $request->date,
          "sellerBusinessName" => $sellerCompany['CompanyName'],
          "sellerProvince" => $sellerCompany['province'],
          "sellerAddress" => $sellerCompany['address'],
          "sellerNTNCNIC" => $sellerCompany['ntn'],
          "buyerNTNCNIC" => $buyerCompany->ntn,
          "buyerBusinessName" => $buyerCompany->party_name,
          "buyerProvince" => $buyerCompany->province,
          "buyerAddress" => $buyerCompany->address,
          "buyerRegistrationType" => $buyerCompany->customer_type,
          "scenarioId" => $scenario->name,
        //   "invoiceRefNo" => $request->ref_usin,
          "invoiceRefNo" => $request->ref_usin,
          "items" => $items  // This is where your dynamic items go
      ];
    //   return $payload;
      
      $headers = [
          'Content-Type: application/json',
          'Cookie: key=value; JSESSIONID=IYFCgbVx4GhV2E-MMPlepV3DlG8b0HU4N_la2DUA.i01-irisdmz56; cookiesession1=678B2A2CB3F1FF7FD24B6E462AB80DD1'
      ];
      
      // Only modify the Authorization line with condition
      if ($sellerCompany->invoice_type == "Live") {
          // return $sellerCompany;
          $headers[] = 'Authorization: Bearer ' . $sellerCompany->token;  // Without extra quotes
          $apiUrl = 'https://gw.fbr.gov.pk/di_data/v1/di/postinvoicedata';
      } else {
          $headers[] = 'Authorization: Bearer ' . $sellerCompany->sandbox_token;  // Fallback token
          $apiUrl = 'https://gw.fbr.gov.pk/di_data/v1/di/postinvoicedata_sb';
      }
      
      $curl = curl_init();
      curl_setopt_array($curl, [
          // CURLOPT_URL => 'https://gw.fbr.gov.pk/di_data/v1/di/postinvoicedata_sb',
          // CURLOPT_URL => 'https://gw.fbr.gov.pk/di_data/v1/di/postinvoicedata',
          CURLOPT_URL => $apiUrl,
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'POST',
          CURLOPT_POSTFIELDS => json_encode($payload),  // Convert entire payload to JSON
          CURLOPT_HTTPHEADER => $headers,
          // CURLOPT_HTTPHEADER => [
          //     'Authorization: Bearer "' . $sellerCompany['token'] . '"',
          //     'Content-Type: application/json',
          //     'Cookie: key=value; JSESSIONID=IYFCgbVx4GhV2E-MMPlepV3DlG8b0HU4N_la2DUA.i01-irisdmz56; cookiesession1=678B2A2CB3F1FF7FD24B6E462AB80DD1'
          // ],
      ]);
      
      $response = curl_exec($curl);
      curl_close($curl);
     
      // 3. Decode the JSON
      $responseData = json_decode($response, true);
    //    return $responseData;

      if(isset($responseData['validationResponse']['statusCode']) && 
      $responseData['validationResponse']['statusCode'] === '00') 
      {
        // return 
        $purchaseData = new SaleTax();
        $purchaseData->party_id = $request->party_id;
        $purchaseData->date = date('Y-m-d', strtotime($request->date));
        $purchaseData->sale_type = $request->sale_type;
        $purchaseData->invoice_no = $request->invoice_no;
        $purchaseData->fbr_invoice_no = $responseData['invoiceNumber'];
        $purchaseData->company_id = $CompanyID;
        $purchaseData->dcn_no = $request->dcn_no;
        $purchaseData->p_order = $request->p_order;
        $purchaseData->remarks = $request->remarks;
        $purchaseData->biller = Auth::User()->id;
        $purchaseData->ref_usin = $request->ref_usin;
        $purchaseData->save();
        $sum = "0";
        $count = count($request->product_code);
        // return $count;
        for ($i = 0; $i < $count; $i++) {
            $purchaseDetail = new SaleTaxDetails();
            $purchaseDetail->sale_id = $purchaseData->id;
            $purchaseDetail->date = $purchaseData->date;
            $purchaseDetail->invoice_no = $purchaseData->invoice_no;
            $purchaseDetail->fbr_invoice_no = $responseData['invoiceNumber']."-".$i+1;
            $purchaseDetail->sale_type1 = $request->sale_type;
            // $purchaseDetail->fbr_invoice_no = $request->fbr_invoice_no;
            $purchaseDetail->product_id = $request->product_id1[$i];
            $purchaseDetail->party_id = $request->party_id;
            $purchaseDetail->company_id = $CompanyID;
            $purchaseDetail->uom_id = $request->uom_id[$i];
            $purchaseDetail->fbr_uom_id = $fbr_uoms['fbr_uom_id'][$i];
            $purchaseDetail->fbr_uom_desc = $fbr_uoms['fbr_uom_desc'][$i];
            $purchaseDetail->status = "InvoiceOnly";
            $purchaseDetail->quantity = $request->quantity[$i];
            $purchaseDetail->rate = $request->rate[$i];
            $purchaseDetail->stvalue = $request->stvalue[$i];
            $purchaseDetail->taxvalue = $request->taxvalue[$i];
            $purchaseDetail->extratax = $request->extratax[$i] ?? 0;
            $purchaseDetail->extraTaxValue = $request->extraTaxValue[$i] ?? 0;
            $purchaseDetail->price = $request->excvalue[$i];
            $purchaseDetail->total = $request->incvalue[$i];
            $sum = $sum + $request->incvalue[$i];
            $purchaseDetail->save();


            $recipe = Product::where('id', $request->product_id1[$i])->first();
            // $product['product_id'];
            if ($recipe['has_recipe'] == "1") {
                $RawMaterial = new ProductionStock();
                $RawMaterial->pro_transfer_id = $purchaseData->id;
                $RawMaterial->company_id = $CompanyID;
                $RawMaterial->warehouse_id = 1;
                $RawMaterial->product_id = $request->product_id1[$i];
                $RawMaterial->uom_id = $request->uom_id[$i];
                $RawMaterial->date = $purchaseData->date;
                $RawMaterial->voucher_no = $purchaseData->invoice_no;
                $RawMaterial->cost_amount = $request->incvalue[$i];
                $RawMaterial->stockin = $request->quantity[$i];
                $RawMaterial->save();
            } else {
                $RawMaterial = new RawMaterialStock();
                $RawMaterial->transction_id = $purchaseData->id;
                $RawMaterial->type = $request->sale_type;
                $RawMaterial->party_id = $request->party_id;
                $RawMaterial->warehouse_id = 1;
                // $RawMaterial->sale_id = $purchaseData['id'];
                $RawMaterial->product_id = $request->product_id1[$i];
                $RawMaterial->uom_id = $request->uom_id[$i];
                $RawMaterial->date = $purchaseData->date;
                $RawMaterial->voucher_no = $purchaseData->invoice_no;
                // $RawMaterial->cost_amount = $product['cost_amount'];
                $RawMaterial->stockin = $request->quantity[$i];
                $RawMaterial->company_id = $CompanyID;
                $RawMaterial->save();
            }

                $vouchers = new GeneralVoucher();
                $vouchers->transaction_id = $purchaseData->id;
                $vouchers->account_head_id = $purchaseData['party_id'];
                $vouchers->warehouse_id = 1;
                $vouchers->date = $purchaseData->date;
                $vouchers->voucher_no = $purchaseData->invoice_no;
                $vouchers->v_type = $request->sale_type;
                $vouchers->company_id = $CompanyID;
                $vouchers->credit = $request->incvalue[$i];
                // $vouchers->debit = $sum;
                $vouchers->save();
   
                $vouchers = new GeneralVoucher();
                $vouchers->transaction_id = $purchaseData->id;
                $vouchers->account_head_id = 2;
                $vouchers->warehouse_id = 1;
                $vouchers->date = $purchaseData->date;
                $vouchers->voucher_no = $purchaseData->invoice_no;
                $vouchers->v_type = $request->sale_type;
                $vouchers->company_id = $CompanyID;
                $vouchers->debit = $request->incvalue[$i];
                // $vouchers->credit = $sum;
                $vouchers->save();

        }
        // Session::flash('error_message', 'FBR portal is upgrading! Kindly try again after sometime.');
        Session::flash('flash_message', 'Record Successfully Added!');
        return redirect('credit-note/create');

      } 
      else {
      // API Error
    //   return [
    //     'status' => 'error',
    //     'message' => $responseData['validationResponse']['error'] ?? 'Unknown API error',
    //     'code' => $responseData['validationResponse']['statusCode'] ?? 'UNKNOWN_CODE',
    //     'fullResponse' => $responseData // Optional: include for debugging
    //     Session::flash('flash_message', 'Failed with error message!');
    //     return redirect('salestax/create');

    //   ];
    // API Error Handling
    $errorMessage = $responseData['validationResponse']['error'] ?? 'Unknown API error';
    $errorCode = $responseData['validationResponse']['statusCode'] ?? 'UNKNOWN_CODE';
    
    // Set flash message for user feedback
    Session::flash('error', 'Failed with error: ' . $errorMessage);
    return redirect('credit-note/create');
    // Return error response (for API calls) or redirect (for web)
    return [
        'status' => 'error',
        'message' => $errorMessage,
        'code' => $errorCode,
        'fullResponse' => $responseData // Optional debugging info
    ];
      }


        Session::flash('flash_message', 'Record Successfully Added!');
        $url = "credit-note/print/" . $purchaseData->id;
        $urlindex = "credit-note/create";

        return "<script>window.open('" . $url . "', '_blank')</script>
        		<script>window.location.href='" . $urlindex . "';</script>";
    }

    public function show($id)
    {
        //
    }

    public function edit($id)
    {
        $purchase = SaleTax::with(['saletax_details' => function ($query) {
            $query->with('products');
            $query->with('uoms');
        }])->with('parties')->where('sale_taxes.id', '=', $id)->get();

        $DeliveryChallan = DeliveryChallan::where('status', '=', 'Pending')->OrderBy('dcn_no', 'asc')->pluck('dcn_no', 'dcn_no')->prepend('Select Challan', '0')->toArray();
        $edit = $purchase[0];
        // return $edit->id;
        $products = Product::select(DB::raw('CONCAT(`id`, "_", `product_name`) AS `id`, `product_name`'))->OrderBy('id', 'asc')->pluck('product_name', 'id')->prepend('Select Product', '0')->toArray();
        $customers = Party::join('account_groups', 'account_groups.id', '=', 'parties.account_group_id')
            ->where('parties.account_group_id', '=', '1')
            ->orwhere('parties.account_group_id', '=', '7')
            ->OrderBy('party_name', 'asc')->pluck('party_name', 'parties.id');
        $uoms = UOM::select(DB::raw('CONCAT(`id`, "_", `uom`) AS `id`, `uom`'))->OrderBy('id', 'asc')->pluck('uom', 'id')->toArray();
        $discounts = Discount::select(DB::raw('CONCAT(`id`, "_", `discount`) AS `discount`, `title`'))->OrderBy('id', 'asc')->pluck('title', 'discount')->toArray();
        $encrypter = app('Illuminate\Encryption\Encrypter');
        $encrypted_token = $encrypter->encrypt(csrf_token());
        return view('credit-note.edit', compact('edit', 'products', 'DeliveryChallan', 'customers', 'encrypted_token', 'uoms', 'discounts'));
    }

    public function update(Request $request, $id)
    {
        $objPurchase = SaleTax::findOrFail($id);

        $objPurchase->party_id = $request->party_id;
        $objPurchase->date = date('d/m/Y', strtotime($request->date));
        $objPurchase->sale_type = $request->sale_type;
        $objPurchase->invoice_no = $request->invoice_no;
        $objPurchase->dcn_no = $request->dcn_no;
        $objPurchase->p_order = $request->p_order;
        $objPurchase->remarks = $request->remarks;
        $objPurchase->biller = Auth::User()->id;
        $objPurchase->save();

        SaleTaxDetails::where('sale_id', '=', $id)->delete();
        GeneralVoucher::where('dc_id', '=', $id)->delete();
        // LedgerDetailWise::where('dc_id', '=', $id)->delete();
        StockRegisterSpecificItem::where('dc_id', '=', $id)->delete();

        $sum = "0";
        $count = count($request->product_id1);
        for ($i = 0; $i < $count; $i++) {
            $purchaseDetail = new SaleTaxDetails();
            $purchaseDetail->sale_id = $objPurchase->id;
            $purchaseDetail->product_id = $request->product_id1[$i];
            $purchaseDetail->party_id = $request->party_id;
            $purchaseDetail->uom_id = $request->uom_id[$i];
            if (($request->lessCommercial) == "true") {
                $purchaseDetail->status = "stockin";
            } else {
                $purchaseDetail->status = "InvoiceOnly";
            }
            $purchaseDetail->quantity = $request->quantity[$i];
            $purchaseDetail->rate = $request->rate[$i];
            $purchaseDetail->stvalue = $request->stvalue[$i];
            $purchaseDetail->taxvalue = $request->taxvalue[$i];
            if (empty($request->extratax[$i])) {
                $purchaseDetail->extratax = 0;
            } else {
                $purchaseDetail->extratax = $request->extratax[$i];
            }

            if (empty($request->extraTaxValue[$i])) {
                $purchaseDetail->extraTaxValue = 0;
            } else {
                $purchaseDetail->extraTaxValue = $request->extraTaxValue[$i];
            }


            $purchaseDetail->price = $request->excvalue[$i];
            $purchaseDetail->total = $request->incvalue[$i];
            $sum = $sum + $request->incvalue[$i];
            $purchaseDetail->save();

            if (($request->lessCommercial) == "true") {
                $vouchers = new StockRegisterSpecificItem();
                $vouchers->dc_id = $objPurchase->id;
                $vouchers->date = $objPurchase->date;
                $vouchers->party_id = $request->party_id;
                $vouchers->product_id = $request->product_id1[$i];
                $vouchers->voucher_type = $objPurchase->sale_type;
                $vouchers->uom_id = $request->uom_id[$i];
                $vouchers->sale_quantity = $request->quantity[$i];
                $vouchers->cost_rate = $request->incvalue[$i];
                $vouchers->save();
            }

            // $vouchers = new LedgerDetailWise();
            // $vouchers->dc_id = $objPurchase->id;
            // $vouchers->party_id = $request->party_id;
            // $vouchers->voucher_no = $objPurchase->invoice_no;
            // $vouchers->voucher_type = "SalesTax Invoice";
            // $vouchers->date = $objPurchase->date;
            // $vouchers->product_id = $request->product_id1[$i];
            // $vouchers->quantity = $request->quantity[$i];
            // $vouchers->rate = $request->rate[$i];
            // $vouchers->other = $request->TotalTax[$i];
            // $vouchers->debit = $request->incvalue[$i];
            // $vouchers->save();
        }

        $vouchers = new GeneralVoucher();
        $vouchers->dc_id = $objPurchase->id;
        $vouchers->account_head_id = $objPurchase->party_id;
        $vouchers->date = $objPurchase->date;
        $vouchers->voucher_no = $objPurchase->invoice_no;
        $vouchers->invoice_no = $objPurchase->invoice_no;
        $vouchers->v_type = $objPurchase->sale_type;
        $vouchers->debit = $sum;
        $vouchers->save();

        Session::flash('flash_message', 'Record Successfully Updated!');
        return redirect('credit-note');
    }

    public function destroy($id)
    {
        $delete = SaleTax::findOrFail($id);
        $delete->delete();
        SaleTaxDetails::where('sale_id', '=', $id)->delete();
        // GeneralVoucher::where('dc_id', '=', $id)->delete();
        // LedgerDetailWise::where('dc_id', '=', $id)->delete();
        // StockRegisterSpecificItem::where('dc_id', '=', $id)->delete();
        return redirect()->back();
    }
    public function MultiDelete(Request $request){
        $this->validate($request, [
            'Dltid' => 'required'
          ]);
        //   return $request;
        $count = Count($request->Dltid);
        // return $count; 
        for ($i = 0; $i < $count; $i++) {
            $delete = SaleTax::findOrFail($request->Dltid[$i]);
            $delete->delete();
            SaleTaxDetails::where('sale_id', '=', $request->Dltid[$i])->delete();
            //  RawMaterialStock::where('purchase_milk_id', '=', $request->SaleTaxID[$i])->delete(); 
            //  StockRegisterSpecificItem::where('purchase_milk_id', '=', $request->SaleTaxID[$i])->delete();
        }
        return redirect()->back();
    }
    public function PartyChange(Request $request)
    {
        $partyID = $request->get('party_ID');
        $data = Party::where('id', '=', $partyID)->get();
        return $data;
    }

    public function productChange(Request $request)
    {
        $productID = $request->get('product_ID');
        $data = Product::where('id', '=', $productID)->get(['products.*']);
        return $data;
    }

    public function print_sale($id)
    {
        $newsale_detail = SaleTax::with(['saletax_details' => function ($query) {
            $query->with('uoms');
            $query->with('products');
        }])->where('sale_taxes.id', '=', $id)
            ->get();

        // return $newsale_detail;
        $company_detail = Setting::where('id', '=', 1)->get();
        $logo = SystemLogo::where('id', '=', 1)->get();
        // return $newsale_detail;
        // return view('salestax.a4', compact('newsale_detail', 'company_detail', 'ledgers', 'logo', 'id'));
        // if(Auth::user()->bill_type ==null){
            if(session()->get('company_bill_type')=='A4'){
                // return session()->get('company_footer_show');
            return view('credit-note.a4', compact('newsale_detail', 'company_detail', 'logo', 'id'));
        }
    //     elseif( Auth::user()->bill_type =='A4' )
    //     {
    //      return view('credit-note.a4', compact('newsale_detail', 'company_detail', 'ledgers', 'logo', 'id'));
    // //    return 'elo';
    //     }
        else
        {
            return view('credit-note.thermal', compact('newsale_detail', 'company_detail', 'logo', 'id'));          
         }
    }


    public function print_pdf($id)
    {
        $newsale_detail = SaleTax::with(['saletax_details' => function ($query) {
            $query->with(['products' => function ($query) {
            }]);
            //$query->with('taxes');
            //$query->with('discount');
            //$query->with('ledger');
            //$query->with('publishers');
        }]) //->with('parties')->with('billers')
            ->where('sale_taxes.id', '=', $id)
            ->get();
 
        $company_detail = Setting::where('id', '=', 1)->get();
        $logo = SystemLogo::where('id', '=', 1)->get();

        $pdf = PDF::loadView('salestax.printpdf', ['newsale_detail' => $newsale_detail, 'company_detail' => $company_detail, 'logo' => $logo]);
        return $pdf->download('salestax_invoice.pdf');
    }


    public function print_dc($id)
    {
        $newsale_detail = SaleTax::with(['saletax_details' => function ($query) {
            $query->with(['products' => function ($query) {
            }]);
            //$query->with('taxes');
            //$query->with('discount');
            //$query->with('ledger');
            //$query->with('publishers');
        }]) //->with('parties')->with('billers')
            ->where('sale_taxes.id', '=', $id)
            ->get();
        $company_detail = Setting::where('id', '=', 1)->get();
        $logo = SystemLogo::where('id', '=', 1)->get();

        return view('salestax.dcn', compact('newsale_detail', 'company_detail', 'logo'));
    }
}
