<head>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.3/css/select2.min.css" rel="stylesheet" />
    <link rel="stylesheet" href="https://ajax.googleapis.com/ajax/libs/jqueryui/1.8.9/themes/base/jquery-ui.css"
    type="text/css" />
</head>
<?php $__env->startSection('contents'); ?>
    <h1 class="page-title">Add Product</h1>
    <div class="container-fluid">
        <?php if(Session::has('flash_message')): ?>
            <div class="alert alert-success alert-dismissible fade in">
                <a href="#" class="close" data-dismiss="alert" aria-label="close"
                    style="margin-right: 4%;">&times;</a>
                <strong>Success!</strong> <?php echo e(Session::get('flash_message')); ?>

            </div>
        <?php endif; ?>
    </div>
    <!-- Breadcrumb -->
    <ol class="breadcrumb breadcrumb-2">
        <li><a href="<?php echo e(asset('dashboard')); ?>"><i class="fa fa-home"></i>Home</a></li>
        <li><a href="<?php echo e(asset('products')); ?>">Products</a></li>
        <li class="active"><strong>Add Product</strong></li>
    </ol>
    <div class="row">
        <div class="col-lg-12">
            <div class="panel panel-default">
                <div class="panel-heading clearfix">
                    <h3 class="panel-title">Add Product</h3>
                </div>
                <div class="panel-body">
                    <?php echo $__env->make('errors.validation', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php echo Form::open(['url' => 'products', 'class' => 'form-horizontal', 'id' => 'productsForm']); ?>

                    <?php echo Form::hidden('has_recipe', 0, ['id' => 'has_recipe']); ?>

					<?php echo Form::hidden('company_id',session()->get('company_id'),['id'=>'company_id']); ?>

                    <div class="form-group">
                        <label class="col-sm-3 control-label">H.S Code <span style="color:red;">*</span></label>
                        <div class="col-sm-5">
                            
                            <?php echo Form::text('product_code', null, ['id' => 'product_code', 'class' => 'form-control', 'onkeydown' => 'focusNext(event);', 
                                'placeholder' => '____.____',
                                'data-slots' => '_',
                                'data-accept' => '\w',
                                'size' => '9',
                                'autofocus' => 'autofocus']); ?>

                            <span class="help-block text-danger" style="color: red;">
                            HS CODE Format (2711.1910)
                            </span>
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-sm-3 control-label">Product Name <span style="color:red;">*</span></label>
                        <div class="col-sm-5">
                            <?php echo Form::text('product_name', null, ['id' => 'product_name', 'class' => 'form-control']); ?>

                        </div>
                    </div>
                    <div class="form-group" style="display:none">
                        <label class="col-sm-3 control-label">Product In Urdu</label>
                        <div class="col-sm-5">
                            <?php echo Form::text('product_urdu', null, ['id' => 'product_urdu', 'class' => 'form-control', 'onkeydown' => 'focusNext(event);']); ?>


                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-sm-3 control-label">Product UOM <span style="color:red;">*</span></label>
                        <div class="col-sm-5">
                            <?php echo Form::select('uom', $uoms, null, ['id' => 'uom', 'class' => 'form-control', 'onkeydown' => 'focusNext(event);']); ?>

                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-sm-3 control-label">Select Catagory</label>
                        <div class="col-sm-5">
                            <?php echo Form::select('catagory_id', $catagories, null, ['id' => 'catagory_id', 'onkeydown' => 'focusNext(event);', 'class' => 'form-control']); ?>

                        </div>
                    </div>
                    <div class="form-group" style="display: none;">
                        <label class="col-sm-3 control-label">Pack Type</label>
                        <div class="col-sm-5">
                            <?php echo Form::select('pack_type', ['BAG' => 'BAG', 'DRUM' => 'DRUM', 'CANS' => 'CANS', 'BOTTLES' => 'BOTTLES', 'COTTON' => 'COTTON'], null, ['id' => 'pack_type', 'class' => 'form-control', 'onkeydown' => 'focusNext(event);']); ?>

                        </div>
                    </div>
                    <div class="form-group" style="display: none;">
                        <label class="col-sm-3 control-label">Pack Weight</label>
                        <div class="col-sm-5">
                            <?php echo Form::text('pack_weight', 50, ['id' => 'pack_weight', 'class' => 'form-control', 'onkeydown' => 'focusNext(event);']); ?>

                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-sm-3 control-label">Purchase Price</label>
                        <div class="col-sm-5">
                            <?php echo Form::text('product_cost', 0.0, ['id' => 'product_cost', 'class' => 'form-control', 'onkeydown' => 'focusNext(event);']); ?>

                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-sm-3 control-label">Sale Price</label>
                        <div class="col-sm-5">
                            <?php echo Form::text('product_price', 0.0, ['id' => 'product_price', 'class' => 'form-control', 'onkeydown' => 'focusNext(event);']); ?>

                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-sm-3 control-label">Tax% <span style="color:red;">*</span></label>
                        <div class="col-sm-5">
                            <?php echo Form::text('tax', 18, ['id' => 'tax', 'class' => 'form-control','onkeypress' => 'return onlyNumberKey(event)', 'onkeydown' => 'focusNext(event);']); ?>

                        </div>
                    </div>
                    <div class="form-group" style="display: none;">
                        <label class="col-sm-3 control-label">Quanity Alert</label>
                        <div class="col-sm-5">
                            <?php echo Form::text('alert', 10, ['id' => 'alert', 'class' => 'form-control', 'onkeydown' => 'focusNext(event);']); ?>

                        </div>
                    </div>

                    <div class="form-group" style="display:none;">
                        <?php echo Form::text('publisher_id', 1, ['id' => 'publisher_id', 'class' => 'form-control', 'onkeydown' => 'focusNext(event);']); ?>

                        <?php echo Form::text('type', 'type', ['id' => 'type', 'class' => 'form-control', 'onkeydown' => 'focusNext(event);']); ?>

                        <label class="col-sm-3 control-label">Year</label>
                        <div class="col-sm-5">
                            <?php echo Form::text('year', null, ['id' => 'year', 'class' => 'form-control', 'onkeydown' => 'focusNext(event);']); ?>

                        </div>
                    </div>
                    <div class="line-dashed"></div>
                    <center>
                        <div class="form-actions">
                            <button type="submit" id="saveButton" onkeydown="submitForm();" class="btn btn-primary">Save
                                Product</button>
                        </div>
                    </center>
                    <?php echo Form::close(); ?>

                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>

<script>

</script>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
    <script type="text/javascript" src="//ajax.googleapis.com/ajax/libs/jqueryui/1.10.2/jquery-ui.min.js"></script>
    <script src="/js/plugins/nouislider/nouislider.min.js"></script>
    <!-- Input Mask-->
    <script src="/js/plugins/jasny/jasny-bootstrap.min.js"></script>
    <!-- Select2-->
    <script src="/js/plugins/select2/select2.full.min.js"></script>
    <script src="/js/plugins/colorpicker/bootstrap-colorpicker.min.js"></script>
    <!--Bootstrap DatePicker-->
    <script src="/js/plugins/datepicker/bootstrap-datepicker.js"></script>
    <script type="text/javascript">
        var idArray = ["product_code", "product_name", "uom", "catagory_id", "pack_type", "pack_weight", "product_cost",
            "product_price", "tax", "alert", "saveButton"
        ];
        function focusNext(e) {
            try {
                for (var i = 0; i < idArray.length; i++) {
                    if (e.keyCode === 13 && e.target.id === idArray[i]) {
                        document.querySelector(`#${idArray[i+1]}`).focus();
                    }
                }
            } catch (error) {}
        }

        $("#account_show_id").select2();
        $("#account_show_id").next(".select2").find(".select2-selection").focus(function() {
            $("#account_show_id").select2("open");
        });

        $("#uom").select2();
        $("#uom").next(".select2").find(".select2-selection").focus(function() {
            $("#uom").select2("open");
        });
        $("#catagory_id").select2();
        $("#catagory_id").next(".select2").find(".select2-selection").focus(function() {
            $("#catagory_id").select2("open");
        });
        $("#pack_type").select2();
        $("#pack_type").next(".select2").find(".select2-selection").focus(function() {
            $("#pack_type").select2("open");
        });
        $('#party_name').on('keydown', function(e) {
            if (e.keyCode === 13) {
                $("#account_show_id").select2();
                $("#account_show_id").next(".select2").find(".select2-selection").focus(function() {
                    $("#account_show_id").select2("open");
                });
            }
        });

        function submitForm() {
            $("#productsForm").submit();
        }
    </script>


<script>
    //Paste this code to script without any change
// This code empowers all input tags having a placeholder and data-slots attribute 
document.addEventListener('DOMContentLoaded', () => {
    for (const el of document.querySelectorAll("[placeholder][data-slots]")) {
        const pattern = el.getAttribute("placeholder"),
            slots = new Set(el.dataset.slots || "_"),
            prev = (j => Array.from(pattern, (c,i) => slots.has(c)? j=i+1: j))(0),
            first = [...pattern].findIndex(c => slots.has(c)),
            accept = new RegExp(el.dataset.accept || "\\d", "g"),
            clean = input => {
                input = input.match(accept) || [];
                return Array.from(pattern, c =>
                    input[0] === c || slots.has(c) ? input.shift() || c : c
                );
            },
            format = () => {
                const [i, j] = [el.selectionStart, el.selectionEnd].map(i => {
                    i = clean(el.value.slice(0, i)).findIndex(c => slots.has(c));
                    return i<0? prev[prev.length-1]: back? prev[i-1] || first: i;
                });
                el.value = clean(el.value).join``;
                el.setSelectionRange(i, j);
                back = false;
            };
        let back = false;
        el.addEventListener("keydown", (e) => back = e.key === "Backspace");
        el.addEventListener("input", format);
        el.addEventListener("focus", format);
        el.addEventListener("blur", () => el.value === pattern && (el.value=""));
    }
});

  </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("app", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /homec/itlifeen/fbrinvoice.itlifee.net/root/resources/views/products/create.blade.php ENDPATH**/ ?>