<?php $__env->startSection('head'); ?>
    <link href="<?php echo e(Asset('/css/plugins/datatables/jquery.dataTables.css')); ?>" rel="stylesheet">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('contents'); ?>
<div class="container-fluid">
    <?php if(Session::has('flash_message')): ?>
        <div class="alert alert-success alert-dismissible fade in">
            <a href="#" class="close" data-dismiss="alert" aria-label="close"
                style="margin-right: 4%;">&times;</a>
            <strong>Success!</strong> <?php echo e(Session::get('flash_message')); ?>

        </div>
    <?php endif; ?>
</div>
    <div class="page-heading clearfix">
        <h1 class="page-title pull-left">Manage Purchases</h1><a href="<?php echo e(asset('purchases/create')); ?>"
            class="btn btn-primary btn-sm btn-add" role="button">Add Purchase Bill</a>
    </div>
    <ol class="breadcrumb breadcrumb-2">
        <li><a href="<?php echo e(asset('dashboard')); ?>"><i class="fa fa-home"></i>Home</a></li>
        <!-- <li><a href="/purchases">Manage Purchases</a></li>  -->
        <li class="active"><strong>Manage Purchases</strong></li>
    </ol>
    <div class="row">
        <div class="col-lg-12">
            <div class="panel panel-default">
                <div class="panel-heading clearfix">
                    <h3 class="panel-title">Manage Purchases</h3>
                </div>
                <div class="panel-body">
                    <div class="table-responsive">
                        <table class="table table-striped table-bordered table-hover dataTables-example">
                            <thead>
                                <tr>
                                    <th>SR#</th>
                                    <th>Date</th>
                                    <th>Bill No</th>
                                    <th>Account</th>
                                    <th>Grand Total</th>
                                    <th>Print</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $sum = 0; ?>
                                <?php $__currentLoopData = $purchases; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $purchase): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php $sum = $sum + 1; ?>
                                        <tr>
                                            <td><?php echo e($sum); ?></td>
                                            <td class="center"><?php echo e(date('d/m/Y', strtotime($purchase->date))); ?>

                                            </td>
                                            <td class="center"><?php echo e($purchase->bill_no); ?></td>
                                            <td class="center">
                                                <?php if($purchase->parties != null): ?>
                                                    <?php echo e($purchase->parties->party_name); ?>

                                                <?php endif; ?>
                                            </td>
                                            <?php $total = 0;
                                            $tax = 0;
                                            $grandtotal = 0; ?>
                                            <?php $__currentLoopData = $purchase->purchase_details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $details): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php
                                                $grandtotal = $grandtotal + $details->total_cost;
                                                ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                                            <td class="center"><?php echo e((int) $grandtotal); ?></td>
                                            <td class="size-80 text-center">
                                                <div class="row">
                                                    <a href="<?php echo e(asset('purchases/print')); ?>/<?php echo e($purchase->id); ?>"
                                                        target="_blank" style="color:white;">
                                                        <button class="btn btn-info" type="button"> <i
                                                                class="icon-print"
                                                                title="Print Invoice"></i></button></a>

                                                </div>
                                            </td>
                                            <td class="size-100 text-center">
                                                <div class="row">
                                                    <a href="<?php echo e(asset('purchases')); ?>/<?php echo e($purchase->id); ?>/edit"
                                                        style="color:white;">
                                                        <button class="btn btn-black" type="button"> <i
                                                                class="fa fa-paste"
                                                                title="Edit Invoice"></i></button></a>
                                                    <a
                                                        href="javascript:checkDelete(<?php echo e($purchase->id); ?>, '<?php echo e(asset('/purchases')); ?>/<?php echo e($purchase->id); ?>/destroy', '<?php echo e(asset('/purchases')); ?>');">
                                                        <button class="btn btn-red" type="button"> <i
                                                                class="icon-trash"
                                                                title="Delete Invoice"></i></button></a>
                                                </div>
                                            </td>

                                        </tr>
                               
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th>SR#</th>
                                    <th>Date</th>
                                    <th>Bill No</th>
                                    <th>Account</th>
                                    <th>Grand Total</th>
                                    <th>Print</th>
                                    <th>Actions</th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script src="<?php echo e(asset('/js/jquery.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/js/plugins/datatables/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/js/plugins/datatables/dataTables.bootstrap.min.js')); ?>"></script>
    <script>
        $(document).ready(function() {
            $('.dataTables-example').DataTable({
                dom: '<"html5buttons" B>lTfgitp',
                buttons: [{
                        extend: 'copyHtml5',
                        exportOptions: {
                            columns: [0, ':visible']
                        }
                    },
                    {
                        extend: 'excelHtml5',
                        exportOptions: {
                            columns: ':visible'
                        }
                    },
                    {
                        extend: 'pdfHtml5',
                        exportOptions: {
                            columns: [0, 1, 2, 3, 4]
                        }
                    },
                    'colvis'
                ]
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("app", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /homec/itlifeen/fbrinvoice.itlifee.net/root/resources/views/purchases/index.blade.php ENDPATH**/ ?>