@extends("app")
@section('contents')
<head>
<link href="{{asset('css/select2.min.css')}}" rel="stylesheet" />
    <meta name="csrf-token" content="{{ csrf_token() }}" />
</head>
    <body>
        <div class="container-fluid">
            @if (Session::has('flash_message'))
                <button type="button" class="close" data-dismiss="alert" aria-hidden="true"
                    style="margin-right: 20px;margin-top: 15px;">&times;</button>
                <div class="alert alert-success"> {{ Session::get('flash_message') }} </div>
            @endif
        </div>
        <div class="row">
            <div class="col-lg-12">
                <div class="panel panel-default">
                    <div class="panel-heading clearfix">
                        <h2 class="panel-title"><b>Edit SalesTax Invoice</b></h2>
                    </div>
                    <div class="panel-body">
                        <input id="token" type="hidden" value="{{ $encrypted_token }}">
                        @include('errors.validation')
                        {!! Form::open(['url' => 'sales', 'class' => 'form-horizontal']) !!}
                        {!! Form::hidden('company_id', session()->get('company_id'), ['id' => 'company_id']) !!}
                        {!! Form::hidden('warehouse_id', $edit->warehouse_id, ['id' => 'warehouse_id']) !!}

                        {!! Form::hidden('biller', Auth::User()->id, ['id' => 'biller']) !!}

                        {!! Form::hidden('sale_type', 'SalesTax Invoice', ['id' => 'sale_type']) !!}
                        <div class="row">
                            <div class="form-group" style="margin-left: 1%; margin-right: 1%;">
                                <label class="col-sm-1 control-label">Date</label>
                                <div class="col-sm-2">
                                    <div id="year-view" class="input-group date">
                                        <input id="date" type="date" name="date" value="{{ date('Y-m-d',strtotime($edit->date))}}"
                                            class="form-control" autofocus>
                                        <!-- <span class="input-group-addon"><i class="fa fa-calendar"></i></span> -->
                                    </div>
                                </div>
                                <label class="col-sm-1 control-label">Remarks</label>
                                <div class="col-sm-2">
                                {!! Form::text('remarks', $edit->remarks, ['id' => 'remarks', 'class' => 'form-control']) !!}
                                {!! Form::hidden('purchase_type', "PurchaseTax Invoice", ['id' => 'purchase_type', 'class' => 'form-control']) !!}
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="form-group" style="margin-left: 1%; margin-right: 1%;">
                                <label class="col-sm-1 control-label">Voucher&nbsp;No#</label>
                                <div class="col-sm-2">
                                    
                                        {!! Form::text('invoice_no', $edit->invoice_no, ['id' => 'invoice_no', 'class' => 'form-control', 'required' => 'required', 'disabled' => 'disabled']) !!}
                                    
                                </div>
                                <!-- <label class="col-sm-1 control-label">Invoice&nbsp;No#</label>
                                <div class="col-sm-2">
                                    {!! Form::text('invoice_no', $edit->voucher_no, ['id' => 'invoice_no', 'class' => 'form-control', 'required' => 'required']) !!}
                                </div> -->
                                <label class="col-sm-1 control-label">DC&nbsp;NO</label>
                                <div class="col-sm-2">
                                    <div id="year-view" class="input-group date">
                                        {!! Form::text('dcn_no', $edit->dcn_no, ['id' => 'dcn_no', 'class' => 'form-control', 'required' => 'required']) !!}
                                    </div>
                                </div>
                                <label class="col-sm-1 control-label">P&nbsp;Order</label>
                                <div class="col-sm-2">
                                    <div id="year-view" class="input-group date">
                                        {!! Form::text('p_order', $edit->p_order, ['id' => 'p_order', 'class' => 'form-control', 'required' => 'required']) !!}
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group" style="margin-left: 1%; margin-right: 1%;">
                                <label class="col-sm-1 control-label">Select&nbsp;Party</label>
                                {!! Form::hidden('party_id', $edit->party_id, ['id' => 'party_id', 'class' => 'form-control']) !!}
                                <div class="col-sm-2">
                                    
                                        {!! Form::select('party_name', $customers, $edit->party_id, ['id' => 'party_name', 'onchange' => 'javascript:PartyKeyUp($(this).val());', 'class' => 'form-control']) !!}

                                    
                                </div>
                                <div class="col-sm-4">
                                    {!! Form::text('address', null, ['id' => 'address', 'class' => 'form-control', 'placeholder' => 'Address', 'disabled' => 'disabled']) !!}
                                </div>
                                <div class="col-sm-2">
                                    {!! Form::text('ntn', null, ['id' => 'ntn', 'class' => 'form-control', 'placeholder' => 'NTN', 'disabled' => 'disabled']) !!}
                                </div>
                            </div>
                        </div>
                        <div class="panel panel-default">
                            <div class="panel-body">
                                <div class="form-group">
                                    <table id="myTable">
                                        <div class="container-fluid">
                                            <div class="row">
                                                <tr>
                                                    {!! Form::hidden('product_id', null, ['id' => 'product_id', 'class' => 'form-control']) !!}
                                                    <div class="col-md-1">
                                                        <div class="form-group"
                                                            style="margin-left: 1%; margin-right: 1%;">
                                                            <label for="H.S" class="control-label">H.S Code</label>
                                                            {!! Form::text('product_code', null, ['id' => 'product_code', 'class' => 'form-control']) !!}
                                                        </div>
                                                    </div>
                                                    <div class="col-md-2">
                                                        <div class="form-group"
                                                            style="margin-left: 1%; margin-right: 1%;">
                                                            <label for="Name" class="control-label">Product Name</label>
                                                            {!! Form::select('product_name', $products, null, ['id' => 'product_name', 'onchange' => 'ProductKeyUp($(this).val().split("_").pop(), $(this).val().split("_")[0]);', 'class' => 'form-control']) !!}
                                                        </div>
                                                    </div>
                                                    <!-- <div class="col-sm-1" style="display:none;">
                 <div class="form-group" style="margin-right: 1%;">
                  <label for="password" class="control-label">P.T</label>
                  {!! Form::text('packing_type', null, ['id' => 'packing_type', 'class' => 'form-control', 'disabled' => 'disabled']) !!}
                 </div>
                </div> -->
                                                    <!-- <div class="col-md-2">
                 <div class="form-group">
                  <label for="password" class="control-label">U.O.M</label>
                  {!! Form::text('uom', null, ['id' => 'uom', 'class' => 'form-control', 'disabled' => 'disabled']) !!}
                 </div>
                </div>  -->
                                                    <div class="col-md-1" style="display:none;">
                                                        <div class="form-group"
                                                            style="margin-left: 1%; margin-right: 1%;">
                                                            <label for="Name" class="control-label">Unit</label>
                                                            {!! Form::select('uom_id', $uoms, null, ['id' => 'uom_id', 'class' => 'form-control']) !!}
                                                        </div>
                                                    </div>
                                                    <div class="col-md-1">
                                                        <div class="form-group"
                                                            style="margin-left: 1%; margin-right: 1%;">
                                                            <label for="Name" class="control-label">Unit</label>
                                                            {!! Form::text('uom', null, ['id' => 'uom', 'class' => 'form-control', 'disabled' => 'disabled']) !!}
                                                        </div>
                                                    </div>
                                                    <div class="col-md-1">
                                                        <div class="form-group"
                                                            style="margin-right: 1%;margin-left: 1%;">
                                                            <label for="password" class="control-label">Quantity</label>
                                                            {!! Form::text('quantity', null, ['id' => 'quantity', 'onkeyup' => 'QuantityKeyUp($(this).val())', 'onkeypress' => 'return onlyNumberKey(event)', 'class' => 'form-control', 'onfocus'=>'this.value=""']) !!}
                                                        </div>
                                                    </div>

                                                    <div class="col-md-1">
                                                        <div class="form-group"
                                                            style="margin-right: 1%;width: 100%;margin-left: 1%;">
                                                            <label for="password" class="control-label">Price</label>
                                                            {!! Form::text('price_per_unit', null, ['id' => 'price_per_unit', 'onkeyup' => 'SaleRateKeyUpForm($(this).val())', 'onkeypress' => 'return onlyNumberKey(event)', 'onfocus'=>'this.value=""', 'onpaste' => 'return false;', 'ondrop' => 'return false;', 'autocomplete' => 'off', 'class' => 'form-control']) !!}
                                                        </div>
                                                    </div>
                                                    <div class="col-md-1">
                                                        <div class="form-group"
                                                            style="margin-right: 1%;width: 100%;margin-left: 1%;">
                                                            <label for="password" class="control-label">S.T%</label>
                                                            {!! Form::text('stvalue', null, ['id' => 'stvalue', 'class' => 'form-control', 'disabled' => 'disabled']) !!}
                                                        </div>
                                                    </div>
                                                    <div class="col-md-1">
                                                        <div class="form-group"
                                                            style="margin-right: 1%;width: 100%;margin-left: 1%;">
                                                            <label for="password" class="control-label">Tax Value</label>
                                                            {!! Form::text('taxvalue', null, ['id' => 'taxvalue', 'class' => 'form-control', 'disabled' => 'disabled']) !!}
                                                        </div>
                                                    </div>
                                                    <div class="col-md-1">
                                                        <div class="form-group"
                                                            style="margin-right: 1px; margin-left: 1px;">
                                                            <label for="password" class="control-label">Extra%</label>
                                                            {!! Form::text('extratax', null, ['id' => 'extratax', 'onkeyup' => 'ExtraTaxkeyup($(this).val());', 'onfocus'=>'this.value=""', 'onkeypress' => 'return onlyNumberKey(event)', 'class' => 'form-control']) !!}
                                                        </div>
                                                    </div>
                                                    <div class="col-md-1" style="display:none;">
                                                        <div class="form-group"
                                                            style="margin-right: 1px; margin-left: 1px;">
                                                            <label for="password" class="control-label">ExtraVal</label>
                                                            {!! Form::text('extraTaxValue', null, ['id' => 'extraTaxValue', 'onkeypress' => 'return onlyNumberKey(event)', 'onkeyup' => 'AddGridData()', 'class' => 'form-control']) !!}
                                                        </div>
                                                    </div>
                                                    <div class="col-md-1">
                                                        <div class="form-group"
                                                            style="margin-right: 1px; margin-left: 1px;">
                                                            <label for="password" class="control-label">Val ExTax</label>
                                                            {!! Form::text('ValueExTax', null, ['id' => 'ValueExTax', 'class' => 'form-control', 'disabled' => 'disabled']) !!}
                                                        </div>
                                                    </div>
                                                    <div class="col-md-1">
                                                        <div class="form-group"
                                                            style="margin-right: 1px; margin-left: 1px;">
                                                            <label for="password" class="control-label">IncTax</label>
                                                            {!! Form::text('amount', null, ['id' => 'amount', 'class' => 'form-control', 'disabled' => 'disabled']) !!}
                                                        </div>
                                                    </div>
                                                    <div class="col-md-1" style="">
                                                        <div class="form-group" style="margin-right: 1px; margin-left: 1px;">
                                                            <label for="Add" class="control-label">Add</label><br/>
                                                            <button type="button" onkeyup ="AddGridData()" onclick ="AddGridData()" class="btn btn-success">Add</button>
                                                        </div>
                                                    </div>
                                                    <!-- <div class="col-md-1">
                 <div class="form-group" style="margin-right: 1px; margin-left: 1px;">
                  <label for="password" class="control-label">Balance</label>
                  {!! Form::text('balance', null, ['id' => 'balance', 'class' => 'form-control', 'disabled' => 'disabled']) !!}
                 </div>
                </div> -->
                                                </tr>
                                                <table id="myData">
                                                    <?php $totalPrice = 0;
                                                    $totalTax = 0;
                                                    $totalExTax = 0;
                                                    $totalIncTax = 0; ?>
                                                    @foreach ($edit->saletax_details as $PurchaseDetail)
                                                        <tr>
                                                            <td style="display:none;">
                                                                <input id="test" value="{{ $PurchaseDetail->product_id }}"
                                                                    type="text" class="form-control" disabled>
                                                            </td>
                                                            <td style="padding-top:20px;">
                                                                <input id="test"
                                                                    value="{{ $PurchaseDetail->products->product_code }}"
                                                                    type="text" class="form-control"
                                                                    style="margin-left: 14%; width: 60%;" disabled>
                                                            </td>
                                                            <td style="padding-top:20px;">
                                                                <input id="test"
                                                                    value="{{ $PurchaseDetail->products->product_name }}"
                                                                    type="text" class="form-control"
                                                                    style="width: 147%;" disabled>
                                                            </td>
                                                            <td style="display:none;">
                                                                <input id="test" value="{{ $PurchaseDetail->unit->id }}"
                                                                    type="text" class="form-control" style="margin-left: -25%; width: 120%;" disabled>
                                                            </td>
                                                            <td style="padding-top:20px;">
                                                                <input id="test" value="{{ $PurchaseDetail->products->uom }}"
                                                                    type="text" class="form-control"
                                                                    style="margin-left: 74%; width: 60%;" disabled>
                                                            </td>
                                                            <td style="padding-top:20px;">
                                                                <input id="test" value="{{ $PurchaseDetail->quantity }}"
                                                                    type="text" class="form-control"
                                                                    style="margin-left: 60%;width: 62%;" disabled>
                                                            </td>
                                                            <td style="padding-top:20px;">
                                                                <input id="test" value="{{ $PurchaseDetail->rate }}"
                                                                    type="text" class="form-control"
                                                                    style="margin-left:48%; width: 60%;" disabled>
                                                            </td>
                                                            <td style="padding-top:20px;">
                                                                <input id="test" value="{{ $PurchaseDetail->stvalue }}"
                                                                    type="text" class="form-control"
                                                                    style="margin-left:34%; width: 63%;" disabled>
                                                            </td>
                                                            <td style="padding-top:20px;">
                                                                <input id="test" value="{{ $PurchaseDetail->taxvalue }}"
                                                                    type="text" class="form-control"
                                                                    style="margin-left:22%; width: 60%;" disabled>
                                                            </td>
                                                            <td style="padding-top:20px;">
                                                                <input id="test" value="{{ $PurchaseDetail->extratax }}"
                                                                    type="text" class="form-control"
                                                                    style="margin-left:9%; width: 60%;" disabled>
                                                            </td>
                                                            <td style="padding-top:20px; display:none;">
                                                                <input id="test"
                                                                    value="{{ $PurchaseDetail->extraTaxValue }}"
                                                                    type="text" class="form-control"
                                                                    style="margin-left:39%; width: 65%;" disabled>
                                                            </td>
                                                            <td style="padding-top:20px;">
                                                                <input id="test" value="{{ $PurchaseDetail->price }}"
                                                                    type="text" class="form-control"
                                                                    style="margin-left:-4%; width: 60%;" disabled>
                                                            </td>
                                                            <td style="padding-top:20px;">
                                                                <input id="test" value="{{ $PurchaseDetail->total }}"
                                                                    type="text" class="form-control"
                                                                    style="margin-left:-20%; width: 85%;" disabled>
                                                            </td>
                                                            <td style="display: none;">
                                                                <input id="test" value="{{ $PurchaseDetail->other }}"
                                                                    type="text" class="form-control"
                                                                    style="margin-left:21%; width: 65%;" disabled>
                                                            </td>

                                                            <td style="padding-top:20px;">
                                                                <button type="button" onclick="javascript:myDeleteFunction($(this).closest('tr'));" style="margin-left:-65%;" class="btn btn-danger">Dlt</button>
                                                             </td>
                                                            <!-- <td style="padding-top:20px;"><button class="btn btn-red" type="button"> <i onclick="javascript:myDeleteFunction($(this).closest(\'tr\'));" class="icon-trash" title="Delete Row"></i></button></td> -->
                                                            <?php $totalPrice = $totalPrice + $PurchaseDetail->quantity; ?>
                                                            <?php $totalTax = $totalTax + $PurchaseDetail->taxvalue; ?>
                                                            <?php $totalExTax = $totalExTax + $PurchaseDetail->price; ?>
                                                            <?php $totalIncTax = $totalIncTax + $PurchaseDetail->total; ?>
                                                        </tr>
                                                    @endforeach
                                                </table>
                                            </div>
                                            <div class="row">
                                                <tr>
                                                    <div class="col-md-3">
                                                        <div class="form-group">

                                                        </div>
                                                    </div>
                                                </tr>
                                            </div>
                                        </div>
                                    </table><br><br>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="panel panel-default">
                                    <div class="panel-heading clearfix">
                                        <div class="container">
                                            <div class="col-xs-2"><label class="radio-inline">
                                                <!-- <input type="checkbox" name="autocash" id="autocash"
                                                        value="yes">Auto&nbsp;Cash</label> -->
                                                     </div>
                                            <div class="col-xs-2" style=""><b>Total Qty</b> <input type="text"
                                                    id="TotalRate" name="TotalRate" value="{{ $totalPrice }}" disabled>
                                            </div>
                                            <div class="col-xs-2" style=""><b>Total Tax</b> <input type="text"
                                                    id="TotalTax" name="TotalTax" value="{{ $totalTax }}" disabled>
                                            </div>
                                            <div class="col-xs-2" style=""> <b>Value Ex.Tax</b> <input type="text"
                                                    id="TotalExTax" name="TotalExTax" value="{{ $totalExTax }}" disabled>
                                            </div>
                                            <div class="col-xs-2" style="background-color:lavenderblush;"> <b>Value
                                                    Inc.Tax</b> <input type="text" id="TotalAmount" name="TotalAmount"
                                                    value="{{ $totalIncTax }}" disabled> </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <center>
                            <div class="form-actions">
                                <button type="button" class="btn btn-primary" id="btnSave" name="btnSave">Save</button>
                            </div>
                        </center>
                        {!! Form::close() !!}
                    </div>
                </div>
            </div>
        </div>
    </body>
@stop
@section('scripts')
<script src="{{ asset('js/plugins/select2/select2.full.min.js') }}"></script>
<script>
        $("#party_name").select2();
        $("#party_name").next(".select2").find(".select2-selection").focus(function() {
            $("#party_name").select2("open");
        });

        $("#product_name").select2();
        $("#product_name").next(".select2").find(".select2-selection").focus(function() {
            $("#product_name").select2("open");
        });

    
    </script>

    <script type="text/javascript">
         $('#party_name').change(function() {
            $('#party_name').select2().trigger('select2:close');
            $("#product_code").focus();
        });

        //  $('#product_name').change(function() {
        //      $('#product_name').select2().trigger('select2:close');
        //     //  $('#product_name').select2('open');
        //     $("#quantity").focus();
        // });

        function AddGridData() {
            var date = document.getElementById('date').value;
            // var InvoiceNo = document.getElementById('invoice_no').value;
            var ProductId = document.getElementById('product_id').value;
            var ProductCode = document.getElementById('product_code').value;
            var ProductID = document.getElementById('product_name').value.split("_")[0];
            var ProductName = document.getElementById('product_name').value.split("_").pop();
            var UOM = document.getElementById('uom_id').value.split("_").pop();
            var UOMID = document.getElementById('uom_id').value.split("_")[0];
            var Quantity = document.getElementById('quantity').value;
            var Price = document.getElementById('price_per_unit').value;
            var STValue = document.getElementById('stvalue').value;
            var TaxValue = document.getElementById('taxvalue').value;
            var ExtraTax = document.getElementById('extratax').value;
            var ExtraTaxValue = document.getElementById('extraTaxValue').value;
            var ValueExTax = document.getElementById('ValueExTax').value;
            var Amount = document.getElementById('amount').value;
            var TotalTax = parseInt(TaxValue) + parseInt(ExtraTaxValue);

            var TotalRate = document.getElementById('TotalRate').value;
            var TotalTax = document.getElementById('TotalTax').value;
            var TotalExTax = document.getElementById('TotalExTax').value;
            var TotalAmount = document.getElementById('TotalAmount').value;

            var totalPrice = parseInt(TotalRate) + parseInt(Quantity);
            var TotalTaxAmount = parseInt(TotalTax) + parseInt(TaxValue);
            var TotalExTaxAmount = parseInt(TotalExTax) + parseInt(ValueExTax);
            var TotalincTaxAmount = parseInt(TotalAmount) + parseInt(Amount);

            document.getElementById('TotalRate').value = totalPrice;
            document.getElementById('TotalTax').value = TotalTaxAmount;
            document.getElementById('TotalExTax').value = TotalExTaxAmount;
            document.getElementById('TotalAmount').value = TotalincTaxAmount;

            if((ProductId) == "" || (ProductId) == 0){
                document.getElementById("product_code").focus();
                Swal.fire('Select Product First!');
                    e.preventdefault();
            }

            if((Quantity) == "" || (Quantity) == 0 || (Quantity) == 'NaN' ){
                // alert('Quantity Cant be Empty or 0!');
                document.getElementById("quantity").focus();
                Swal.fire('Quantity Cant be Empty or 0!');
                    e.preventdefault();
            }

            if((Price) == "" || (Price) == 0 || (Price) == 'NaN' ){
                document.getElementById("price_per_unit").focus();
                // alert('Price Cant be Empty or 0!');
                Swal.fire('Price Cant be Empty or 0!');
                
                    e.preventdefault();
            }
            var tableHtml = '<tr onclick="javascript:myDeleteFunction($(this).closest(\'tr\'));">';
            // tableHtml += '<td class="text-center"><i onclick="javascript:myDeleteFunction($(this).closest(\'tr\'));" class="icon-cancel icon-larger red-color" title="Delete Row"></i> </td>';
            //tableHtml += '<td>'+ ProductId +'</td>';
            //0
            tableHtml +=
                `<td style="display:none;"><input id="test" value="${ProductId}" type="text" class="form-control" disabled></td>`;
            //tableHtml += '<td>'+ ProductCode +'</td>';
            //1
            tableHtml +=
                `<td style="padding-top:20px;"><input id="test" value="${ProductCode}" type="text" class="form-control" style="margin-left: 14%; width: 60%;" disabled></td>`;
            //tableHtml += '<td>'+ ProductName +'</td>';
            //2
            // tableHtml += `<td style="display:none;"><input id="test" value="${ProductID}" type="text" class="form-control" disabled></td>`;
            //3
            tableHtml +=
                `<td style="padding-top:20px;"><input id="test" value="${ProductName}" type="text" class="form-control" style="width: 147%;" disabled></td>`;
            //tableHtml += '<td>'+ PackingType +'</td>';
            //tableHtml += '<td>'+ UOM +'</td>';
            //4
            tableHtml +=
                `<td style="display:none;"><input id="test" value="${UOMID}" type="text" class="form-control" disabled></td>`;
            //5
            tableHtml +=
                `<td style="padding-top:20px;"><input id="test" value="${UOM}" type="text" class="form-control"style="margin-left: 74%; width: 60%;" disabled></td>`;
            //tableHtml += '<td>'+ Quantity +'</td>';
            //6
            tableHtml +=
                `<td style="padding-top:20px;"><input id="test" value="${Quantity}" type="text" class="form-control" style="margin-left: 60%;width: 62%;" disabled></td>`;
            //tableHtml += '<td>'+ Price +'</td>';
            //7
            tableHtml +=
                `<td style="padding-top:20px;"><input id="test" value="${Price}" type="text" class="form-control" style="margin-left:48%; width: 60%;" disabled></td>`;
            //tableHtml += '<td>'+ STValue +'</td>';
            //8
            tableHtml +=
                `<td style="padding-top:20px;"><input id="test" value="${STValue}" type="text" class="form-control" style="margin-left:34%; width: 63%;" disabled></td>`;
            //tableHtml += '<td>'+ TaxValue +'</td>';
            //9
            tableHtml +=
                `<td style="padding-top:20px;"><input id="test" value="${TaxValue}" type="text" class="form-control" style="margin-left:22%; width: 60%;" disabled></td>`;
            //tableHtml += '<td>'+ ExtraTax +'</td>';
            //10
            tableHtml +=
                `<td style="padding-top:20px;"><input id="test" value="${ExtraTax}" type="text" class="form-control" style="margin-left:9%; width: 60%;" disabled></td>`;
            //tableHtml += '<td>'+ ExtraTaxValue +'</td>';
            //11
            tableHtml +=
                `<td style="padding-top:20px; display:none;"><input id="test" value="${ExtraTaxValue}" type="text" class="form-control" style="margin-left:39%; width: 65%;" disabled></td>`;
            //12
            tableHtml +=
                `<td style="padding-top:20px;"><input id="test" value="${ValueExTax}" type="text" class="form-control" style="margin-left:-4%; width: 60%;" disabled></td>`;
            //tableHtml += '<td>'+ Amount +'</td>';
            //13
            tableHtml +=
                `<td style="padding-top:20px;"><input id="test" value="${Amount}" type="text" class="form-control" style="margin-left:-20%; width: 85%;" disabled></td>`;
            //14
            tableHtml +=
                `<td style="display:none;"><input id="test" value="${TotalTax}" type="text" class="form-control" style="margin-left:21%; width: 65%;" disabled></td>`;
                tableHtml +=
                `<td style="padding-top:20px;"><button type="button"  onclick="javascript:myDeleteFunction($(this).closest(\'tr\'));" style="margin-left:-65%;" class="btn btn-danger">Dlt</button></td>`;
            
                tableHtml += '</tr>';
            $('#myData').append(tableHtml);
            // document.getElementById("product_code").focus();
            $('#product_name').select2('open');
        }


        function QuantityKeyUp(quantity) {
            var tax = document.getElementById('stvalue').value;
            var extratax = document.getElementById('extratax').value;
            var price = document.getElementById('price_per_unit').value;
            var totaltax = (price / 100 * tax) * quantity;
            var extratax = (price / 100 * extratax) * quantity;
            document.getElementById('taxvalue').value = totaltax;
            document.getElementById('extraTaxValue').value = extratax;
            var valueWithoutTax = quantity * price;
            document.getElementById('ValueExTax').value = valueWithoutTax;
            total = (quantity * price) + totaltax + extratax;
            document.getElementById('amount').value = total;
        }

        function SaleRateKeyUpForm(price) {
            var quantity = document.getElementById('quantity').value;
            var stvalue = document.getElementById('stvalue').value;
            //tax value
            var tax = (stvalue / 100 * price) * quantity;
            document.getElementById('taxvalue').value = tax;

            //extra tax value
            var extrataxvalue = document.getElementById('extratax').value;
            var extratax = (extrataxvalue / 100 * price) * quantity;
            document.getElementById('extraTaxValue').value = extratax;

            var total = quantity * price;
            var totalValue = total + tax + extratax;
            document.getElementById('ValueExTax').value = total;
            document.getElementById('amount').value = totalValue;
        }

        function ExtraTaxkeyup(taxvalue) {
            var quantity = document.getElementById('quantity').value;
            var price = document.getElementById('price_per_unit').value;
            var stvalue = document.getElementById('stvalue').value;
            var tax = (stvalue / 100 * price) * quantity;
            var extratax = (taxvalue / 100 * price) * quantity;

            document.getElementById('extraTaxValue').value = extratax;
            var total = quantity * price;
            var totalValue = total + tax + extratax;
            document.getElementById('ValueExTax').value = total;
            document.getElementById('amount').value = totalValue;
        }

        // on javascript onclick on product dropdown 
        function ProductKeyUp(ProductName, ProductID) {
            // alert(ProductID)
            // $("#quantity").focus();
            $.ajax({
                type: "GET",
                url: "{{ asset('taxproductkeyup-ajax') }}?product_ID=" + ProductID,
                success: function(result) {
                    if (result.length > 0) {
                        $('#product_code').val(result[0].product_code);
                        $('#product_id').val(result[0].id);
                        $("#packing_type").val(result[0].catagory_name);
                        $("#price_per_unit").val(result[0].price_per_unit);
                        $("#uom").val(result[0].uom);
                        $("#stvalue").val(result[0].tax);

                        var price = $("#price_per_unit").val();
                        var quantity = $("#quantity").val();
                        var stvalue = $("#stvalue").val();
                        var extratax = $("#extratax").val();
                        var tax = parseInt((stvalue / 100 * price) * quantity);
                        var extratax = parseInt((extratax / 100 * price) * quantity);
                        document.getElementById('taxvalue').value = tax;
                        document.getElementById('extraTaxValue').value = extratax;
                        var total = price * quantity;
                        var grand = tax + extratax + total;
                        // document.getElementById('value').value = total;
                        document.getElementById('amount').value = grand;
                      
                         $("#quantity").focus();
                    }
                },
                error: function(xhr, ajaxOptions, thrownError) {
                    alert(xhr.status);
                    alert(thrownError);
                }
            });
        }

        function PartyKeyUp(partyID) {
            $.ajax({
                type: "GET",
                url: "{{ asset('taxpartyonchange-ajax') }}?party_ID=" + partyID,
                success: function(result) {
                    if (result.length > 0) {
                        $('#party_id').val(result[0].id);
                        $('#address').val(result[0].address);
                        $('#strn').val(result[0].strn);
                        $('#ntn').val(result[0].ntn);
                    }
                }
            });
        }

        // function myDeleteFunction(row) {
        //     alertify.confirm("Are you sure you want to delete this row?", function(e) {
        //         if (e) {
        //             var TotalRate = document.getElementById('TotalRate').value;
        //             var rate = $(row).find("td:eq('6')").find("input").val();
        //             var grandRate = parseInt(TotalRate) - parseInt(rate);
        //             document.getElementById('TotalRate').value = grandRate;

        //             var TotalTax = document.getElementById('TotalTax').value;
        //             var tax = $(row).find("td:eq('8')").find("input").val();
        //             var grandTax = parseInt(TotalTax) - parseInt(tax);
        //             document.getElementById('TotalTax').value = grandTax;

        //             var TotalExTax = document.getElementById('TotalExTax').value;
        //             var Extax = $(row).find("td:eq('11')").find("input").val();
        //             var grandExTax = parseInt(TotalExTax) - parseInt(Extax);
        //             document.getElementById('TotalExTax').value = grandExTax;

        //             var TotalAmount = document.getElementById('TotalAmount').value;
        //             var Inctax = $(row).find("td:eq('12')").find("input").val();

        //             var grandIncTax = parseInt(TotalAmount) - parseInt(Inctax);
        //             document.getElementById('TotalAmount').value = grandIncTax;

        //             $(row).remove();
        //         } else {
        //             alertify.alert("Row Deleting Cancelled!");
        //         }
        //     });
        // }

        function myDeleteFunction(row) {
            Swal.fire({
                    title: "Are You Sure?",
                    text: "Confirm Transaction?",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonText: 'Yes, Create it!',
                    confirmButtonColor: '#28A745',
                    cancelButtonText: 'No, cancel!',
                    cancelButtonColor: '#DC3545',
                }).then((result) => {
                    if (result.isConfirmed) {
                    var TotalRate = document.getElementById('TotalRate').value;
                    var rate = $(row).find("td:eq('5')").find("input").val(); //qty, not rate
                    var grandRate = parseInt(TotalRate) - parseInt(rate);
                    document.getElementById('TotalRate').value = grandRate;

                    var TotalTax = document.getElementById('TotalTax').value;
                    var tax = $(row).find("td:eq('8')").find("input").val();
                    var grandTax = parseInt(TotalTax) - parseInt(tax);
                    document.getElementById('TotalTax').value = grandTax;

                    var TotalExTax = document.getElementById('TotalExTax').value;
                    var Extax = $(row).find("td:eq('11')").find("input").val();
                    var grandExTax = parseInt(TotalExTax) - parseInt(Extax);
                    document.getElementById('TotalExTax').value = grandExTax;

                    var TotalAmount = document.getElementById('TotalAmount').value;
                    var Inctax = $(row).find("td:eq('12')").find("input").val();
                    // alert(TotalAmount)
                    // alert(Inctax)
                    var grandIncTax = parseInt(TotalAmount) - parseInt(Inctax);
                    document.getElementById('TotalAmount').value = grandIncTax;



                    $(row).remove();
                    //alertify.alert("File is Removed!");
                }
                    
            });
        }

        $("#btnSave").click(function() {
            // var test =  $("#invoice_no").val();
            // alert(test)
            Swal.fire({
                    title: "Are You Sure?",
                    text: "Confirm Transaction?",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonText: 'Yes, Create it!',
                    confirmButtonColor: '#28A745',
                    cancelButtonText: 'No, cancel!',
                    cancelButtonColor: '#DC3545',
                }).then((result) => {
                    if (result.isConfirmed) {
                    var purchase = new Object();
                    purchase.party_id = $("#party_id").val();
                    purchase.warehouse_id = $("#warehouse_id").val();
                    purchase.invoice_no = $("#invoice_no").val();
                    purchase.p_order = $("#p_order").val();
                    purchase.dcn_no = $("#dcn_no").val();
                    purchase.sale_type = $("#sale_type").val();
                    purchase.date = $("#date").val();
                    purchase.purchase_type = $("#purchase_type").val();
                    purchase.remarks = $("#remarks").val();
                    purchase.lessCommercial = $("#lessCommercial").is(":checked");
                    purchase.autocash = $("#autocash").is(":checked");
                    purchase.biller = $("#biller").val();
                    purchase.company_id = $('#company_id').val();

                    var products = [];
                    $.each($("#myData tr"), function(index, row) {
                        var columns = $(row).find("td");
                        var product = new Object();
                        product.party_id = $("#party_id").val();
                        product.product_id = $(columns[0]).find("input").val();
                        product.uom_id = $(columns[3]).find("input").val().split("_")[0];
                        product.quantity = $(columns[5]).find("input").val();
                        product.rate = $(columns[6]).find("input").val();
                        product.stvalue = $(columns[7]).find("input").val();
                        product.taxvalue = $(columns[8]).find("input").val();
                        product.extratax = $(columns[9]).find("input").val();
                        product.extraTaxValue = $(columns[10]).find("input").val();
                        product.excvalue = $(columns[11]).find("input").val();
                        product.incvalue = $(columns[12]).find("input").val();
                        product.TotalTax = $(columns[13]).find("input").val();
                        product.company_id = $('#company_id').val();
                        products.push(product);
                    });

                    var $_token = jQuery('#token').val();
                    if(products != ""){
                    jQuery.ajax({
                        method: "PATCH",
                        cache: false,
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        data: {
                            purchase: JSON.stringify(purchase),
                            product_data: products
                        },
                        url: "{{ asset('salestax') }}/<?php echo $edit->id; ?>",
                        success: function(result) {
                            //if(result == "inserted")
                            if (parseInt(result) > 0) {
                                // window.open("/salestax/print/"+result);
                                window.location.href = "{{ asset('salestax') }}";
                                //window.open("/sales/print/"+result);
                                //alert("Sale successfully saved.");
                                //Session::flash('flash_message', 'Sale Added Successfully!');
                                //window.location.href = "/sales";	
                            }
                        },
                        error: function(xhr, ajaxOptions, thrownError) {
                            $("#spanWait").hide();
                            alert(xhr.status);
                            alert(thrownError);
                        }
                    });
                }else{
                    // alert("Add your product in Grid");
                    Swal.fire('Add your products in Grid');
                    //  $('#product_name').select2('open');
                    // e.preventdefault();
                }
                    }
                });
        });
    </script>
@stop
