@extends("app")
@section('contents')
<head>
<link href="{{asset('css/select2.min.css')}}" rel="stylesheet" />
    <meta name="csrf-token" content="{{ csrf_token() }}" />
</head>
    <body>
        <div class="container-fluid">
            @if (Session::has('flash_message'))
                <button type="button" class="close" data-dismiss="alert" aria-hidden="true"
                    style="margin-right: 20px;margin-top: 15px;">&times;</button>
                <div class="alert alert-success"> {{ Session::get('flash_message') }} </div>
            @endif
        </div>
        <div class="row">
            <div class="col-lg-12">
                <div class="panel panel-default">
                    <div class="panel-heading clearfix" id="panelbg">
                        <h2 class="panel-title"><b>Bank Receipt Voucher</b></h2>
                    </div>
                    <div class="panel-body">
                        <input id="token" type="hidden" value="{{ $encrypted_token }}">
                        @include('errors.validation')
                        {!! Form::open(['url' => 'cheque-payments', 'class' => 'form-horizontal']) !!}
                        {!! Form::hidden('company_id', session()->get('company_id'), ['id' => 'company_id']) !!}
                        <div class="row">
                            <div class="form-group" style="margin-left: 1%; margin-right: 1%;">
                                <label class="col-sm-1 control-label">Vr. No</label>
                                <div class="col-sm-2">
                                    <div id="year-view" class="input-group date">
                                        {!! Form::text('voucher_no', $codes, ['id' => 'voucher_no', 'class' => 'form-control', 'disabled' => 'disabled']) !!}
                                    </div>
                                </div>
                                <label class="col-sm-1 control-label">Vr. Date</label>
                                <div class="col-sm-2">
                                    <div id="year-view" class="input-group date">
                                        <input id="voucher_date" type="date" name="voucher_date" value="<?php echo date('Y-m-d'); ?>"
                                            class="form-control" autofocus>
                                        <!-- <span class="input-group-addon"><i class="fa fa-calendar"></i></span>  -->
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row" style="display: none;">
                            <div class="form-group" style="margin-left: 1%; margin-right: 1%;">
                                <label class="col-sm-1 control-label">Voucher Type</label>
                                <div class="col-sm-5" style="height: 40px;">
                                    {!! Form::text('v_type', 'Bank Receipt', ['id' => 'v_type', 'class' => 'form-control']) !!}
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group" style="margin-left: 1%; margin-right: 1%;">
                                <label class="col-sm-1 control-label">Bank&nbsp;Or&nbsp;Cheque</label>
                                <div class="col-sm-3" style="height: 40px;">
                                    {!! Form::select('account_id', $debitAccount, null, ['id' => 'account_id', 'class' => 'form-control']) !!}
                                </div>
                            </div>
                        </div>
                        <div class="row" style="display:none;">
                            <div class="form-group" style="margin-left: 1%; margin-right: 1%;">
                                <label class="col-sm-1 control-label">Biller</label>
                                <div class="col-sm-3" style="height: 40px;">
                                    <select name="biller" id="biller" class="form-control" disabled>
                                        <option value="{{ Auth::user()->id }}">{{ Auth::user()->name }}</option>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="panel panel-default">
                            <div class="panel-body">
                                <div class="form-group">
                                    <table id="myTable">
                                        <div class="container-fluid">
                                            <div class="row">
                                                <tr>

                                                    <!-- <div class="col-md-3">
             <div class="form-group">
              <label for="H.S" class="control-label">Id</label> -->
                                                    {!! Form::hidden('product_id', null, ['id' => 'product_id', 'class' => 'form-control']) !!}
                                                    <!-- </div>
            </div>  -->
                                                    <div class="col-md-1" style="margin-left: 1%; margin-right: 1%;">
                                                        <div class="form-group">
                                                            <label for="H.S" class="control-label">Date</label>
                                                            <input id="date" type="date" name="date"
                                                                value="<?php echo date('Y-m-d'); ?>" class="form-control">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-1"
                                                        style="display:none;margin-left: 1%; margin-right: 1%;">
                                                        <div class="form-group">
                                                            <label for="password"
                                                                class="control-label">Voucher&nbsp;No</label>
                                                            {!! Form::text('voucher_no', $codes, ['id' => 'voucher_no', 'class' => 'form-control']) !!}
                                                        </div>
                                                    </div>
                                                    <div class="col-md-1" style="margin-left: 1%; margin-right: 1%;">
                                                        <div class="form-group">
                                                            <label for="password"
                                                                class="control-label">Cheque&nbsp;No</label>
                                                            {!! Form::text('cheque_no', null, ['id' => 'cheque_no', 'class' => 'form-control']) !!}
                                                        </div>
                                                    </div>
                                                    <div class="col-md-2" style="display:none;">
                                                        <div class="form-group">
                                                            <label for="password" class="control-label">Type</label>
                                                            {!! Form::text('v_type', 'Bank Receipt', ['id' => 'v_type', 'class' => 'form-control']) !!}
                                                        </div>
                                                    </div>
                                                    <div class="col-md-1">
                                                        <div class="form-group">
                                                            <label for="Name"
                                                                class="control-label">Account Type</label>
                                                            {!! Form::select('account_type', $accountGroups, null, ['id' => 'account_type', 'class' => 'form-control']) !!}
                                                        </div>
                                                    </div>
                                                    <div class="col-md-1" style="margin-left: 1%; margin-right: 1%;">
                                                        <div class="form-group">
                                                            <label for="Name"
                                                                class="control-label">Account&nbsp;Name</label>
                                                            {!! Form::select('account_head_id', $Accounts, null, ['id' => 'account_head_id', 'class' => 'form-control']) !!}
                                                        </div>
                                                    </div>
                                                    <div class="col-md-1"
                                                        style="margin-left: 1%; margin-right: 1%;display:none;">
                                                        <div class="form-group">
                                                            <label for="Name" class="control-label">Bank&nbsp;Name</label>
                                                            {!! Form::select('bank_id', $banks, null, ['id' => 'bank_id', 'class' => 'form-control livesearch']) !!}
                                                        </div>
                                                    </div>
                                                    <div class="col-md-1" style="margin-left: 1%; margin-right: 1%;">
                                                        <div class="form-group">
                                                            <label for="password" class="control-label">Description</label>
                                                            {!! Form::text('narration', 'Bank Receipt', ['id' => 'narration', 'class' => 'form-control']) !!}
                                                        </div>
                                                    </div>
                                                    <div class="col-md-1" style="margin-left: 1%; margin-right: 1%;">
                                                        <div class="form-group">
                                                            <label for="password" class="control-label">Amount</label>
                                                            {!! Form::text('credit', null, ['id' => 'credit', 'class' => 'form-control', 'onfocus' => 'this.value=""', 'onkeypress' => 'return onlyNumberKey(event)']) !!}
                                                        </div>
                                                    </div>
                                                    <div class="col-md-1" style="margin-left: 1%; margin-right: 1%;">
                                                        <div class="form-group">
                                                            <label for="password" class="control-label">Tax</label>
                                                            {!! Form::text('tax', null, ['id' => 'tax', 'class' => 'form-control', 'onfocus' => 'this.value=""', 'onkeypress' => 'return onlyNumberKey(event)', 'onchange' => 'changeAmount(this.value)']) !!}
                                                        </div>
                                                    </div>
                                                    <div class="col-md-1" style="margin-left: 1%; margin-right: 1%;">
                                                        <div class="form-group">
                                                            <label for="taxamount" class="control-label">Tax Amount</label>
                                                            {!! Form::text('taxamount', null, ['id' => 'taxamount', 'class' => 'form-control', 'disabled' => 'disabled']) !!}
                                                        </div>
                                                    </div>
                                                    <div class="col-md-1" style="margin-left: 1%; margin-right: 1%;">
                                                        <div class="form-group">
                                                            <label for="taxamount" class="control-label">Title</label>
                                                            {!! Form::select('title', $titles, null, ['id' => 'title', 'class' => 'form-control']) !!}
                                                        </div>
                                                    </div>
                                                    <div class="col-md-1">
                                                        <div class="form-group">
                                                            <label for="password" class="control-label">Add</label>

                                                            <button class="form-control" style="background: #e20707;"
                                                                type="button" class="btn btn-red"
                                                                onkeyup="AddGridData();">Add</button>
                                                            <!-- <button type="button" onclick="AddGridData()" class="btn btn-red"><i class="fa fa-plus"></i> </button> -->
                                                        </div>
                                                    </div>
                                                </tr>
                                            </div>
                                        </div>
                                    </table><br><br>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="panel panel-default">
                                    <div class="panel-heading clearfix" id="subpanelbg">
                                        <h3 class="panel-title">Cheque Payment Grid</h3>
                                    </div>
                                    <div class="panel-body">
                                        <div class="table-responsive">
                                            <table class="table table-bordered">
                                                <thead>
                                                    <tr>
                                                        <th>Dlt</th>
                                                        <th style="display:none;">Head&nbsp;ID</th>
                                                        <th>Date</th>
                                                        <th style="display:none;">Voucher&nbsp;No</th>
                                                        <th>Cheque&nbsp;No</th>
                                                        <th style="display:none;">Type</th>
                                                        <th>Account&nbsp;Name</th>
                                                        <th>Bank&nbsp;Name</th>
                                                        <th>Narration</th>
                                                        <!-- <th>Debit</th> -->
                                                        <th>Amount</th>
                                                        <th>Tax</th>
                                                        <th>Tax Amount</th>
                                                        <th>Title</th>
                                                    </tr>
                                                </thead>
                                                <tbody id="GridTable">
                                                    <div class="row">
                                                    </div>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="panel panel-default">
                                    <div class="panel-heading clearfix" id="panelbg">
                                        <div class="container">
                                            <div class="col-lg-5"> </div>
                                            <!-- <div class="col-xs-3">  </div> -->
                                            <!-- <div class="col-xs-3"> <b>Total Rate</b> <input type="text" id="TotalRate" name="TotalRate" value="" disabled	></div> -->
                                            <div class="col-lg-3"> <b>Total&nbsp;Amount</b> <input type="text"
                                                    id="TotalAmount" name="TotalAmount" value="0" disabled> </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <center>
                            <div class="form-actions">
                                <button type="button" class="btn btn-primary" id="btnSave" name="btnSave">Save</button>
                            </div>
                        </center>
                        <div class="col-lg-3">
                        </div>
                        {!! Form::close() !!}
                    </div>
                </div>
            </div>
        </div>
    </body>
@stop
@section('scripts')
<script src="{{ asset('js/plugins/select2/select2.full.min.js') }}"></script>
<script type="text/javascript">
        // $("#account_type").select2();
        // $("#account_type").next(".select2").find(".select2-selection").focus(function() {
        //     $("#account_type").select2("open");
        // });

        $("#account_head_id").select2();
        $("#account_head_id").next(".select2").find(".select2-selection").focus(function() {
            $("#account_head_id").select2("open");
        });

        $("#account_id").select2();
        $("#account_id").next(".select2").find(".select2-selection").focus(function() {
            $("#account_id").select2("open");
        });

        $("#account_type").select2();
        $("#account_type").next(".select2").find(".select2-selection").focus(function() {
            $("#account_type").select2("open");
        });
        $("#title").select2();
        $("#title").next(".select2").find(".select2-selection").focus(function() {
            $("#title").select2("open");
        });


        $('#account_id').change(function() {
            $('#account_id').select2().trigger('select2:close');
            $("#date").focus();
        });

        $('#account_head_id').change(function() {
            $('#account_head_id').select2().trigger('select2:close');
            $("#credit").focus();
        });

        
    </script>
    <script type="text/javascript">
        function changeAmount(tax) {
            var amount = parseInt(document.getElementById('credit').value);
            // if(amount=='' || parseInt(amount)==0){
            //     alert('Please Enter Tax');
            // }
            // var taxAmount = (tax/100)*amount;
            // alert(tax);
            // alert(amount);
            var taxAmount = parseInt((tax * amount) / 100);
            // console.log(taxAmount);
            document.getElementById('taxamount').value = taxAmount;
            var calculateAmount = amount - taxAmount;
            document.getElementById('credit').value = calculateAmount;
        }


        function AddGridData() {
            if ($("#credit").val() == "" || $("#account_head_id").val() == "") {
                document.getElementById("credit").focus();
                Swal.fire('Account Name or Amount Value Cant be Empty!');
                e.preventdefault();
            }

            var date = document.getElementById('date').value;
            var VoucherNo = document.getElementById('voucher_no').value;
            var ChequeNo = document.getElementById('cheque_no').value;
            var v_type = document.getElementById('v_type').value;
            var HeadTitle = document.getElementById('account_head_id').value.split("_").pop();
            var HeadId = document.getElementById('account_head_id').value.split("_")[0];
            var BankName = document.getElementById('bank_id').value.split("_").pop();
            var BankId = document.getElementById('bank_id').value.split("_")[0];
            var Narration = document.getElementById('narration').value;
            // var Debit = document.getElementById('debit').value;
            var Credit = document.getElementById('credit').value;

            var tax = document.getElementById('tax').value;
            var taxAmount = document.getElementById('taxamount').value;
            var title = document.getElementById('title').value;


            var total = document.getElementById('TotalAmount').value;
            var grand = parseInt(Credit) + parseInt(total);
            document.getElementById('TotalAmount').value = grand;
            var tableHtml = '<tr>';
            tableHtml +=
                '<td class="text-center"><i onclick="javascript:myDeleteFunction($(this).closest(\'tr\'));" class="icon-cancel icon-larger red-color" title="Delete Row"></i> </td>';
            tableHtml += '<td style="display:none;">' + HeadId + '</td>';
            tableHtml += '<td>' + date + '</td>';
            tableHtml += '<td style="display:none;">' + VoucherNo + '</td>';
            tableHtml += '<td>' + ChequeNo + '</td>';
            tableHtml += '<td style="display:none;">' + v_type + '</td>';
            tableHtml += '<td>' + HeadTitle + '</td>';
            tableHtml += '<td style="display:none;">' + BankId + '</td>';
            tableHtml += '<td>' + BankName + '</td>';
            tableHtml += '<td>' + Narration + '</td>';
            // tableHtml += '<td>'+ Debit +'</td>';
            tableHtml += '<td>' + Credit + '</td>';
            tableHtml += '<td>' + tax + '</td>';
            tableHtml += '<td>' + taxAmount + '</td>';
            tableHtml += '<td>' + title + '</td>';
            tableHtml += '</tr>';
            $('#GridTable').append(tableHtml);
            document.getElementById("date").focus();
        }

        function myDeleteFunction(row) {
            Swal.fire({
                    title: "Are You Sure?",
                    text: "Confirm Transaction?",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonText: 'Yes, Create it!',
                    confirmButtonColor: '#28A745',
                    cancelButtonText: 'No, cancel!',
                    cancelButtonColor: '#DC3545',
                }).then((result) => {
                    if (result.isConfirmed) {
                    var total = document.getElementById('TotalAmount').value;
                    var amount = $(row).find("td:eq('10')").text();
                    //alert(amount)
                    var grand = parseInt(total) - parseInt(amount);
                    document.getElementById('TotalAmount').value = grand;
                    $(row).remove();
                }
            });
        }

        $("#btnSave").click(function() {
            if ($('#account_id').val() == '') {
                        //  alert('Please Select Supplier');
                         Swal.fire('Select Bank Account First');
                        //   $('#account_id').select2('open');
                          return false;
                    }
                    Swal.fire({
                    title: "Are You Sure?",
                    text: "Confirm Transaction?",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonText: 'Yes, Create it!',
                    confirmButtonColor: '#28A745',
                    cancelButtonText: 'No, cancel!',
                    cancelButtonColor: '#DC3545',
                }).then((result) => {
                    if (result.isConfirmed) {
                    var voucher = new Object();
                    var voucher = new Object();
                    voucher.voucher_no = $("#voucher_no").val();
                    voucher.voucher_date = $("#voucher_date").val();
                    voucher.account_id = $("#account_id").val().split("_")[0];
                    voucher.v_type = $("#v_type").val();
                    voucher.biller = $("#biller").val();
                    voucher.company_id = $('#company_id').val();

                    var products = [];
                    $.each($("#GridTable tr"), function(index, row) {
                        var columns = $(row).find("td");
                        var product = new Object();
                        // product.party_id = $("#party_id").val();
                        product.head_id = $(columns[1]).text();
                        product.date = $(columns[2]).text();
                        product.voucher_no = $(columns[3]).text();
                        product.cheque_no = $(columns[4]).text();
                        product.v_type = $(columns[5]).text();
                        product.bank_id = $(columns[7]).text();
                        product.narration = $(columns[9]).text();
                        product.amount = $(columns[10]).text();
                        product.company_id = $('#company_id').val();
                        product.tax = $(columns[11]).text();
                        product.taxAmount = $(columns[12]).text();
                        product.title = $(columns[13]).text();
                        products.push(product);
                    });

                    var $_token = jQuery('#token').val();
                    if(products != ""){
                    jQuery.ajax({
                        method: "POST",
                        cache: false,
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        data: {
                            voucher: JSON.stringify(voucher),
                            product_data: products
                        },
                        url: "{{ asset('bank-receipts') }}",

                        success: function(result) {
                            //if(result == "saved")
                            if (parseInt(result) > 0) {
                                //window.open("/sales/print/"+result);
                                window.location.href = "{{ asset('bank-receipts/create') }}";
                                //alert("Bank Receipt successfully saved.");
                                window.open("{{ asset('bank-receipts') }}/" + result);
                                //alert("Sale successfully saved.");
                                //Session::flash('flash_message', 'Sale Added Successfully!');
                                //window.location.href = "/sales";

                            }
                        },
                        error: function(xhr, ajaxOptions, thrownError) {
                            $("#spanWait").hide();
                            alert(xhr.status);
                            alert(thrownError);
                        }
                    });
                } else {
                    Swal.fire('Add your Account in Grid');
                }
            }
            });
        });


        //Select Account Type, SHow Related Acccounts
        $('#account_type').change(function(){
            var account_type = $(this).val();
            $.ajax({
                url:"{{ asset('get_account_group_parties') }}?id="+account_type,
                type:'get',
                dataType:'json',
                success:function(response){
                    if(response.length==0)
                    {
                        $('#select2-account_head_id-container').text('Account Not Found');
                        $('#account_head_id').html('<option>Account Not Found</option>');
                    }else{
                        $('#select2-account_head_id-container').text('Select Value');
                        var str=`<option value="">Select Value</option>`;
                        $.each(response,function(i,v){
                            str+=`<option value="${v.id+'_'+v.party_name}">${v.party_name}</option>`;
                        });
  
                        $('#account_head_id').html(str);
                        $('#account_head_id').select2('open');
                    }   
                }
            });
        });
        // End Here
    </script>
@stop
