<?php

namespace App\Http\Controllers;

use Maatwebsite\Excel\Facades\Excel;
use App\Exports\ExportSalesTaxReport;
use Illuminate\Http\Request;
use App\Models\Party;
use App\Models\SaleTax;
use App\Models\Setting;
use App\Models\Warehouse;

class SaleTaxReportController extends Controller
{
    public function index()
    {
        //
    }

    public function create()
    {
        $parties = Party::where('company_id', session()->get('company_id'))
            ->where('account_group_id', '=', 1)
            ->where('party_name', '!=', 'CASH IN HAND')
            ->OrderBy('party_name', 'asc')
            ->pluck('party_name', 'id')
            ->toArray();
        $shops = Warehouse::OrderBy('name', 'asc')->pluck('name', 'id')->prepend('ALL BRANCHES', '0')->toArray();
        //return $suppliers;
        $encrypter = app('Illuminate\Encryption\Encrypter');
        $encrypted_token = $encrypter->encrypt(csrf_token());
        return view('salestax-report.all-party.create', Compact('encrypted_token', 'parties', 'shops'));
    }

    public function store(Request $request)
    {
        $encrypter = app('Illuminate\Encryption\Encrypter');
        $encrypted_token = $encrypter->encrypt(csrf_token());
        $fromDate = $request->get('from_date');
        $toDate = $request->get('to_date');
        $ShopID = $request->get('shop_id');
        $ReportDetail = $request->get('ReportDetail');
        $company_detail = Setting::where('id', '=', 1)->get();
        $warehouse = Warehouse::where('id', '=', $ShopID)->get();
        //return $warehouse;

        if($ReportDetail == 3)
        {
            // return "d";
            return Excel::download(new ExportSalesTaxReport($fromDate,$toDate), 'salestax-all-party-report.xlsx');
        }

        if ($ReportDetail == 1) {
            if ($ShopID == 0) {
                //return $supplier;
                $sales = SaleTax::with('saletax_details')->with('parties')
                    //->whereBetween('date', [$fromDate, $toDate])
                    ->where('sale_type', 'SalesTax Invoice')
                    ->where('company_id', session()->get('company_id'))
                    ->whereDate('date', '>=', $fromDate)
                    ->whereDate('date', '<=', $toDate)
                    ->OrderBy('id', 'asc')->get();

                return view('salestax-report.all-party.detail', compact('sales', 'encrypted_token', 'company_detail', 'fromDate', 'toDate', 'warehouse'));
            } else {
                $sales = SaleTax::where('warehouse_id', '=', $ShopID)->with('saletax_details')->with('parties')
                ->where('sale_type', 'SalesTax Invoice')
                    ->where('company_id', session()->get('company_id'))
                    ->whereDate('date', '>=', $fromDate)
                    ->whereDate('date', '<=', $toDate)
                    //->whereBetween('date', [$fromDate, $toDate])
                    ->OrderBy('id', 'asc')->get();

                return view('salestax-report.all-party.detail', compact('sales', 'encrypted_token', 'company_detail', 'fromDate', 'toDate', 'warehouse'));
            }
        } else {
            if ($ShopID == 0) {
                //return $supplier;
                $sales = SaleTax::with('saletax_details')->with('parties')
                    //->whereBetween('date', [$fromDate, $toDate])
                    ->where('sale_type', 'SalesTax Invoice')
                    ->where('company_id', session()->get('company_id'))
                    ->whereDate('date', '>=', $fromDate)
                    ->whereDate('date', '<=', $toDate)
                    ->OrderBy('id', 'asc')->get();

                return view('salestax-report.all-party.summary', compact('sales', 'encrypted_token', 'company_detail', 'fromDate', 'toDate', 'warehouse'));
            } else {
                $sales = SaleTax::where('warehouse_id', '=', $ShopID)->with('saletax_details')->with('parties')
                    ->where('sale_type', 'SalesTax Invoice')
                    ->where('company_id', session()->get('company_id'))
                    ->whereDate('date', '>=', $fromDate)
                    ->whereDate('date', '<=', $toDate)
                    //->whereBetween('date', [$fromDate, $toDate])
                    ->OrderBy('id', 'asc')->get();
                //return $sales;
                return view('salestax-report.all-party.summary-single', compact('sales', 'encrypted_token', 'company_detail', 'fromDate', 'toDate', 'warehouse'));
            }
        }
    }

    public function SingleParty()
    {
        // return session()->get('company_id');
        $parties = Party::OrderBy('party_name', 'asc')
            ->where('account_group_id', '=', 1)
            ->where('party_name', '!=', 'CASH IN HAND')
            ->where('company_id', session()->get('company_id'))
            ->pluck('party_name', 'id')
            ->toArray();
        //return $suppliers;
        $encrypter = app('Illuminate\Encryption\Encrypter');
        $encrypted_token = $encrypter->encrypt(csrf_token());
        return view('salestax-report.single-party.create', Compact('encrypted_token', 'parties'));
    }

    public function ShowSingleParty(Request $request)
    {
        $suppliers = "";
        $encrypter = app('Illuminate\Encryption\Encrypter');
        $encrypted_token = $encrypter->encrypt(csrf_token());
        $partyID = $request->get('party_name');
        $fromDate = $request->get('from_date');
        $toDate = $request->get('to_date');
        // return $partyID;
        $sales = SaleTax::with('saletax_details')
            ->with('parties')
            ->where('party_id', '=', $partyID)
            ->where('company_id', session()->get('company_id'))
            ->whereDate('date', '>=', $fromDate)
            ->whereDate('date', '<=', $toDate)
            ->OrderBy('id', 'asc')
            ->get();

        // return $sales;


        $party = Party::where('id', '=', $partyID)->where('company_id', session()->get('company_id'))->get();

        //$suppliers = Supplier::OrderBy('name', 'asc')->pluck('name', 'id')->toArray();
        $company_detail = Setting::where('id', '=', 1)->get();
        return view('salestax-report.single-party.index', compact('sales', 'encrypted_token', 'suppliers', 'company_detail', 'fromDate', 'toDate', 'party'));
    }

    public function show($id)
    {
        //
    }

    public function edit($id)
    {
        //
    }

    public function update(Request $request, $id)
    {
        //
    }

    public function destroy($id)
    {
        //
    }
}
