<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Product;
use App\Models\Catagory;
use App\Models\Publisher;
use App\Models\Setting;
use App\Models\UOM;
use App\Models\Tax;
use App\Models\User;
use App\Models\Companies;
use Illuminate\Support\Facades\Session;
use PDF;
use Auth;
use Excel;

class ProductController extends Controller
{
  public function __construct()
  {
    $this->middleware('auth');
  }

  public function index()
  {
    // return session()->get('company_id');
    if(session()->get('company_id')){
      $products = Product::with('catagories')
      ->where('company_id', session()->get('company_id'))
      ->OrderBy('product_code', 'asc')
      ->get();
    }else{
      $products = Product::with('catagories')
      ->where('company_id', 0)
      ->OrderBy('product_code', 'asc')
      ->get();
    }
       // return $products;
    return view('products.index', Compact('products'));
  }

  public function create()
  {
    $codes = 0;
    //return "d0";
    $code = Product::where('company_id', session()->get('company_id'))
      ->OrderBy('product_code', 'desc')->first();
    if (isset($code) > 0) {
      $codes = $code->product_code + 1;
    } else {
      $codes = 1;
    }
    //return $codes;

    //return $code;
    //  return $party = session()->get('company_type');
    $user = User::where('id', session()->get('company_id'))->get();
    
    if(session()->get('company_type') == "Manufacturer"){
      $catagories = Catagory::where('id', 5)->Orwhere('id', 8)->pluck('catagory_name', 'id');
    }else{
      $catagories = Catagory::where('id', 5)->pluck('catagory_name', 'id');
    }
   
    
    //  return $catagories;
    $tax = Tax::OrderBy('tax_rate', 'asc')->pluck('tax_title', 'tax_rate');
    $uoms = UOM::OrderBy('id', 'asc')->pluck('uom', 'uom');
    // return $uoms;
    return view('products.create', Compact('catagories', 'codes', 'uoms', 'tax'));
  }

  public function hsCode(Request $request){
    // return $request;

    $CompanyID = session()->get('company_id');
    // $purchase = json_decode($request->get('purchase'), true);
    $sellerCompany = Companies::where('id', $CompanyID)->first();
    if($sellerCompany){
      $token = $sellerCompany['sandbox_token'];
    }else{
      //Any company token for admin
      $token = "6a2079f8-b91b-3d0b-9271-92e8d33edc9a";
    }
    $curl = curl_init();
    curl_setopt_array($curl, [
        // CURLOPT_URL => 'https://gw.fbr.gov.pk/pdi/v1/HS_UOM?hs_code=$request->product_code[$i]&annexure_id=3',
        CURLOPT_URL => 'https://gw.fbr.gov.pk/pdi/v1/HS_UOM?hs_code=' . urlencode($request->hs_code) . '&annexure_id=3',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'GET',
        CURLOPT_HTTPHEADER => [
            'Authorization: Bearer "' . $token . '"',
            // 'Content-Type: application/json',
            'Cookie: key=value; JSESSIONID=IYFCgbVx4GhV2E-MMPlepV3DlG8b0HU4N_la2DUA.i01-irisdmz56; cookiesession1=678B2A2CB3F1FF7FD24B6E462AB80DD1'
        ],
    ]);
    $response = curl_exec($curl);
    $uomData = json_decode($response, true);

    return $uomData;
  }

  public function store(Request $request)
  {
    // return $request;
    $this->validate($request, [
      'product_code' => 'required',
      'product_name' => 'required',
      'uom' => 'required',
      'tax' => 'required',
      // 'product_cost' => 'required',
      // 'product_price' => 'required'
    ]);
    Product::create($request->all());
    Session::flash('flash_message', 'Product Added Successfully!');
    return redirect('products/create');
  }

  public function show($id)
  {
    //
  }

  public function edit($id)
  {
    $user = User::where('id', session()->get('company_id'))->get();
    if(session()->get('company_type') == "Manufacturer"){
      $catagories = Catagory::where('id', 5)->Orwhere('id', 8)->pluck('catagory_name', 'id');
    }else{
      $catagories = Catagory::where('id', 5)->pluck('catagory_name', 'id');
    }
    $edit = Product::findOrFail($id);
    // $catagories = Catagory::where('id', 5)->Orwhere('id', 8)->pluck('catagory_name', 'id');
    $uoms = UOM::OrderBy('id', 'asc')->pluck('uom', 'uom');
    $tax = Tax::OrderBy('id', 'asc')->pluck('tax_title', 'tax_rate');
    // $publishers = Publisher::OrderBy('name', 'asc')->pluck('name', 'id');
    return view('products.edit', Compact('edit', 'catagories', 'uoms', 'tax'));
  }

  public function update(Request $request, $id)
  {
    // return $request;
    $this->validate($request, [
      'product_code' => 'required',
      'product_name' => 'required',
      'uom' => 'required',
      //'product_english' => 'required',
      'tax' => 'required', //,
      // 'product_cost' => 'required',
      // 'product_price' => 'required'
    ]);
    $update = Product::findOrFail($id);
    $update->update($request->all());
    Session::flash('flash_message', 'Product Updated Successfully!');
    return redirect('products');
  }

  public function destroy($id)
  {
    $delete = Product::findOrFail($id);
    $delete->delete();
    Session::flash('flash_message', 'Product deleted Successfully!');
    return redirect('products');
    return "Prduct Deleted Successfully!";
  }

  public function stockAlert()
  {
    $products = Product::with('catagories')
      ->where('company_id', session()->get('company_id'))
      ->OrderBy('product_name', 'asc')->get();
    //return $products;
    return view('products.alertstock', Compact('products'));
  }

  public function print_books()
  {
    // return "dfd";
    $products = Product::with('catagories')
      ->where('company_id', session()->get('company_id'))
      ->OrderBy('id', 'asc')
      ->get();

    $company_detail = Setting::where('id', '=', 1)->get();
    return view('products.print', Compact('products', 'company_detail'));
  }

  public function getPDF()
  {
    $products = Product::with(['publisher_detail'])
      ->with(['products_detail'])
      ->with('sale_detail')
      ->where('company_id', session()->get('company_id'))
      ->OrderBy('product_name', 'asc')
      ->get();
    $company_detail = Setting::where('id', '=', 1)->get();
    $pdf = PDF::loadView('products.productspdf', ['products' => $products, 'company_detail' => $company_detail]);
    return $pdf->download('products.pdf');
  }

  public function ImportExcel(Request $request)
  {
    $this->validate($request, [
      'import_file' => 'required'
    ]);
    $path = $request->file('import_file')->getRealPath();
    $results = Excel::load($path)->get();
    //return $results;
    if (!empty($results) && $results->count()) {
      foreach ($results as $row) {
        //foreach ($rows as $row) {
        if (($row->product_name) != null) {
          Product::create([
            'catagory_id'  => $row->catagory_id,
            'product_code'  => $row->product_code,
            'product_name'  => $row->product_name,
            'uom'  => $row->uom,
            'product_cost'  => $row->product_cost,
            'product_price'  => $row->product_price,
            'alert'  => $row->alert,
            'company_id' => session()->get('company_id')
          ]);
        }
        //}
      }
    }

    Session::flash('flash_message', 'Excel Sheet Imported Successfully!');
    return redirect('products/importExcel/create');
  }


  public function createImportExcel()
  {
    return view('products.importExcel.create');
  }

  public function getExcel()
  {
    //$data = Product::with(['publisher_detail'])->with(['products_detail'])->with('sale_detail')->OrderBy('product_name', 'asc')->get(['products.product_code AS Code', 'Product_english AS Book', 'publishers.name AS Publisher', 'products.year', 'products.product_price'])->toArray();
    $data = Product::where('company_id', session()->get('company_id'))
      ->OrderBy('product_name', 'id')
      ->get(['catagory_id',  'products.product_code AS Code', 'product_name', 'products.uom', 'product_cost', 'product_price', 'products.alert'])->toArray();
    return Excel::create('products.importExport', function ($excel) use ($data) {
      $excel->sheet('mySheet', function ($sheet) use ($data) {
        $sheet->fromArray($data);
      });
    })->download();
  }

  public function UpdateName(Request $request)
  {
    $name = json_decode($request->get('name'), true);
    $id = $request->get('product_name');
    $product = Product::findOrFail($id);
    $product->product_name = $name;
    $product->save();
  }

  public function UpdateCode(Request $request)
  {
    $name = json_decode($request->get('code'), true);

    $id = $request->get('product_code');
    //return $id;
    $product = Product::findOrFail($id);
    $product->product_code = $name;
    $product->save();
  }

  public function UpdateCost(Request $request)
  {
    $cost = json_decode($request->get('cost'), true);
    $id = $request->get('product_id');
    $product = Product::findOrFail($id);
    $product->product_cost = $cost;
    $product->save();
  }

  public function UpdatePrice(Request $request)
  {
    // $cost = json_decode(Input::get('cost'), true);
    $price = json_decode($request->get('price'), true);
    //return $cost;
    $id = $request->get('product_id');
    //return $id;
    $product = Product::findOrFail($id);
    $product->product_price = $price;
    $product->save();
    // $product = Product::where('id', '=', $id);
    //return $product;
  }

  public function updateWeight(Request $request)
  {
    $weight = json_decode($request->get('weight'), true);
    //return $cost;
    $id = $request->get('product_id');
    //return $id;
    $product = Product::findOrFail($id);
    $product->pack_weight = $weight;
    $product->save();
  }

  public function updateAlert(Request $request)
  {
    $alert = json_decode($request->get('alertvalue'), true);
    //return $cost;
    $id = $request->get('product_id');
    //return $id;
    $product = Product::findOrFail($id);
    $product->alert = $alert;
    $product->save();
  }
}
