<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Party;
use App\Models\Setting;
use App\Models\AccountGroup;
use App\Models\Warehouse;
use App\Models\Banks;
use Illuminate\Support\Facades\Session;
use PDF;
use Excel;
use Illuminate\Support\Facades\DB;

class PartyController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    {
        $party = Party::join('account_groups', 'account_groups.id', '=', 'parties.account_group_id')
            ->where('company_id', session()->get('company_id'))
            ->OrderBy('party_name', 'asc')
            ->get(['parties.*', 'account_groups.name']);

        return view('parties.index', Compact('party'));
    }

    public function createImportExcel()
    {
        return view('parties.importExcel.create');
    }


    public function ImportExcel(Request $request)
    {
        //return "d";
        $this->validate($request, [
            'import_file' => 'required'
        ]);
        $path = $request->file('import_file')->getRealPath();
        $results = Excel::load($path)->get();
        //return $results;
        if (!empty($results) && $results->count()) {
            $sum = 1;
            foreach ($results as $row) {
                //return $row->party_name;
                //foreach ($rows as $row) {
                $sum = $sum + 1;
                if (($row->party_name) != null) {
                    Party::create([
                        'code'  => $sum,
                        'account_group_id'  => 1,
                        'shop_id'  => 1,
                        'account_type'  => "CUSTOMER",
                        'party_name'  => $row->party_name,
                        'phone'  => $row->phone,
                        'city'  => "LAHORE",
                        'address'  => $row->address,

                    ]);
                }
                //}
            }
        }

        Session::flash('flash_message', 'Parties Imported Successfully!');
        return redirect('parties/importExcel/create');
    }

    public function create()
    {
        //$AccountGroups = AccountGroup::OrderBy('name', 'asc')->pluck('name', 'id');
        $AccountGroups = AccountGroup::select(DB::raw('CONCAT(`id`, "_", `name`) AS `id`, `name`'))
            // ->where('code', '!=', 10)
            // ->where('code', '!=', 11)
            // ->where('code', '!=', 12)
            ->OrderBy('name', 'asc')
            ->pluck('name', 'id')
            ->toArray();
        // $Supplier = AccountGroup::where('milk_supplier', '=', 1)->select(DB::raw('CONCAT(`milk_supplier`, "_", `name`) AS `milk_supplier`, `name`'))->OrderBy('name', 'asc')->pluck('name', 'milk_supplier')->toArray();
        // $Supplier = AccountGroup::where('milk_supplier', '=', 1)->pluck('name', 'id')->toArray();
        $banks = Banks::pluck('name', 'id')->prepend('No Bank')->toArray();
        $shop = Warehouse:: //where('id', '!=', 1)->
            OrderBy('name', 'asc')->pluck('name', 'id')->prepend('Select Shop', '0')->toArray();
        //return $shop;
        $code = Party::where('company_id', session()->get('company_id'))
            ->OrderBy('id', 'desc')
            ->get();
        // return $code;

        $codes = 0;
        // $codes = (int)$code->last()->code + 1;
        if (count($code) > 0) {
            $codes = (int)$code[0]->code + 1;
        } else {
            $codes = 1;
        }

        $designations = array('Accountant' => 'Accountant', 'Admin' => 'Admin', 'Director' => 'Director', 'Labour' => 'Labour', 'Selling' => 'Selling');
        $status = array('BTL' => 'BTL', 'TAXABLE' => 'TAXABLE');
        $salary_status = array('DIRECT' => 'DIRECT', 'IN DIRECT' => 'IN DIRECT');

        return view('parties.create', Compact('AccountGroups', 'codes', 'shop', 'banks', 'designations', 'status', 'salary_status'));
    }

    public function store(Request $request)
    {
         //return $request->all();
        $this->validate($request, [
            'code' => 'required',
            'party_name' => 'required',
            'account_type' => 'required',
            'ntn' => 'required',
            'address' => 'required',
            // 'ntn' => 'unique:parties',
            // 'strn' => 'unique:parties',
        ]);
        Party::create($request->all());
        Session::flash('flash_message', 'Account added Successfully!');
        return redirect('parties/create');
    }

    public function show($id)
    {
        $party = Party::with(['party' => function ($query) {
            $query->with('products');
        }])
            ->where('id', '=', $id)
            ->where('company_id', session()->get('company_id'))
            ->OrderBy('party_name', 'asc')
            ->get();
        $company_detail = Setting::where('id', '=', 1)->get();
        //return $party;
        return view('parties.details', Compact('party', 'company_detail'));
    }

    public function edit($id)
    {
        $edit = Party::findOrFail($id);
        //return $edit;
        //$AccountGroups = AccountGroup::OrderBy('name', 'asc')->pluck('name', 'id');
        $AccountGroups = AccountGroup::select(DB::raw('CONCAT(`id`, "_", `name`) AS `id`, `name`'))
            ->where('code', '!=', 10)
            ->where('code', '!=', 11)
            ->where('code', '!=', 12)
            ->OrderBy('name', 'asc')
            ->pluck('name', 'id')
            ->prepend('Select Account')
            ->toArray();
        $shop = Warehouse:: //where('id', '!=', 1)->
            OrderBy('name', 'asc')->pluck('name', 'id')->toArray();
        $banks = Banks::pluck('name', 'id')->prepend('No Bank')->toArray();
        // $Supplier = AccountGroup::where('milk_supplier', '=', 1)->pluck('name', 'id')->toArray();

        $designations = array('Accountant' => 'Accountant', 'Admin' => 'Admin', 'Director' => 'Director', 'Labour' => 'Labour', 'Selling' => 'Selling');
        $status = array('BTL' => 'BTL', 'TAXABLE' => 'TAXABLE');
        $salary_status = array('DIRECT' => 'DIRECT', 'IN DIRECT' => 'IN DIRECT');

        return view('parties.edit', Compact('edit', 'AccountGroups', 'shop', 'banks', 'designations', 'status', 'salary_status'));
    }

    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'code' => 'required',
            'party_name' => 'required',
            'account_type' => 'required',
            'ntn' => 'required',
            'address' => 'required',
            // 'ntn' => 'unique:parties',
            // 'strn' => 'unique:parties',
        ]);
        $update = Party::findOrFail($id);
        $update->update($request->all());
        Session::flash('flash_message', 'Account Updated Successfully!');
        return redirect('parties');
    }

    public function destroy($id)
    {
        // return $id;
        $delete = Party::findOrFail($id);
        $delete->delete();
        Session::flash('flash_message', 'Account deleted Successfully!');
        return redirect('parties');
        return redirect()->back()->with('success', 'Party deleted successfully!');
        return ("Party has been deleted!");
    }

    public function print_parties()
    {
        $party = Party::join('account_groups', 'account_groups.id', '=', 'parties.account_group_id')
            ->where('company_id', session()->get('company_id'))
            ->OrderBy('party_name', 'asc')
            ->get(['parties.*', 'account_groups.name']);
        $company_detail = Setting::where('id', '=', 1)->get();
        return view('parties.print', Compact('party', 'company_detail'));
    }

    public function getPDF()
    {
        $parties = Party::where('company_id', session()->get('company_id'))
            ->OrderBy('party_name', 'asc')
            ->get();
        $company_detail = Setting::where('id', '=', 1)->get();
        $pdf = PDF::loadView('parties.partypdf', ['parties' => $parties, 'company_detail' => $company_detail]);
        return $pdf->download('parties.pdf');
    }

    public function getExcel()
    {
        $data = Party::where('company_id', session()->get('company_id'))
            ->OrderBy('party_name', 'asc')
            ->get(['parties.id', 'parties.party_name', 'parties.phone', 'parties.ntn', 'parties.strn', 'parties.city', 'parties.address'])->toArray();
        return Excel::create('parties', function ($excel) use ($data) {
            $excel->sheet('mySheet', function ($sheet) use ($data) {
                $sheet->fromArray($data);
            });
        })->download();
    }
}
