<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Partners;
use Illuminate\Support\Facades\Session;

class PartnersController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    {
        $taxes = Partners::OrderBy('id', 'asc')->get();
        return view('partners.index', Compact('taxes'));
    }

    public function create()
    {
        return view('partners.create');
    }

    public function store(Request $request)
    {
        $this->validate($request, [
            'name' => 'required',
            'email' => 'required',
            'contact' => 'required',
            'city' => 'required',
            'address' => 'required',
        ]);
        $random8Digit = str_pad(random_int(0, 999999), 6, '0', STR_PAD_LEFT);
        $requestData = $request->all();
        $requestData['partnercode'] = $random8Digit;
        // return $requestData;
        $data = Partners::create($requestData);
        // return $data;
        Session::flash('flash_message', 'Partner Added Successfully!');
        return redirect('partners');
    }

    public function show($id)
    {
        //
    }

    public function edit($id)
    {
        $edit = Partners::findOrFail($id);
        return view('partners.edit', Compact('edit'));
    }

    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'name' => 'required',
            'email' => 'required',
            'contact' => 'required',
            'city' => 'required',
            'address' => 'required',
        ]);
        $update = Partners::findOrFail($id);
        $update->update($request->all());
        Session::flash('flash_message', 'Partner Updated Successfully!');
        return redirect('partners');
    }

    public function destroy($id)
    {
        $delete = Partners::findOrFail($id);
        $delete->delete();
        return "Partner Deleted Successfully!";
    }
}
