<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\PurchaseDetail;
use App\Models\SaleTax;
use App\Models\SaleTaxDetails;
use App\Models\Party;
use App\Models\Product;
use App\Models\User;
use App\Models\Setting;
use App\Models\Warehouse;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;

class DashboardController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    {
        //  return session()->get('company_id');

        if (session()->has('company_id')) {
              $companyID = session()->get('company_id');
            $company_detail = Setting::first();
            $party = Party::count();
            // $supplier = Supplier::count();
            $product = Product::count();
            $user = User::count();
            $purchases = DB::table('purchase_details')->Sum('total_cost');
            $sales = DB::table('sale_details')->Sum('sale_amount');
            $Gstsales = DB::table('sale_tax_details')->Sum('total');
            //$todaySale = DB::table('sale_details')->whereDate('created_at', DB::raw('CURDATE()'))->get();
            $todayPurchase = SaleTaxDetails::whereDate('created_at', DB::raw('CURDATE()'))->get();
            $totalPurchase = 0;
            foreach ($todayPurchase as $allpurchases) {
                $totalPurchase = $totalPurchase + $allpurchases->total_cost;
            }

              $todaySale = SaleTaxDetails::where('company_id', '=', $companyID)
              ->where('sale_type1', 'SalesTax Invoice')
              ->whereDate('created_at', DB::raw('CURDATE()'))->sum('total');
              $todayTax = SaleTaxDetails::where('company_id', '=', $companyID)
              ->where('sale_type1', 'SalesTax Invoice')
              ->whereDate('created_at', DB::raw('CURDATE()'))->sum('taxvalue');
              $todaySaleReturn = SaleTaxDetails::where('company_id', '=', $companyID)
              ->where('sale_type1', 'Credit Note')
              ->whereDate('created_at', DB::raw('CURDATE()'))->sum('total');
              $currentMonthSale = SaleTaxDetails::where('company_id', '=', $companyID)
              ->where('sale_type1', 'SalesTax Invoice')
              ->whereMonth('created_at', now()->month)
            ->whereYear('created_at', now()->year)
            ->sum('total');
            $currentMonthTax = SaleTaxDetails::where('company_id', '=', $companyID)
            ->where('sale_type1', 'SalesTax Invoice')
            ->whereMonth('created_at', now()->month)
                ->whereYear('created_at', now()->year)
                ->sum('taxvalue');

            $currentMonthSaleReturn = SaleTaxDetails::where('company_id', '=', $companyID)
            ->where('sale_type1', 'Credit Note')
            ->whereMonth('created_at', now()->month)
                ->whereYear('created_at', now()->year)
                ->sum('total');

            $shop = Warehouse::where('id', '=', Auth::User()->shop_id)->get();



             $saleinvoices = SaleTax::select([
                'sale_taxes.id',
                'sale_taxes.date',
                'sale_taxes.dcn_no',
                'sale_taxes.invoice_no',
                'parties.party_name',
                'parties.ntn',
                'users.name as biller_name',
                DB::raw('SUM(sale_tax_details.rate * sale_tax_details.quantity) as total_amount'),
                DB::raw('SUM(sale_tax_details.taxvalue) as total_tax'),
                DB::raw('SUM(sale_tax_details.total) as grand_total')
            ])
            ->join('sale_tax_details', 'sale_taxes.id', '=', 'sale_tax_details.sale_id')
            ->leftJoin('parties', 'sale_taxes.party_id', '=', 'parties.id')
            ->leftJoin('users', 'users.id', '=', 'sale_taxes.biller')
             // Keep eager loading if needed
            ->whereDate('sale_taxes.created_at', DB::raw('CURDATE()'))
            ->where('sale_taxes.company_id', $companyID)
            ->where('sale_taxes.invoice_no', '!=', '0')
            ->groupBy([
                'sale_taxes.id',
                'sale_taxes.date',
                'sale_taxes.dcn_no',
                'sale_taxes.invoice_no',
                'parties.party_name',
                'parties.ntn',
                
            ])
            
            ->orderByDesc('sale_taxes.id')
            ->get();

            $company_detail = "";
            $sales = "";
            $monthlyCashSale = "";
            $GSTSales = "";
            $monthlyCreditSale = "";
            $banks = "";
            $dailyCashSale = "";
            $dailyCreditSale = "";
            $dailyGSTSale = "";
            $dailyCashReceipt = "";
            $dailybankReceipt = "";
            $dailyPostDatedReceipt = "";
            $dailyCashPayment = "";
            $dailyBankPayment = "";

            return view('dashboard.index', compact(
                'todaySale',
                'todayTax',
                'todaySaleReturn',
                'currentMonthSale',
                'currentMonthTax',
                'currentMonthSaleReturn',
                'saleinvoices',
                'party',
                'product',
                'user',
                'purchases',
                'sales',
                'Gstsales',
                'todaySale',
             
                'totalPurchase',
                'monthlyCashSale',
                'GSTSales',
                'monthlyCreditSale',
                'banks',
                'dailyCashSale',
                'dailyCreditSale',
                'dailyGSTSale',
                'dailyCashReceipt',
                'dailybankReceipt',
                'dailyPostDatedReceipt',
                'dailyCashPayment',
                'dailyBankPayment',
                'company_detail',
                'shop'
            ));
        } else {
            return redirect('company');
        }
    }


    public function calender()
    {
        return view('calender.index');
    }

    public function create()
    {
        //
    }

    public function store(Request $request)
    {
        //
    }

    public function show($id)
    {
        //
    }

    public function edit($id)
    {
        //
    }

    public function update(Request $request, $id)
    {
        //
    }

    public function destroy($id)
    {
        //
    }
}
