<?php

namespace App\Http\Controllers;

use App\Models\SaleTypes;
use App\Models\Companies;
use App\Models\Setting;
use App\Models\Scenario;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Crypt;
use App\Models\Warehouse;
use App\Models\AccountGroup;
use App\Models\Role;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

class CompanyController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    { 

        //  $this->LogoutCompany();
        //   return Auth::User()->status;

        // session()->forget('company_id');
        //     session()->forget('company_name');
        //     return "ddd";
        // return Auth::User()->status;
        //  return redirect('/logout');
       
        if (Auth::User()->status == "company") {
            // return Auth::User()->name;
           return $this->AssignCompany(Auth::User()->company_id);
        }
        if (Auth::User()->status == "user") {
            return $this->AssignCompany(Auth::User()->company_id); 
        }

        // if (!session()->has('company_id')) {
            
        if (Auth::User()->status == "Admin") {
             //return "not session";
             $data = Companies::OrderBy('id', 'desc')->with(['user' => function($que){
                $que->where('status', 'company');
            }])->get();
            return view('companies.index', compact('data'));
        } 
        else {
            return redirect('/');
        }
    }

    public function AssignCompany($id)
    {
        //  return $id;
         $data = Companies::findOrFail($id);
        //  return $data->id;
        session()->put('company_id', $data->id);
        session()->put('company_name', $data->CompanyName);
        session()->put('company_address', $data->address);
        session()->put('company_phone', $data->phone);
        session()->put('company_status', $data->status);
        session()->put('company_ntn', $data->ntn);
        session()->put('company_strn', $data->strn);
        session()->put('company_ntn_show', $data->ntn_show);
        session()->put('company_strn_show', $data->strn_show);
        session()->put('company_type', $data->type);
        session()->put('company_bill_type', $data->bill_type);
        session()->put('company_pos_id', $data->pos_id);
        session()->put('company_token', $data->token);
        
        return redirect('dashboard');
    }

    public function create()
    {
            
         $shops = Warehouse::pluck('name', 'id')->toArray();
         $saletypes = SaleTypes::pluck('name', 'id')->toArray();
         $Scenario = Scenario::Orderby('name', 'asc')->pluck('name', 'name');
        // $location = AccountGroup::where('milk_supplier', '=', 1)->pluck('name', 'id')->prepend('Select Supplier Location', '')->toArray();
        return view('companies.create', compact('shops', 'saletypes', 'Scenario')); 
    }

    public function store(Request $request)
    {
        //  return $request;
        $this->validate($request, [
            'CompanyName' => 'required',
            'phone' => 'required',
            'address' => 'required',
            'name' => 'required',
            'email' => 'required|unique:users',
            'password' => 'required',
            'ntn' => 'required',
            'token' => 'required',
        ]);
        $company = new Companies();
        $company->CompanyName = $request->CompanyName;
        $company->phone = $request->phone;
        $company->address = $request->address;
        $company->province = $request->province;
        $company->status = $request->status;
        $company->ntn = $request->ntn;
        $company->strn = $request->strn;
        $company->type = $request->Businesstype;
        $company->bill_type = $request->bill_type;
        $company->ntn_show = $request->ntn_show;
        $company->strn_show = $request->strn_show;
        $company->sandbox_token = $request->sandbox_token;
        $company->token = $request->token;
        $company->footer_show = "Yes";
        $company->discount = $request->discount;
        $company->extra_tax = $request->extra_tax;
        $company->start_date = $request->start_date;
        $company->expire_date = $request->expire_date;
        $company->client_payment = $request->client_payment;
        $company->payment_terms = $request->payment_terms;
        $company->invoice_type = $request->invoice_type;
        $company->save();


        $users = new User();
        $users->name = $request->name;
        // $users->username = $request->username;
        $users->email = $request->email;
        $users->password = bcrypt($request->password);
        $users->show_password = $request->password;
        $users->company_id = $company->id;
        // $users->shop_id=1;
        // $users->biller_id = Auth::User()->id;
        $users->status = "company";
        $users->type = $request->type;
        $users->save();
        $users->roles()->attach(Role::where('name', 'Admin')->first());
        // $users->roles()->attach(Role::where('name', 'Editor')->first());
      
        if (isset($request->scenario)) {
            if (count($request->scenario) > 0) {
                $arr = array();
                foreach ($request->scenario as $size) {
                    $arr[] = array('scenario' => $size);
                }
                $company->scenario = json_encode($arr);
                $company->save();
            }
        }

        Session::flash('flash_message', 'Company Added Successfully!');
        return redirect('company');
    }

    public function show($id)
    {
        //
    }

    public function edit($id)
    {
        session()->put('comp_id', $id);
        // session()->put('company_pos_id');
        //return session()->get('comp_id');
        // return Auth::User()->id;
        // $edit = Companies::findOrFail($id);
         $edit = Companies::findOrFail($id);
         $user = User::where('company_id', $edit->id)
         ->where('status', 'company')->first();
        // $decrypt= decrypt($edit->password);
        // $decrypt= Crypt::decrypt($edit->password);
       
     
        // return $decrypt;
        // $pos=User::pluck('password');
        // return $pos;
        // $Scenario = Scenario::pluck('name', 'name')->prepend('Select Scenario', '');
        $shops = Warehouse::pluck('name', 'id')->toArray();
        $saletypes = SaleTypes::pluck('name', 'id')->toArray();
        $Scenario = Scenario::Orderby('name', 'asc')->pluck('name', 'name');
        return view('companies.edit', compact('edit', 'saletypes', 'user', 'Scenario'));
    }

    public function update(Request $request, $id)
    {
        //  return $request;
        $this->validate($request,[
            // 'name' => 'required',
            // 'email' => 'required|unique:users',
            // 'password' => 'required',
            // 'type' => 'required',
            // 'ntn' => 'required',
            // 'ntn' => 'required|unique:users,ntn,id',
            // 'strn' => 'required|unique:users,strn'.$id,
        ]);
        // $edit = Companies::findOrFail($id);
        // $edit->update($request->all());

        // Session::flash('flash_message', 'Company Updated Successfully!');
        // return redirect('company');
        // $this->validate($request, [
        //     'name' => 'required',
        //     'email' => 'required'
        // ]);

        $update = Companies::findOrFail($id);
        // $update->update($request->session()->put('company_pos_id'));
        $update->update($request->all());
        // return $update;
        // $update->password = bcrypt($request->get('password'));
        // $update->password = $request->get('password');
        $update->save();

        if (isset($request->scenario)) {
            if (count($request->scenario) > 0) {
                $arr = array();
                foreach ($request->scenario as $size) {
                    $arr[] = array('scenario' => $size);
                }
                $update->scenario = json_encode($arr);
                $update->save();
            }
        }
        Session::flash('flash_message', 'Company Updated Successfully!');
        
        return redirect('company');
    }

    public function destroy($id)
    {
        User::where('company_id', $id)->delete();
        //    return $del;
        $delete = Companies::findOrFail($id);
        // return $delete;
        $delete->delete();
        Session::flash('flash_message', 'Company Deleted Successfully!');
        return redirect()->back();
    }



    public function LogoutCompany()
    {

        if (session()->has('company_id')) {
            session()->forget('company_id');
            session()->forget('company_name');
            Session::flash('flash_message', 'Company Successfully Logout!');
            return redirect('company');
        } else {
            return response("Insufficient Permissions. Go Back!", 401);
        }
    }
}