<?php $__env->startSection('head'); ?>
    <link href="<?php echo e(asset('css/plugins/datatables/jquery.dataTables.css')); ?>" rel="stylesheet">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('contents'); ?>
    <div class="container-fluid">
        <?php if(Session::has('flash_message')): ?>
            <button type="button" class="close" data-dismiss="alert" aria-hidden="true"
                style="margin-right: 20px;margin-top: 15px;">&times;</button>
            <div class="alert alert-success"> <?php echo e(Session::get('flash_message')); ?> </div>
        <?php endif; ?>
    </div>
    <div class="page-heading clearfix">
        <h1 class="page-title pull-left">Sales Tax</h1><a href="<?php echo e(asset('salestax/create')); ?>"
            class="btn btn-primary btn-sm btn-add" role="button">Add Sale Tax Invoice</a>
    </div>
    <ol class="breadcrumb breadcrumb-2">
        <li><a href="<?php echo e(asset('dashboard')); ?>"><i class="fa fa-home"></i>Home</a></li>
        <!-- <li><a href="/sales">Sales</a></li>  -->
        <li class="active"><strong>Sales Tax</strong></li>
    </ol>
    <div class="row">
        <div class="col-lg-12">
            <div class="panel panel-default">
                <div class="panel-heading clearfix">
                    <h3 class="panel-title">Manage Sales Tax</h3>
                </div>
                <div class="panel-body">
                    <div class="table-responsive">
                        <table class="table table-striped table-bordered table-hover dataTables-example">
                            <thead>
                                <tr>
                                    <th>Sr#</th>
                                    <th>Date</th>
                                    <th>DC#</th>
                                    <th>Inv#</th>
                                    <th>Exc.Val</th>
                                    <th>Tax&nbsp;Val</th>
                                    <!-- <th>Ex.Tax&nbsp;Value</th> -->
                                    <th>Inc.Val</th>
                                    <th>Party</th>
                                    <th>Party&nbsp;NTN</th>
                                    <th>Print</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $sum = 0; ?>
                                <?php $__currentLoopData = $sales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sale): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($sale->invoice_no != '0'): ?>
                                        <?php $sum = $sum + 1; ?>
                                        <tr>
                                            <td class="center"><?php echo e($sum); ?></td>
                                            <td class="center"><?php echo e(date('d/m/Y', strtotime($sale->date))); ?></td>
                                            <td class="center"><?php echo e($sale->dcn_no); ?></td>
                                            <td class="center"><?php echo e($sale->invoice_no); ?></td>
                                            <?php $total = 0;
                                            $discount = 0;
                                            $tax = 0;
                                            $extratax = 0;
                                            $grandtotal = 0; ?>
                                            <?php $__currentLoopData = $sale->saletax_details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $details): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php
                                                $total = $total + (int) $details->rate * (int) $details->quantity;
                                                $tax = $tax + (int) $details->taxvalue;
                                                $extratax = $extratax + (int) $details->extraTaxValue;
                                                $grandtotal = $grandtotal + (int) $details->total;
                                                ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <td class="center"><?php echo e((int) $total); ?></td>
                                            <td class="center"><?php echo e((int) $tax); ?></td>
                                            <!-- <td class="center"><?php echo e((int) $extratax); ?></td> -->
                                            <td class="center"><?php echo e((int) $grandtotal); ?></td>
                                            <td class="center"><?php if($sale->parties != null): ?><?php echo e($sale->parties->party_name); ?><?php endif; ?></td>
                                            <td class="center"><?php if($sale->parties != null): ?><?php echo e($sale->parties->ntn); ?><?php endif; ?></td>
                                            <td>
                                                <a href="<?php echo e(asset('salestax/dcn')); ?>/<?php echo e($sale->id); ?>"
                                                    target="__blank" style="color:white;">
                                                    <button class="btn btn-primary" type="button">DC</button></a>
                                                <a href="<?php echo e(asset('salestax')); ?>/<?php echo e($sale->id); ?>"
                                                    target="__blank" style="color:white;">
                                                    <button class="btn btn-info" type="button"> <i class="icon-print"
                                                            title="Print Invoice"></i></button></a>
                                            </td>
                                            <td class="size-100 text-center">
                                                <div class="row">
                                                    <a href="<?php echo e(asset('salestax')); ?>/<?php echo e($sale->id); ?>/edit"
                                                        target="__blank" style="color:white;">
                                                        <button class="btn btn-black" type="button"> <i
                                                                class="fa fa-paste"
                                                                title="Edit Invoice"></i></button></a>
                                                    <a
                                                        href="javascript:checkDelete(<?php echo e($sale->id); ?>, '<?php echo e(asset('/salestax')); ?>/<?php echo e($sale->id); ?>/destroy', '<?php echo e(asset('/salestax')); ?>');">
                                                        <button class="btn btn-red" type="button"> <i
                                                                class="icon-trash"
                                                                title="Delete Invoice"></i></button></a>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th>Sr#</th>
                                    <th>Date</th>
                                    <th>DC#</th>
                                    <th>Invoice No</th>
                                    <th>Tax&nbsp;Value</th>
                                    <th>Total</th>
                                    <th>Grand Total</th>
                                    <th>Party</th>
                                    <th>Party&nbsp;NTN</th>
                                    <th>Print</th>
                                    <th>Actions</th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script src="<?php echo e(asset('/js/jquery.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/js/plugins/datatables/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/js/plugins/datatables/dataTables.bootstrap.min.js')); ?>"></script>
    <script>
        $(document).ready(function() {
            $('.dataTables-example').DataTable({
                dom: '<"html5buttons" B>lTfgitp',
                buttons: [{
                        extend: 'copyHtml5',
                        exportOptions: {
                            columns: [0, ':visible']
                        }
                    },
                    {
                        extend: 'excelHtml5',
                        exportOptions: {
                            columns: ':visible'
                        }
                    },
                    {
                        extend: 'pdfHtml5',
                        exportOptions: {
                            columns: [0, 1, 2, 3, 4]
                        }
                    },
                    'colvis'
                ]
            });
        });
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make("app", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /homec/itlifeen/fbrinvoice.itlifee.net/root/resources/views/salestax/index.blade.php ENDPATH**/ ?>