
<?php echo Form::hidden('biller_id', Auth::User()->id, ['id' => 'biller_id', 'class' => 'form-control']); ?>

<!-- Company Information Section -->
<div class="row">
    <div class="col-md-6">
        <div class="form-group row">
            <?php echo Form::label('name', 'Company Name', ['class' => 'col-md-4 col-form-label']); ?>

            <div class="col-md-8">
                <?php echo Form::text('CompanyName', null, ['id' => 'CompanyName', 'class' => 'form-control', 'autofocus' => 'autofocus']); ?>

            </div>
        </div>
    </div>
    
    <div class="col-md-6">
        <div class="form-group row">
            <?php echo Form::label('phone', 'Phone', ['class' => 'col-md-4 col-form-label']); ?>

            <div class="col-md-8">
                <?php echo Form::text('phone', null, ['id' => 'phone', 'class' => 'form-control']); ?>

            </div>
        </div>
    </div>
</div>

<!-- Address Section -->
<div class="row mt-3">
    <div class="col-md-6">
        <div class="form-group row">
            <?php echo Form::label('address', 'Address', ['class' => 'col-md-4 col-form-label']); ?>

            <div class="col-md-8">
                <?php echo Form::text('address', null, ['id' => 'address', 'class' => 'form-control']); ?>

            </div>
        </div>
    </div>
    
    <div class="col-md-6">
        <div class="form-group row">
            <?php echo Form::label('Province', 'Province', ['class' => 'col-md-4 col-form-label']); ?>

            <div class="col-md-8">
                <?php echo Form::select('province', [
                    'Punjab' => 'Punjab', 
                    'Sindh' => 'Sindh', 
                    'Balochistan' => 'Balochistan', 
                    'Khyber Pakhtunkhwa' => 'Khyber Pakhtunkhwa'
                ], null, ['id' => 'province', 'class' => 'form-control']); ?>

            </div>
        </div>
    </div>
</div>

<!-- Business Type Section -->
<div class="row mt-3">
    <div class="col-md-6">
        <div class="form-group row">
            <?php echo Form::label('type', 'Business Type', ['class' => 'col-md-4 col-form-label']); ?>

            <div class="col-md-8">
                <?php echo Form::select('Businesstype', [
                    'Invoice Only' => 'Invoice Only', 
                    'Inventory' => 'Inventory', 
                    'Trader' => 'Trader', 
                    'Manufacturer' => 'Manufacturer'
                ], null, ['id' => 'Businesstype', 'class' => 'form-control']); ?>

            </div>
        </div>
    </div>
    
    <div class="col-md-6">
        <div class="form-group row">
            <?php echo Form::label('bill_type', 'Bill Type', ['class' => 'col-md-4 col-form-label']); ?>

            <div class="col-md-8">
                <?php echo Form::select('bill_type', [
                    'A4' => 'A4', 
                    'Thermal' => 'Thermal'
                ], null, ['id' => 'bill_type', 'class' => 'form-control']); ?>

            </div>
        </div>
    </div>
</div>

<!-- Tax Information Section -->
<div class="row mt-3">
    <div class="col-md-6">
        <div class="form-group row">
            <?php echo Form::label('Ntn', 'NTN - CNIC', ['class' => 'col-md-4 col-form-label']); ?>

            <div class="col-md-8">
            <small class="text-danger d-block mb-1">PVT LTD NTN (9937038) - CNIC for AOP Individual (3520133847501)</small>
                <?php echo Form::text('ntn', null, ['id' => 'ntn', 'class' => 'form-control']); ?>

            </div>
        </div>
    </div>
    
    <div class="col-md-6">
        <div class="form-group row">
            <?php echo Form::label('ntn_show', 'Show Customer NTN', ['class' => 'col-md-4 col-form-label']); ?>

            <div class="col-md-8">
                <?php echo Form::select('ntn_show', [1 => 'Yes', 0 => 'No'], null, ['id' => 'ntn_show', 'class' => 'form-control']); ?>

            </div>
        </div>
    </div>
</div>

<div class="row mt-3">
    <div class="col-md-6">
        <div class="form-group row">
            <?php echo Form::label('Strn', 'STRN', ['class' => 'col-md-4 col-form-label']); ?>

            <div class="col-md-8">
                <?php echo Form::text('strn', null, ['id' => 'strn', 'class' => 'form-control']); ?>

            </div>
        </div>
    </div>
    
    <div class="col-md-6">
        <div class="form-group row">
            <?php echo Form::label('strn_show', 'Show Customer STRN', ['class' => 'col-md-4 col-form-label']); ?>

            <div class="col-md-8">
                <?php echo Form::select('strn_show', [1 => 'Yes', 0 => 'No'], null, ['id' => 'strn_show', 'class' => 'form-control']); ?>

            </div>
        </div>
    </div>
</div>

<!-- Dates Section -->
<div class="row mt-3">
    <div class="col-md-6">
        <div class="form-group row">
            <?php echo Form::label('start_date', 'Start Date', ['class' => 'col-md-4 col-form-label']); ?>

            <div class="col-md-8">
                <?php echo Form::date('start_date', date('Y-m-d'), ['id' => 'start_date', 'class' => 'form-control']); ?>

            </div>
        </div>
    </div>
    
    <div class="col-md-6">
        <div class="form-group row">
            <?php echo Form::label('expire_date', 'Expiry Date', ['class' => 'col-md-4 col-form-label']); ?>

            <div class="col-md-8">
                <?php echo Form::date('expire_date', date('Y-m-d', strtotime("+1 year")), ['id' => 'expire_date', 'class' => 'form-control']); ?>

            </div>
        </div>
    </div>
</div>

<hr class="my-4">

<!-- Payment Tokens Section -->
<div class="row">
    <div class="col-md-6">
        <div class="form-group row">
            <?php echo Form::label('sandbox_token', 'SandBox Token', ['class' => 'col-md-4 col-form-label']); ?>

            <div class="col-md-8">
                <small class="text-danger d-block mb-1">Please Enter the exact SandBox Token</small>
                <?php echo Form::text('sandbox_token', null, ['id' => 'sandbox_token', 'class' => 'form-control']); ?>

            </div>
        </div>
    </div>
    
    <div class="col-md-6">
        <div class="form-group row">
            <?php echo Form::label('token', 'Live TOKEN', ['class' => 'col-md-4 col-form-label']); ?>

            <div class="col-md-8">
                <small class="text-danger d-block mb-1">Please Enter the exact TOKEN to avoid Errors</small>
                <?php echo Form::text('token', null, ['id' => 'token', 'class' => 'form-control']); ?>

            </div>
        </div>
    </div>
</div>

<!-- Invoice Settings Section -->
<div class="row mt-3">
    <div class="col-md-6">
        <div class="form-group row">
            <?php echo Form::label('invoice_type', 'Invoice Type', ['class' => 'col-md-4 col-form-label']); ?>

            <div class="col-md-8">
                <?php echo Form::select('invoice_type', [
                    'SandBox' => 'SandBox', 
                    'Live' => 'Live'
                ], null, ['id' => 'invoice_type', 'class' => 'form-control']); ?>

            </div>
        </div>
    </div>
    
    <div class="col-md-6">
        <div class="form-group row">
            <?php echo Form::label('sale_type', 'Sale Type', ['class' => 'col-md-4 col-form-label']); ?>

            <div class="col-md-8">
                <?php echo Form::select('sale_type', $saletypes, null, ['id' => 'sale_type', 'class' => 'form-control']); ?>

            </div>
        </div>
    </div>
</div>

<div class="row mt-3">
    <div class="col-md-6">
        <div class="form-group row">
            <?php echo Form::label('Scenario', 'Scenario', ['class' => 'col-md-4 col-form-label']); ?>

            <div class="col-md-8">
                <!-- <?php echo Form::select('scenario', $Scenario, null, ['id' => 'scenario', 'class' => 'form-control']); ?> -->
                <?php echo Form::select('scenario[]', $Scenario, null, [
                    'id' => 'langOpt3',
                    'class' => 'form-control',
                    'multiple' => 'multiple',
                    'style' => 'width: auto; display: inline-block;'
                ]); ?>

               
            </div>
        </div>
    </div>
</div>

<!-- User Information Section -->
<div class="row mt-3">
    <div class="col-md-6">
        <div class="form-group row">
            <?php echo Form::label('name', 'Name', ['class' => 'col-md-4 col-form-label']); ?>

            <div class="col-md-8">
                <?php echo Form::text('name', null, ['id' => 'name', 'class' => 'form-control']); ?>

            </div>
        </div>
    </div>
    
    <div class="col-md-6">
        <div class="form-group row">
            <?php echo Form::label('email', 'Email', ['class' => 'col-md-4 col-form-label']); ?>

            <div class="col-md-8">
                <?php echo Form::text('email', null, ['id' => 'email', 'class' => 'form-control']); ?>

            </div>
        </div>
    </div>
</div>

<div class="row mt-3">
    <div class="col-md-6">
        <div class="form-group row">
            <?php echo Form::label('password', 'Password', ['class' => 'col-md-4 col-form-label']); ?>

            <div class="col-md-8">
                <input type="password" id="password" class="form-control" name="password">
            </div>
        </div>
    </div>
    
    <div class="col-md-6">
        <div class="form-group row">
            <?php echo Form::label('type', 'Account Status', ['class' => 'col-md-4 col-form-label']); ?>

            <div class="col-md-8">
                <?php echo Form::select('type', [
                    'ACTIVE' => 'ACTIVE', 
                    'INACTIVE' => 'INACTIVE'
                ], null, ['id' => 'type', 'class' => 'form-control']); ?>

            </div>
        </div>
    </div>
</div>

<!-- Submit Button -->
<div class="row mt-4">
    <div class="col-md-12 text-center">
        <?php echo Form::submit($submitbutton, ['class' => 'btn btn-primary px-4']); ?>

    </div>
</div>

<script src="<?php echo e(URL::asset('css/multi-select/jquery.multiselect.js')); ?>"></script>
    <script src="<?php echo e(asset('js/plugins/select2/select2.full.min.js')); ?>"></script>
    <script type="text/javascript">

       
    </script><?php /**PATH /homec/itlifeen/fbrinvoice.itlifee.net/root/resources/views/companies/_form.blade.php ENDPATH**/ ?>