<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>All Parties</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --primary-color: #2c3e50;
            --secondary-color: #3498db;
            --border-color: #e0e0e0;
            --text-color: #333;
            --light-bg: #f9f9f9;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            line-height: 1.4;
            color: var(--text-color);
            margin: 0;
            padding: 0;
            background-color: #f5f5f5;
        }
        
        .page-container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 20px;
        }
        
        .card {
            background: white;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
            overflow: hidden;
            margin-bottom: 20px;
        }
        
        .card-body {
            padding: 20px;
        }
        
        h2 {
            color: var(--primary-color);
            text-align: center;
            margin: 15px 0;
            padding-bottom: 8px;
            border-bottom: 2px solid var(--secondary-color);
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            margin: 15px 0;
            font-size: 0.9em;
        }
        
        th, td {
            padding: 8px 12px;
            text-align: left;
            border-bottom: 1px solid var(--border-color);
        }
        
        th {
            background-color: var(--primary-color);
            color: white;
            font-weight: 600;
            text-transform: uppercase;
            font-size: 0.8em;
            padding: 10px 12px;
        }
        
        tr:nth-child(even) {
            background-color: var(--light-bg);
        }
        
        tr:hover {
            background-color: rgba(0,0,0,0.02);
        }
        
        .header {
            margin-bottom: 20px;
        }
        
        @media (max-width: 768px) {
            table {
                display: block;
                overflow-x: auto;
            }
            
            th, td {
                padding: 6px 8px;
            }
        }
    </style>
</head>
<body>
    <div class="page-container">
        <div class="header">
            <?php echo $__env->make('include.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
        
        <div class="card">
            <div class="card-body">
                <h2>All Parties</h2>
                
                <table>
                    <thead>
                        <tr>
                            <th>Sr.#</th>
                            <th>Code</th>
                            <th>Client Name</th>
                            <th>Phone</th>
                            <th>NTN</th>
                            <th>Address</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $party; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $parties): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($index + 1); ?></td>
                                <td><?php echo e($parties->code); ?></td>
                                <td><?php echo e($parties->party_name); ?></td>
                                <td><?php echo e($parties->phone); ?></td>
                                <td><?php echo e($parties->ntn); ?></td>
                                <td><?php echo e($parties->address); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
        
        <?php if($company_detail[0]->white_label == 0): ?>
            <?php echo $__env->make('include.powerdby2', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>
    </div>
</body>
</html><?php /**PATH /homec/itlifeen/fbrinvoice.itlifee.net/root/resources/views/parties/print.blade.php ENDPATH**/ ?>