@extends("app")

<head>
    <link href="{{ asset('css/select2.min.css') }}" rel="stylesheet" />
    <meta name="csrf-token" content="{{ csrf_token() }}" />
</head>
@section('contents')

<body>
    <div class="container-fluid">
        @if (Session::has('flash_message'))
        <div class="alert alert-success alert-dismissible fade in">
            <a href="#" class="close" data-dismiss="alert" aria-label="close" style="margin-right: 4%;">&times;</a>
            <strong>Success!</strong> {{ Session::get('flash_message') }}
        </div>
        @endif
    </div>
    <div class="row">
        <div class="col-lg-12">
            <div class="panel panel-default">
                <div class="panel-heading clearfix" id="panelbg">
                    <h3 class="panel-title">Add Opening Stock</h3>
                </div>
                <div class="panel-body">
                    <input id="token" type="hidden" value="{{ $encrypted_token }}">
                    @include('errors.validation')
                    {!! Form::open(['url' => 'opening-stock', 'class' => 'form-horizontal', 'id' => 'StockForm']) !!}
                    {!! Form::hidden('company_id', session()->get('company_id'), ['id' => 'company_id']) !!}
                    <div class="row">
                        <div class="form-group" style="margin-left: 1%; margin-right: 1%;">
                            <label class="col-sm-1 control-label">Date</label>
                            <div class="col-sm-2">
                                <div id="year-view" class="input-group date">
                                    <input id="date" type="date" name="date" value="<?php echo date('Y-m-d'); ?>"
                                        class="form-control" autofocus>
                                    <!-- <span class="input-group-addon"><i class="fa fa-calendar"></i></span>  -->
                                </div>
                            </div>
                            <label class="col-sm-1 control-label">Bill No</label>
                            <div class="col-sm-2">
                                <div id="year-view" class="input-group date">
                                    {!! Form::text('bill_no', $codes, ['id' => 'bill_no', 'class' => 'form-control',
                                    'disabled' => 'disabled']) !!}
                                    {!! Form::hidden('bill_no', $codes, ['id' => 'bill_no', 'class' => 'form-control'])
                                    !!}
                                </div>
                            </div>
                            <label class="col-sm-1 control-label" style="display:none;">Stock&nbsp;Type</label>
                            <div class="col-sm-2" style="display:none;">
                                <select class="form-control" id="purchase_type" name="purchase_type">
                                    <option value="ADJUST">ADJUST</option>
                                    {{-- <option value="WASTE">WASTE</option> --}}
                                    <!-- <option value="Sales Tax">Sales Tax</option>
            <option value="LC">L.C</option> -->
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row" id="ledgerRow" style="display:none;">
                        <div class="form-group" style="margin-left: 1%; margin-right: 1%;">
                            <label class="col-sm-1 control-label">Due&nbsp;Date</label>
                            <div class="col-sm-2">
                                <div id="year-view" class="input-group date">
                                    <!-- <input id="due_date" type="date" name="due_date" class="form-control">  -->
                                    <input id="due_date" type="date" value="<?php echo date('Y-m-d'); ?>"
                                        name="due_date" class="form-control">
                                    <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                </div>
                            </div>
                            <label class="col-sm-1 control-label"></label>
                            <div class="col-sm-2">
                                {!! Form::text('particulars', null, ['id' => 'particulars', 'placeholder' =>
                                'Description', 'class' => 'form-control']) !!}
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="form-group" style="margin-left: 1%; margin-right: 1%;">
                            <label class="col-sm-1 control-label" style="display:none;">Warehouse</label>
                            <div class="col-sm-2" style="display:none;">
                                <!-- {!! Form::select('grn_no', $grns, null, ['id' => 'grn_no', 'onchange' => 'GRNMouseUp($(this).val());', 'class' => 'form-control livesearch']) !!} -->
                                {!! Form::select('warehouse_id', $warehouse, null, ['id' => 'warehouse_id', 'class' =>
                                'form-control']) !!}
                            </div>
                        </div>
                    </div>
                    <!-- <div class="form-group"> 
            <label class="col-sm-3 control-label">Bill No</label>  
            <div class="col-sm-5"> 
            {!! Form::text('bill_no', null, ['id' => 'bill_no', 'class' => 'form-control']) !!}
            </div> 
            </div> -->
                    <div class="row" style="display: none;">
                        <div class="form-group" style="margin-left: 1%; margin-right: 1%;">
                            <label class="col-sm-1 control-label">Account ID</label>
                            <div class="col-sm-5" style="height: 40px;">
                                {!! Form::text('account_id', 0, ['id' => 'account_id', 'class' => 'form-control']) !!}

                            </div>
                        </div>
                    </div>
                    <!-- <div class="row">
            <div class="form-group" style="margin-left: 1%; margin-right: 1%;"> 
            <label class="col-sm-1 control-label">Account</label>  
            <div class="col-sm-5" style="height: 40px;"> 
            {!! Form::select('suppliers_id', $Account, null, ['id' => 'suppliers_id', 'onchange' => 'GetSupplierID($(this).val());', 'class' => 'form-control']) !!}

            </div> 
            </div>
            </div> -->
                    <div class="row">
                        <div class="col-lg-12">

                            <div class="panel panel-default">
                                <div class="panel-body">
                                    <div class="form-group">
                                        <table id="myTable">
                                            <div class="container-fluid">
                                                <div class="row">
                                                    <tr>

                                                        <!-- <div class="col-md-3"> 
        <div class="form-group"> 
        <label for="H.S" class="control-label">Id</label> -->
                                                        {!! Form::hidden('product_id', null, ['id' => 'product_id',
                                                        'class' => 'form-control']) !!}
                                                        <!-- </div>
    </div>  -->
                                                        <div class="col-md-1"
                                                            style="margin-left: 1%; margin-right: 1%;">
                                                            <div class="form-group">
                                                                <label for="H.S" class="control-label">Code</label>
                                                                {!! Form::text('product_code', null, ['id' =>
                                                                'product_code', 'onkeyup' =>
                                                                'CodeKeyUp($(this).val());', 'class' => 'form-control', 'disabled'=>'disabled']) !!}
                                                            </div>
                                                        </div>
                                                        <div class="col-md-3"
                                                            style="margin-left: 1%; margin-right: 1%;">
                                                            <div class="form-group">
                                                                <label for="Name" class="control-label">Product
                                                                    Name</label>
                                                                {!! Form::select('product_name', $products, null, ['id'
                                                                => 'product_name', 'onchange' =>
                                                                'productMouseUp($(this).val().split("_")[0]);', 'class'
                                                                => 'form-control']) !!}
                                                            </div>
                                                        </div>
                                                        <div class="col-md-2" style="display:none;">
                                                            <div class="form-group">
                                                                <label for="Name" class="control-label">Tax
                                                                    Rate</label>
                                                                {!! Form::select('tax_id', $taxes, null, ['id' =>
                                                                'tax_id', 'onchange' =>
                                                                'javascript:CalculateTax($(this).val().split("_").pop(),
                                                                $(this).closest(\'tr\').index())', 'class' =>
                                                                'form-control']) !!}
                                                            </div>
                                                        </div>
                                                        <div class="col-md-1"
                                                            style="margin-left: 1%; margin-right: 1%; display:none;">
                                                            <div class="form-group">
                                                                <label for="Name" class="control-label">Unit</label>
                                                                {!! Form::select('uom_id', $uoms, null, ['id' =>
                                                                'uom_id', 'class' => 'form-control']) !!}
                                                            </div>
                                                        </div>
                                                        <div class="col-md-1"
                                                            style="margin-left: 1%; margin-right: 1%;">
                                                            <div class="form-group">
                                                                <label for="Name" class="control-label">Unit</label>
                                                                {!! Form::text('uoms', null, ['id' =>
                                                                'uoms', 'class' => 'form-control', 'disabled'=>'disabled']) !!}
                                                            </div>
                                                        </div>
                                                        <div class="col-md-1"
                                                            style="margin-left: 1%; margin-right: 1%;">
                                                            <div class="form-group">
                                                                <label for="password"
                                                                    class="control-label">Quantity</label>
                                                                {!! Form::text('quantity', null, ['id' => 'quantity',
                                                                'onkeyup' => 'QuantityKeyUp($(this).val())', 'class' =>
                                                                'form-control', 'onkeypress' => 'return onlyNumberKey(event)',
                                                                 'onfocus'=>'this.value=""']) !!}
                                                            </div>
                                                        </div>
                                                        <div class="col-md-2"
                                                            style="margin-left: 1%; margin-right: 1%;">
                                                            <div class="form-group">
                                                                <label for="password"
                                                                    class="control-label">Rate</label>
                                                                {!! Form::text('price', null, ['id' => 'price',
                                                                'onkeyup' => 'PriceKeyUp($(this).val())', 'class' =>
                                                                'form-control', 'onkeypress' => 'return onlyNumberKey(event)']) !!}
                                                            </div>
                                                        </div>
                                                        <!-- <div class="col-md-2" style="margin-left: 1%; margin-right: 1%;"> 
        <div class="form-group"> 
        <label for="Expiry Date" class="control-label">Expiry</label> 
        <input id="expiry" type="date" name="expiry" value="<?php echo date('Y-m-d'); ?>" class="form-control"> 
        </div> 
    </div> -->
                                                        <div class="col-md-1"
                                                            style="margin-left: 1%; margin-right: 1%; display:none;">
                                                            <div class="form-group">
                                                                <label for="Warehouse"
                                                                    class="control-label">Warehouse</label>
                                                                {!! Form::select('warehouse_id', $warehouse, null, ['id'
                                                                => 'warehouse_id', 'class' => 'form-control
                                                                livesearch']) !!}
                                                            </div>
                                                        </div>
                                                        <div class="col-md-2">
                                                            <div class="form-group">
                                                                <label for="password"
                                                                    class="control-label">Total</label>
                                                                {!! Form::hidden('total', null, ['id' => 'total', 'class' =>
                                                                'form-control']) !!}
                                                                {!! Form::text('totals', null, ['id' => 'totals', 'class' =>
                                                                'form-control', 'disabled'=>'disabled']) !!}
                                                            </div>
                                                        </div>&nbsp;
                                                        <button class="btn btn-success" type="button" onkeyup="AddGridData();" onclick="AddGridData();"
                                                        style="margin-top:2%;">+</button>
                                                    </tr>
                                                    <div id="myData">
                                                    </div>
                                                </div>
                                            </div>
                                        </table><br /><br />
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-12">
                                    <div class="panel panel-default">
                                        <div class="panel-heading clearfix" id="panelbg">
                                            <div class="container">
                                                <div class="col-xs-5"> </div>
                                                <!-- <div class="col-xs-3">  </div> -->
                                                <div class="col-xs-3"> <b>Total Qty</b> <input type="text" value="0"
                                                        id="TotalRate" name="TotalRate" disabled> </div>
                                                <div class="col-xs-4"> <b>Total Amount</b> <input type="text" value="0"
                                                        id="TotalAmount" name="TotalAmount" disabled> </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <center>
                        <div class="form-actions">
                            <button type="button" onclick="submitForm();" class="btn btn-primary">Save</button>
                        </div>
                    </center>
                    {!! Form::close() !!}
                </div>
            </div>
        </div>
    </div>
</body>
@stop
@section('scripts')
<!-- Select2-->
<script src="{{ asset('js/plugins/select2/select2.full.min.js') }}"></script>
<script type="text/javascript">
$("#purchase_type").select2();
$("#purchase_type").next(".select2").find(".select2-selection").focus(function() {
    $("#purchase_type").select2("open");
});
$("#warehouse_id").select2();
$("#warehouse_id").next(".select2").find(".select2-selection").focus(function() {
    $("#warehouse_id").select2("open");
});
$("#suppliers_id").select2();
$("#suppliers_id").next(".select2").find(".select2-selection").focus(function() {
    $("#suppliers_id").select2("open");
});
$("#product_name").select2();
$("#product_name").next(".select2").find(".select2-selection").focus(function() {
    $("#product_name").select2("open");
});
// $("#uom_id").select2();
// $("#uom_id").next(".select2").find(".select2-selection").focus(function() {
//     $("#uom_id").select2("open");
// });
$('#product_name').change(function() {
            $('#product_name').select2().trigger('select2:close');
            $("#quantity").focus();
        });
var sum = 0;

function GetSupplierID(value) {
    document.getElementById('account_id').value = value;
}

function QuantityKeyUp(quantity) {
    var price = document.getElementById('price').value;
    var tax = document.getElementById('tax_id').value.split("_").pop();
    var taxvalue = tax / 100 * price * quantity;
    total = (quantity * price) + taxvalue;
    document.getElementById('total').value = total;
}

function PriceKeyUp(price) {
    var quantity = document.getElementById('quantity').value;
    var tax = document.getElementById('tax_id').value.split("_").pop();
    var taxvalue = tax / 100 * price * quantity;
    total = (quantity * price) + taxvalue;
    document.getElementById('total').value = total;
    document.getElementById('totals').value = total;
}

function TotalRecords() {
    var rowCount = document.getElementById('myTable').rows.length;
    alert("Total Number of Records Are: " + rowCount);
}

function AddGridData() {
    
    var ProductId = document.getElementById('product_id').value;
    var ProductCode = document.getElementById('product_code').value;
    var ProductName = document.getElementById('product_name').value.split("_").pop();
    //var Tax = document.getElementById('tax_id').value.split("_").pop();
    // var TaxID = document.getElementById('tax_id').value.split("_")[0];
    //var UOM = document.getElementById('uom').value;
    var UOMID = document.getElementById('uom_id').value.split("_")[0];
    var UOM = document.getElementById('uom_id').value.split("_").pop();
    var uoms = document.getElementById('uoms').value;
    var Quantity = document.getElementById('quantity').value;
    var Price = document.getElementById('price').value;
    // var expiry = document.getElementById('expiry').value;
    var warehouse_id = document.getElementById('warehouse_id').value;
    var Total = document.getElementById('total').value;

    if((ProductId) == "" || (ProductId) == 0){
                Swal.fire('Select Product First!');
                document.getElementById("product_code").focus();
                    e.preventdefault();
            }

    if((Quantity) == "" || (Quantity) == 0 || (Quantity) == 'NaN' ){
                document.getElementById("quantity").focus();
                Swal.fire('Quantity Cant be Empty or 0!');
                    // e.preventdefault();
                    return false;
            }

            if((Price) == "" || (Price) == 0 || (Price) == 'NaN' ){
                document.getElementById("price").focus();
                // alert('Price Cant be Empty or 0!');
                Swal.fire('Price Cant be Empty or 0!');
                    e.preventdefault();
            }
    // document.getElementById('TotalRate').value = Price;
    // document.getElementById('TotalAmount').value = Total;
    var rate = document.getElementById('TotalRate').value;
    var amount = document.getElementById('TotalAmount').value;
    var totalrate = parseInt(rate) + parseFloat(Quantity);
    var totalamount = parseInt(amount) + parseInt(Total);
    document.getElementById('TotalRate').value = totalrate;
    document.getElementById('TotalAmount').value = totalamount;
    // alert(Price)
    // alert(Total)


    var tableHtml = '<tr>';
    // tableHtml += '<td class="text-center"><i onclick="javascript:myDeleteFunction($(this).closest(\'tr\'));" class="icon-cancel icon-larger red-color" title="Delete Row"></i> </td>';
    //tableHtml += '<td>'+ ProductId +'</td>';
    tableHtml +=
        `<td style="display:none;"><input id="products_id" name="products_id[]" value="${ProductId}" type="text" class="form-control"></td>`;
    //tableHtml += '<td>'+ ProductCode +'</td>';
    tableHtml +=
        `<td style="padding-top:20px;"><input id="products_code" name="products_code[]" value="${ProductCode}" type="text" class="form-control" style="margin-left: 7%; width: 52%;" disabled></td>`;
    //tableHtml += '<td>'+ ProductName +'</td>';
    tableHtml +=
        `<td style="padding-top:20px;"><input id="product_name" name="product_name[]" value="${ProductName}" type="text" class="form-control" style="margin-left:-29%; width: 163%;" disabled></td>`;
    //tableHtml += '<td>'+ UOMID +'</td>';
    tableHtml +=
        `<td style="display:none;"><input id="uoms_id" name="uoms_id[]" value="${UOMID}" type="text" class="form-control"></td>`;
    //tableHtml += '<td>'+ UOM +'</td>';
    tableHtml +=
        `<td style="padding-top:20px;"><input id="uoms" name="uoms" value="${uoms}" type="text" class="form-control" style="margin-left:47%; width: 54%;" disabled></td>`;
    //tableHtml += '<td>'+ Quantity +'</td>';
    tableHtml +=
        `<td style="padding-top:20px;"><input id="quantity" name="quantity[]" value="${Quantity}" type="text" class="form-control" onkeypress = "return onlyNumberKey(event)",  onkeyup="QtyChange($(this).val(), $(this).closest('tr').index());" style="margin-left:15%; width: 53%;"></td>`;
    //tableHtml += '<td>'+ Price +'</td>';
    tableHtml +=
        `<td style="padding-top:20px;"><input id="price" name="price[]" value="${Price}" type="text" class="form-control" onkeypress = "return onlyNumberKey(event)",  onkeyup="RateChange($(this).val(), $(this).closest('tr').index());" style="margin-left:-20%; width: 108%;"></td>`;
    // tableHtml += `<td style="padding-top:20px;"><input id="test" value="${expiry}" type="text" class="form-control" style="margin-left:-32%; width: 103%;" disabled></td>`;
    tableHtml +=
        `<td style="padding-top:20px; display:none;"><input id="warehouse_id" name="warehouse_id" value="${warehouse_id}" type="text" class="form-control" style="margin-left:-32%; width: 103%;"></td>`;
    //tableHtml += '<td>'+ Total +'</td>';
    tableHtml +=
        `<td style="padding-top:20px; display:none;"><input id="total" name="total[]" value="${Total}" type="text" class="form-control" style="margin-left:-5%; width: 108%;"></td>`;
        tableHtml +=
        `<td style="padding-top:20px;"><input id="totals" name="totals" value="${Total}" type="text" class="form-control" style="margin-left:-5%; width: 108%;" disabled></td>`;
    tableHtml +=
        '<td><button onclick="javascript:myDeleteFunction($(this).closest(\'tr\'));" class="btn btn-red" type="button" style="margin-left: 30%;"> <i  class="icon-trash" title="Delete Row"></i></button></td>';
    tableHtml += '</tr></br>';
    $('#myData').append(tableHtml);
    $("#product_name").select2("open");
    // document.getElementById("product_code").focus();
}

function QtyChange(qty, RowIndex) {
    // if((Quantity) == "" || (Quantity) == 0 || (Quantity) == 'NaN' ){
    //             document.getElementById("quantity").focus();
    //             Swal.fire('Quantity Cant be Empty or 0!');
    //                 return false;
    //         }
            var Rate = $('tr:eq(' + RowIndex + ')', myData).find("td:eq('6')").find('input').val();
            //  alert(Rate)
              var total = Rate * qty;
              //INSERT
              $('tr:eq(' + RowIndex + ')', myData).find("td:eq('8')").find('input').val(total);
              //SHOW
              $('tr:eq(' + RowIndex + ')', myData).find("td:eq('9')").find('input').val(total);
        }

        function RateChange(Rate, RowIndex) {
            var Qty = $('tr:eq(' + RowIndex + ')', myData).find("td:eq('5')").find('input').val();
            //  alert(Qty)
             var total = Rate * Qty;
             //INSERT
             $('tr:eq(' + RowIndex + ')', myData).find("td:eq('8')").find('input').val(total);
            //SHOW
             $('tr:eq(' + RowIndex + ')', myData).find("td:eq('9')").find('input').val(total);
        }

function myDeleteFunction(row) {
    Swal.fire({
                    title: "Are You Sure?",
                    text: "Confirm Transaction?",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonText: 'Yes, Create it!',
                    confirmButtonColor: '#28A745',
                    cancelButtonText: 'No, cancel!',
                    cancelButtonColor: '#DC3545',
                }).then((result) => {
                    if (result.isConfirmed) {
            var rate = document.getElementById('TotalRate').value;
            var amount = document.getElementById('TotalAmount').value;
            var currentrate = $(row).find("td:eq('5')").find("input").val();
            var currentamount = $(row).find("td:eq('8')").find("input").val();
            var grandRate = parseInt(rate) - parseInt(currentrate);
            var grandAmount = parseInt(amount) - parseInt(currentamount);
            document.getElementById('TotalRate').value = grandRate;
            document.getElementById('TotalAmount').value = grandAmount;
            $(row).remove();
        }
    });
    // if(confirm("Are you sure you want to delete this row?"))
    // {
    // 	$(row).remove();
    // }
}

function productMouseUp(productID, rowIndex) {
    $.ajax({
        type: "GET",
        url: "{{ asset('productmouseup-ajax') }}?product_ID=" + productID,
        success: function(result) {
            if (result.length > 0) {
                $('#product_code').val(result[0].product_code);
                $('#uoms').val(result[0].uom);
                $('#product_id').val(result[0].id);
                $('#price').val(result[0].product_cost);
                var price = $("#price").val();
                var quantity = $("#quantity").val();
                var total = price * quantity;
                document.getElementById('total').value = total;
            }
        },
        error: function(xhr, ajaxOptions, thrownError) {
            alert(xhr.status);
            alert(thrownError);
        }
    });
}

function submitForm() {
    // alert('dd')
            $("#StockForm").submit();
        }
</script>
@stop