<!-- <div class="header-container" style="border-bottom: 2px solid #333; padding-bottom: 20px; margin-bottom: 20px;"> -->
<div class="header-container" style="padding-bottom: 20px; margin-bottom: 20px;">
    <div class="header-content">
        <div class="company-info">
            <h3 style="color: #333; margin: 0 0 10px 0; font-size: 1.5rem;">{{ session()->get('company_name') }}</h3>
            <p style="color: #333; font-weight: 600; margin: 5px 0;">Phone: {{ session()->get('company_phone') }}</p>
            <p style="color: #333; font-weight: 600; margin: 5px 0;">Email: {{ session()->get('company_email') }}</p>
        </div>
        
        <div class="company-actions">
            <button class="print-button" onclick="printInvoice()">
                Print <i class="fas fa-print"></i>
            </button>
            <div class="company-details">
                <p style="color: #333; font-weight: 600; margin: 5px 0;">Address: {{ session()->get('company_address') }}</p>
                <p style="color: #333; font-weight: 800; margin: 5px 0; font-size: 1rem;">NTN: {{ session()->get('company_ntn') }}</p>
            </div>
        </div>
    </div>
</div>

<script>
    function printInvoice() {
        document.querySelector('.print-button').style.display = 'none';
        window.print();
    }
</script>

<style>
    .header-container {
        width: 100%;
    }
    
    .header-content {
        display: flex;
        flex-direction: column;
        gap: 20px;
    }
    
    .company-info {
        order: 1;
    }
    
    .company-actions {
        order: 2;
        display: flex;
        flex-direction: column;
        align-items: center;
        gap: 10px;
    }
    
    .print-button {
        background-color: #17a2b8;
        color: white;
        border: none;
        padding: 8px 16px;
        border-radius: 4px;
        cursor: pointer;
        font-weight: 600;
        transition: background-color 0.3s;
    }
    
    .print-button:hover {
        background-color: #138496;
    }
    
    .print-button i {
        margin-left: 5px;
    }
    
    @media (min-width: 576px) {
        .header-content {
            flex-direction: row;
            justify-content: space-between;
            align-items: flex-start;
        }
        
        .company-info {
            text-align: left;
        }
        
        .company-actions {
            align-items: flex-end;
        }
    }
</style>