@extends("app")
@section('contents')
    <link rel="stylesheet" href="https://ajax.googleapis.com/ajax/libs/jqueryui/1.8.9/themes/base/jquery-ui.css"
        type="text/css" />
    <meta name="csrf-token" content="{{ csrf_token() }}" />

    <body>
        <div class="container-fluid">
            @if (Session::has('flash_message'))
                <button type="button" class="close" data-dismiss="alert" aria-hidden="true"
                    style="margin-right: 20px;margin-top: 15px;">&times;</button>
                <div class="alert alert-success"> {{ Session::get('flash_message') }} </div>
            @endif
        </div>
        <div class="row">
            <div class="col-lg-12">
                <div class="panel panel-default">
                    <div class="panel-heading clearfix" id="panelbg">
                        <h2 class="panel-title"><b>Edit Journal Voucher</b></h2>
                    </div>
                    <div class="panel-body">
                        <input id="token" type="hidden" value="{{ $encrypted_token }}">
                        @include('errors.validation')
                        {!! Form::model($edit, ['method' => 'PATCH', 'action' => ['App\Http\Controllers\GeneralVoucherController@update', $edit->id], 'class' => 'form-horizontal']) !!}
                        {!! Form::hidden('company_id', session()->get('company_id'), ['id' => 'company_id']) !!}
                        <div class="row">
                            <div class="form-group" style="margin-left: 1%; margin-right: 1%;">
                                <label class="col-sm-1 control-label">Vr. No</label>
                                <div class="col-sm-2">
                                    <div id="year-view" class="input-group date">
                                        {!! Form::text('voucher_no', $edit->voucher_no, ['id' => 'voucher_no', 'class' => 'form-control', 'autofocus' => 'autofocus']) !!}
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group" style="margin-left: 1%; margin-right: 1%;">
                                <label class="col-sm-1 control-label">Vr. Date</label>
                                <div class="col-sm-2">
                                    <div id="year-view" class="input-group date">
                                        <!-- <input id="voucher_date" type="date" name="voucher_date" value="<?php echo date('Y-m-d'); ?>" class="form-control"> -->
                                        {!! Form::date('voucher_date', $edit->voucher_date, ['id' => 'voucher_date', 'class' => 'form-control']) !!}
                                        <!-- <span class="input-group-addon"><i class="fa fa-calendar"></i></span>  -->
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row" style="display: none;">
                            <div class="form-group" style="margin-left: 1%; margin-right: 1%;">
                                <label class="col-sm-1 control-label">Voucher Type</label>
                                <div class="col-sm-5" style="height: 40px;">
                                    {!! Form::text('v_type', 'Journal Voucher', ['id' => 'v_type', 'class' => 'form-control']) !!}
                                </div>
                            </div>
                        </div>

                        <div class="row" style="display:none;">
                            <div class="form-group" style="margin-left: 1%; margin-right: 1%;">
                                <label class="col-sm-1 control-label">Biller</label>
                                <div class="col-sm-3" style="height: 40px;">
                                    <select name="biller" id="biller" class="form-control" disabled>
                                        <option value="{{ Auth::user()->id }}">{{ Auth::user()->name }}</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="panel panel-default">
                            <div class="panel-body">
                                <div class="form-group">
                                    <table>
                                        <div class="container-fluid">
                                            <div class="row" id="myTable">
                                                <tr>

                                                    {!! Form::hidden('product_id', null, ['id' => 'product_id', 'class' => 'form-control']) !!}
                                                    <div class="col-md-2" style="margin-left: 1%; margin-right: 1%;">
                                                        <div class="form-group">
                                                            <label for="H.S" class="control-label">Date</label>
                                                            <input id="date" type="date" name="date"
                                                                value="<?php echo date('Y-m-d'); ?>" class="form-control">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-1"
                                                        style="margin-left: 1%; margin-right: 1%; display:none;">
                                                        <div class="form-group">
                                                            <label for="password"
                                                                class="control-label">Voucher&nbsp;No</label>
                                                            {!! Form::text('voucher_no', $codes, ['id' => 'voucher_no', 'class' => 'form-control']) !!}
                                                        </div>
                                                    </div>
                                                    <div class="col-md-2" style="display:none;">
                                                        <div class="form-group">
                                                            <label for="password" class="control-label">Type</label>
                                                            {!! Form::text('v_type', 'Journal Voucher', ['id' => 'v_type', 'class' => 'form-control']) !!}
                                                        </div>
                                                    </div>
                                                    <div class="col-md-1">
                                                        <div class="form-group">
                                                            <label for="Name" class="control-label">Account Type</label>
                                                            {!! Form::select('account_type', $accountGroups, null, ['id' => 'account_type', 'class' => 'form-control']) !!}
                                                        </div>
                                                    </div>
                                                    <div class="col-md-2" style="margin-left: 1%; margin-right: 1%;">
                                                        <div class="form-group">
                                                            <label for="Name"
                                                                class="control-label">Account&nbsp;Name</label>
                                                            {!! Form::select('account_head_id', $Heads, null, ['id' => 'account_head_id', 'class' => 'form-control']) !!}
                                                        </div>
                                                    </div>
                                                    <div class="col-md-2" style="margin-left: 1%; margin-right: 1%;">
                                                        <div class="form-group">
                                                            <label for="password" class="control-label">Description</label>
                                                            {!! Form::text('narration', 'OPENING BALANCE', ['id' => 'narration', 'class' => 'form-control']) !!}
                                                        </div>
                                                    </div>
                                                    <div class="col-md-1" style="margin-left: 1%; margin-right: 1%;">
                                                        <div class="form-group">
                                                            <label for="password" class="control-label">Debit</label>
                                                            {!! Form::text('debit', 0, ['id' => 'debit', 'class' => 'form-control']) !!}
                                                        </div>
                                                    </div>
                                                    <div class="col-md-1" style="margin-left: 1%; margin-right: 1%;">
                                                        <div class="form-group">
                                                            <label for="password" class="control-label">Credit</label>
                                                            {!! Form::text('credit', 0, ['id' => 'credit', 'class' => 'form-control']) !!}
                                                        </div>
                                                    </div>
                                                    <div class="col-md-1" style="margin-left: 1%; margin-right: 1%;">
                                                        <div class="form-group">
                                                            <label for="password" class="control-label">Add</label>

                                                            <button class="form-control" style="background: #e20707;"
                                                                type="button" class="btn btn-red"
                                                                onkeyup="AddGridData();">Add</button>
                                                            <!-- <button type="button" onclick="AddGridData()" class="btn btn-red"><i class="fa fa-plus"></i> </button> -->
                                                        </div>
                                                    </div>
                                                </tr>
                                            </div></br>
                                            <table id="myData">
                                                <?php $TotalDebit = 0;
                                                $TotalCredit = 0; ?>
                                                @foreach ($edit->voucher_details as $details)
                                                    @if ($details->debit != null)
                                                        <tr>
                                                            <td style="display:none;">
                                                                <input id="account_head_id" name="account_head_id[]"
                                                                    value="{{ $details->account_head_id }}" type="text"
                                                                    class="form-control">
                                                            </td>
                                                            <td style="margin-left: 1%; margin-right: 1%; padding-top:2%">
                                                                <input id="date" name="date[]"
                                                                    value="{{ $details->date }}"
                                                                    style="margin-left: 7%; width: 120%;" type="text"
                                                                    class="form-control">
                                                            </td>
                                                            <td style="margin-left: 1%; margin-right: 1%; padding-top:2%">
                                                                <input id="account_head_name" name="account_head_name[]"
                                                                    value="{{ $details->parties->party_name }}"
                                                                    style="margin-left: 40%; width: 120%;" type="text"
                                                                    class="form-control">
                                                            </td>
                                                            <td style="margin-left: 1%; margin-right: 1%; padding-top:2%">
                                                                <input id="narration" name="narration[]"
                                                                    value="{{ $details->narration }}"
                                                                    style="margin-left: 74%; width: 178%;" type="text"
                                                                    class="form-control">
                                                            </td>
                                                            <td style="margin-left: 1%; margin-right: 1%; padding-top:2%">
                                                                <input id="debit" name="debit[]"
                                                                    value="{{ $details->debit }}"
                                                                    style="margin-left: 166%; width: 61%;" type="text"
                                                                    class="form-control">
                                                            </td>
                                                            <td style="margin-left: 1%; margin-right: 1%; padding-top:2%">
                                                                <input id="credit" name="credit[]"
                                                                    value="{{ $details->credit }}"
                                                                    style="margin-left: 140%; width: 61%;" type="text"
                                                                    class="form-control">
                                                            </td>
                                                            <td style="padding-top:2%"><button class="btn btn-red"
                                                                    type="button"
                                                                    style="margin-left: 555%; margin-top: -35%;"> <i
                                                                        onclick="javascript:myDeleteFunction($(this).closest('tr'));"
                                                                        class="icon-trash"
                                                                        title="Delete Row"></i></button></td>
                                                            @php
                                                                $TotalDebit = $TotalDebit + $details->debit;
                                                                $TotalCredit = $TotalCredit + $details->credit;
                                                            @endphp
                                                        </tr>
                                                    @endif
                                                @endforeach

                                            </table>
                                        </div>
                                    </table></br></br>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="panel panel-default">
                                    <div class="panel-heading clearfix" id="panelbg">
                                        <div class="container">
                                            <div class="col-xs-5"> </div>
                                            <!-- <div class="col-xs-3">  </div> -->
                                            <div class="col-xs-3"> <b>Total Debit</b> <input type="text"
                                                    value="{{ $TotalDebit }}" id="TotalDebit" name="TotalDebit" disabled>
                                            </div>
                                            <div class="col-xs-4"> <b>Total Credit</b> <input type="text"
                                                    value="{{ $TotalCredit }}" id="TotalCredit" name="TotalCredit"
                                                    disabled> </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <center>
                            <div class="form-actions">
                                <button type="submit" class="btn btn-primary" id="btnSaves" name="btnSaves">Save</button>
                            </div>
                        </center>
                        <!-- <div class="col-lg-3">
            <button type="button" onclick="AddRowFunction()" class="btn btn-success"><i class="fa fa-plus"></i> </button>
            <button type="button" onclick="AddGridData()" class="btn btn-success"><i class="fa fa-plus"></i> </button>
            <button type="button" onclick="TotalRecords()" class="btn btn-success">Total Records</button>
           </div> -->
                        {!! Form::close() !!}
                    </div>
                </div>
            </div>
        </div>
    </body>
@stop
@section('scripts')

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
    <script type="text/javascript" src="https://ajax.googleapis.com/ajax/libs/jqueryui/1.10.2/jquery-ui.min.js"></script>
    <script src="{{ asset('js/plugins/nouislider/nouislider.min.js') }}"></script>
    <!-- Input Mask-->
    <script src="{{ asset('js/plugins/jasny/jasny-bootstrap.min.js') }}"></script>
    <!-- Select2-->
    <script src="{{ asset('js/plugins/select2/select2.full.min.js') }}"></script>
    <!--Bootstrap ColorPicker-->
    <script src="{{ asset('js/plugins/colorpicker/bootstrap-colorpicker.min.js') }}"></script>
    <!--Bootstrap DatePicker-->
    <script src="{{ asset('js/plugins/datepicker/bootstrap-datepicker.js') }}"></script>

    <script type="text/javascript">
        function AddGridData() {
            var date = document.getElementById('date').value;
            var VoucherNo = document.getElementById('voucher_no').value;
            var v_type = document.getElementById('v_type').value
            var HeadTitle = document.getElementById('account_head_id').value.split("_").pop();
            var HeadId = document.getElementById('account_head_id').value.split("_")[0];
            var Narration = document.getElementById('narration').value;

            var Debit = document.getElementById('debit').value;
            var Credit = document.getElementById('credit').value;

            var TotalDebit = document.getElementById('TotalDebit').value;
            var grandDebit = parseInt(Debit) + parseInt(TotalDebit);
            document.getElementById('TotalDebit').value = grandDebit;

            var TotalCredit = document.getElementById('TotalCredit').value;
            var grandCredit = parseInt(Credit) + parseInt(TotalCredit);
            document.getElementById('TotalCredit').value = grandCredit;
            //alert(grand)
            // var Credit = document.getElementById('credit').value;
            var tableHtml = '</br><tr>';
            //1
            tableHtml +=
                `<td style="display:none;"><input id="account_head_id" name="account_head_id[]" value="${HeadId}" type="text" class="form-control"></td>`;
            //2
            tableHtml +=
                `<td style="margin-left: 1%; margin-right: 1%; padding-top:2%;"><input id="date" name="date[]" value="${date}" style="margin-left: 7%; width: 120%;" type="text" class="form-control"></td>`;

            //5
            tableHtml +=
                `<td style="margin-left: 1%; margin-right: 1%; padding-top:2%;"><input id="account_head_name" name="account_head_name[]" value="${HeadTitle}" style="margin-left: 40%; width: 120%;" type="text" class="form-control"></td>`;
            //6
            tableHtml +=
                `<td style="margin-left: 1%; margin-right: 1%; padding-top:2%;"><input id="narration" name="narration[]" value="${Narration}" style="margin-left: 74%; width: 178%;" type="text" class="form-control"></td>`;
            //7
            tableHtml +=
                `<td style="margin-left: 1%; margin-right: 1%; padding-top:2%;"><input id="debit" name="debit[]" value="${Debit}" style="margin-left: 166%; width: 61%;" type="text" class="form-control"></td>`;

            tableHtml +=
                `<td style="margin-left: 1%; margin-right: 1%; padding-top:2%;"><input id="credit" name="credit[]" value="${Credit}" style="margin-left: 140%; width: 61%;" type="text" class="form-control"></td>`;

            tableHtml +=
                '<td style="padding-top:2%;"><button class="btn btn-red" type="button" style="margin-left: 555%; margin-top: -35%;"> <i onclick="javascript:myDeleteFunction($(this).closest(\'tr\'));" class="icon-trash" title="Delete Row"></i></button></td>';
            tableHtml += '</tr>';
            $('#myData').append(tableHtml);
        }



        function LedgerValues(values) {
            // alert("sammmr")
            // 	 $value = $("#sale_type").val();
            //  alert(value)
            if (values == "Cash Sale") {
                $('#ledgerRow').hide();
            }
            if (values == "Credit Sale") {
                $('#ledgerRow').show();
            }

        }

        function SampleDescription(val) {
            // alert(val)
            // $value = $("#sale_list").val();
            // alert(value)
            if (val == "Sample") {
                $('#sample_div').show();
            }
            if (val == "Sale Bill" || val == "Sale Invoice") {
                $('#sample_div').hide();
            }
        }


        function DCMouseUp(value) {
            $.ajax({
                type: "GET",
                url: "{{ asset('dcmouseup-ajax') }}?dc_no=" + value,
                success: function(data) {
                    if (data.length > 0) {
                        $.each(data, function(key, value) {
                            var newRow = '<tr>' +
                                '<td class="text-center"><i onclick="javascript:myDeleteFunction($(this).closest(\'tr\'));" class="icon-cancel icon-larger red-color" title="Delete Row"></i> </td>' +
                                '<td>' + data[key].product_id + '</td>' +
                                '<td>' + data[key].product_code + '</td>' +
                                '<td>' + data[key].product_name + '</td>' +
                                '<td>' + data[key].rate + '</td>' +
                                '<td id="quantity">' + data[key].quantity + '</td>' +
                                '<td>' + data[key].amount + '</td>' +
                                '<td><input type="text" onkeyup="SaleKeyUp($(this).val(), $(this).closest(\'tr\').index())"></td>' +
                                '<td></td>' +
                                // '<td style="display:none;">' + data[0].tax_id + '</td>'+

                                '</tr>';
                            $('#GridTable').append(newRow);
                            // $("#GridTable tr").append("<td>" +
                            //                     "ID :" + value.pr_no +
                            //                     "Name :"+ value.pr_no +
                            //                     "Age :" + value.pr_no + 
                            //                     "</td>");

                        });
                    }
                }
            })

        }

        function SaleKeyUp(SaleValue, RowIndex) {
            var quantity = $('tr:eq(' + RowIndex + ')', GridTable).find("td:eq('5')").text();
            // alert(quantity)
            var total = SaleValue * quantity;
            $('tr:eq(' + RowIndex + ')', GridTable).find("td:eq('8')").text(total);

        }

        function SaleKeyUpOne(SaleValue) {
            alert(SaleValue)
        }


        function TotalRecords() {
            var rowCount = document.getElementById('myTable').rows.length;
            alert("Total Number of Records Are: " + rowCount);
        }

        // on javascript onclick on product dropdown 
        // 	function CodeKeyUp(codeValue){
        // 		$.ajax({
        // 			type: "GET",
        // 			url: "/saletab-ajax?code=" + codeValue,
        // 			success: function(result) {
        // 				if(result.length > 0)
        // 				{
        // 					$('#product_name').val(result[0].product_name);
        // 					$('#product_id').val(result[0].id);
        // 					$("#packing_type").val(result[0].catagory_name);
        // 					$("#price_per_unit").val(result[0].price_per_unit);
        // 					$("#uom").val(result[0].uom);
        // 					$("#stvalue").val(result[0].stvalue);

        // 					var price = $("#price_per_unit").val();
        // 					var quantity = $("#quantity").val();
        // 					var stvalue = $("#stvalue").val();
        // 					var tax = parseInt((stvalue/100*price)*quantity);

        // 					document.getElementById('taxvalue').value = tax;
        // 					valueWithoutTax = quantity * price;
        // 					document.getElementById('value').value = valueWithoutTax;
        // 					var total = price * quantity;
        // 					var grand = tax + total;
        // 					document.getElementById('amount').value = grand;
        // 					document.getElementById('grand_total').value = grand;
        // 				}	
        // 			},
        // 			error: function (xhr, ajaxOptions, thrownError) {
        // 				alert(xhr.status);
        // 				alert(thrownError);
        // 			}				
        // 		});
        // }

        // on javascript onclick on product dropdown 
        function ProductKeyUp(productID) {
            $.ajax({
                type: "GET",
                url: "/{{ asset('productkeyup-ajax') }}?prodID=" + productID,
                success: function(result) {
                    if (result.length > 0) {
                        $('#product_code').val(result[0].product_code);
                        $('#product_id').val(result[0].id);
                        $("#product_cost").val(result[0].unit_cost);
                        $("#price_per_unit").val(result[0].price_per_unit);

                        var price = $("#price_per_unit").val();
                        var quantity = $("#quantity").val();
                        var cost = $("#product_cost").val();
                        var CostAmount = cost * quantity;
                        var SaleAmount = price * quantity;
                        document.getElementById('cost_amount').value = CostAmount;
                        document.getElementById('balance').value = SaleAmount;
                    }
                },
                error: function(xhr, ajaxOptions, thrownError) {
                    alert(xhr.status);
                    alert(thrownError);
                }
            });
        }

        // function SaleRate(salerate){
        // 	var quantity = document.getElementById('quantity').value;
        // 	var price = document.getElementById('price_per_unit').value;
        // 	var total = quantity*salerate;
        // 	document.getElementById('balance').value = total;

        // }

        function SaleRate(salerate) {
            var quantity = document.getElementById('quantity').value;
            var price = document.getElementById('price_per_unit').value;
            var discount = document.getElementById('discount_id').value.split("_").pop();
            var total = quantity * salerate;
            var totalDiscount = (discount / 100 * price * quantity);
            document.getElementById('balance').value = total - totalDiscount;

        }

        function QuantityKeyUp(quantity) {
            var price = document.getElementById('price_per_unit').value;
            var cost = document.getElementById('product_cost').value;
            var CostAmount = quantity * cost;
            document.getElementById('cost_amount').value = CostAmount;
            total = (quantity * price);
            document.getElementById('balance').value = total;
        }

        function DiscountKeyUp(discount, discountID) {
            var price = document.getElementById('price_per_unit').value;
            var cost = document.getElementById('product_cost').value;
            var quantity = document.getElementById('quantity').value;
            var CostAmount = quantity * cost;
            var totalDiscount = discount / 100 * price * quantity;
            //alert(totalDiscount)
            document.getElementById('cost_amount').value = CostAmount;
            total = (quantity * price);
            document.getElementById('balance').value = total - totalDiscount;
        }

        function PartyKeyUp(partyId) {
            $.ajax({
                type: "GET",
                url: "{{ asset('partyonchange-ajax') }}?party_id=" + partyId,
                success: function(result) {
                    if (result.length > 0) {
                        $('#party_id').val(result[0].id);
                        $('#address').val(result[0].address);
                        $('#strn').val(result[0].strn);
                        $('#ntn').val(result[0].ntn);
                    }
                }
            })
        }


        //on product Mouse up 
        function productMouseUp(productName, rowIndex) {
            $.ajax({
                type: "GET",
                url: "/{{ asset('productonchange-ajax') }}?product_name=" + productName,
                success: function(result) {
                    if (result.length > 0) {
                        $('tr:eq(' + rowIndex + ')', myTable).find("td:eq('0')").find('input').val(result[0]
                            .id);
                        $('tr:eq(' + rowIndex + ')', myTable).find("td:eq('1')").find('input').val(result[0]
                            .product_code);
                        $('tr:eq(' + rowIndex + ')', myTable).find("td:eq('3')").find('input').val(result[0]
                            .remaining_quantity);
                        $('tr:eq(' + rowIndex + ')', myTable).find("td:eq('5')").find('input').val(result[0]
                            .unit_cost);

                        var salePrice = $('tr:eq(' + rowIndex + ')', myTable).find("td:eq('6')").find('input')
                            .val();

                        var discount = $('tr:eq(' + rowIndex + ')', myTable).find("td:eq('4')").find('select')
                            .val().split("_").pop();
                        var quantity = $('tr:eq(' + rowIndex + ')', myTable).find("td:eq('3')").find('input')
                            .val();
                        var price = $('tr:eq(' + rowIndex + ')', myTable).find("td:eq('6')").find('input')
                            .val();
                        var grand = (price * quantity) - (((discount / 100)) * price * quantity);
                        $('tr:eq(' + rowIndex + ')', myTable).find("td:eq('7')").find('input').val(grand);

                    }
                },
                error: function(xhr, ajaxOptions, thrownError) {
                    alert(xhr.status);
                    alert(thrownError);
                }
            });
        }

        function salepriceMouseUp(salePrice, rowIndex) {
            var quantity = $('tr:eq(' + rowIndex + ')', myTable).find("td:eq('3')").find('input').val();
            var saleprice = $('tr:eq(' + rowIndex + ')', myTable).find("td:eq('6')").find('input').val();
            var grand = quantity * saleprice;
            $('tr:eq(' + rowIndex + ')', myTable).find("td:eq('7')").find('input').val(grand);
        }

        $("#product_codess").keyup(function() {
            if ($("#product_code").val() != "0") {
                $.ajax({
                    type: "GET",
                    url: "/{{ asset('getfirstProduct-ajax') }}?saletab_id=" + $("#product_code").val(),
                    success: function(result) {
                        if (result.length > 0) {
                            $("#product_id").val(result[0].id);
                            $("#product_name").val(result[0].product_english);
                            $("#unit_cost").val(result[0].product_price);

                            var quantity = document.getElementById('quantity').value;
                            var cost = document.getElementById('unit_cost').value;
                            var discount = document.getElementById('discount_id').value.split("_")
                                .pop();
                            //var tax = document.getElementById('tax_id').value.split("_").pop();
                            var totalDiscount = ((discount / 100) * quantity * cost);
                            var total = quantity * cost;
                            document.getElementById('total_cost').value = total - totalDiscount;

                        }
                    },
                    error: function(xhr, ajaxOptions, thrownError) {
                        alert(xhr.status);
                        alert(thrownError);
                    }
                });
            }
        });


        function myDeleteFunction(row) {
            alertify.confirm("Are you sure you want to delete this Record?", function(e) {
                if (e) {
                    var TotalDebit = document.getElementById('TotalDebit').value;
                    var CurrentDebit = $(row).find("td:eq('4')").find('input').val();
                    var grand = parseInt(TotalDebit) - parseInt(CurrentDebit);
                    document.getElementById('TotalDebit').value = grand;

                    var TotalCredit = document.getElementById('TotalCredit').value;
                    var CurrentCredit = $(row).find("td:eq('5')").find('input').val();
                    var grandcredit = parseInt(TotalCredit) - parseInt(CurrentCredit);
                    document.getElementById('TotalCredit').value = grandcredit;
                    $(row).remove();
                    //alertify.alert("Row is Removed!");
                } else {
                    alertify.alert("Row Not Deleted!");
                }
            });
            // if(confirm("Are you sure you want to delete this row?"))
            // {
            // 	$(row).remove();
            // }
        }


        function DiscountNew(discount, rowIndex) {
            var quantity = $('tr:eq(' + rowIndex + ')', myTable).find("td:eq('3')").find('input').val();
            var discountnew = $('tr:eq(' + rowIndex + ')', myTable).find("td:eq('4')").find('select').val().split("_")
                .pop();
            var price = $('tr:eq(' + rowIndex + ')', myTable).find("td:eq('5')").find('input').val();
            var totalDiscount = ((discountnew / 100) * quantity * price);
            var total = quantity * price;
            //document.getElementById('total_costnew').value = totalDiscount;
            $('tr:eq(' + rowIndex + ')', myTable).find("td:eq('6')").find('input').val(total - totalDiscount);
            ///if(parseFloat(tax) > 0)
            //{
            //var grand = (quantity*unitPrice) - discount;

            //}
            //else
            //{
            //$('tr:eq(' + rowIndex + ')', myTable).find("td:eq('5')").find('input').val(unitPrice);
            //}	

        }

        // on javascript onclick on product dropdown
        function quantityMouseUp(quantity, rowIndex) {


            var code = $('tr:eq(' + rowIndex + ')', myTable).find("td:eq('1')").find('input').val();
            alert(code);
            var remainingquantity = $('tr:eq(' + rowIndex + ')', myTable).find("td:eq('8')").find('input').val();
            if (quantity > remainingquantity) {
                alert("Invalid! Your Remaining Stock is: " + quantity);
                e.preventdefault();
            }
            var price = $('tr:eq(' + rowIndex + ')', myTable).find("td:eq('6')").find('input').val();
            var discount = $('tr:eq(' + rowIndex + ')', myTable).find("td:eq('4')").find('select').val().split("_").pop();

            var totalDiscount = ((discount / 100) * quantity * price);
            var total = quantity * price;
            $('tr:eq(' + rowIndex + ')', myTable).find("td:eq('7')").find('input').val(total - totalDiscount);
            //if(parseInt(quantity) > 0)
            //{	
            //$('tr:eq(' + rowIndex + ')', myTable).find("td:eq('4')").find('input').val(grand);
            //}
            //else
            //{
            //$('tr:eq(' + rowIndex + ')', myTable).find("td:eq('4')").find('input').val(price);
            //}	

        }

        $("#btnSave").click(function() {
            alertify.confirm("Are you sure you want update Cash Payment Voucher?", function(e) {
                if (e) {
                    var voucher = new Object();
                    voucher.account_id = $("#account_id").val().split("_")[0];
                    voucher.voucher_no = $("#voucher_no").val();
                    voucher.voucher_date = $("#voucher_date").val();
                    voucher.v_type = $("#v_type").val();
                    voucher.biller = $("#biller").val();
                    voucher.company_id = $('#company_id').val();

                    var products = [];
                    $.each($("#myData tr"), function(index, row) {
                        var columns = $(row).find("td");
                        var product = new Object();
                        // product.party_id = $("#party_id").val();
                        product.head_id = $(columns[0]).find("input").val();
                        product.date = $(columns[1]).find("input").val();
                        product.voucher_no = $(columns[2]).find("input").val();
                        product.v_type = $(columns[3]).find("input").val();
                        product.narration = $(columns[5]).find("input").val();
                        product.amount = $(columns[6]).find("input").val();
                        product.company_id = $('#company_id').val();
                        products.push(product);
                    });

                    var $_token = jQuery('#token').val();
                    jQuery.ajax({
                        method: "PATCH",
                        cache: false,
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        data: {
                            voucher: JSON.stringify(voucher),
                            product_data: products
                        },
                        //url: "/cash-receipts",
                        url: "/{{ asset('cash-payments') }}/<?php echo $edit->id; ?>",

                        success: function(result) {
                            if (parseInt(result) > 0)
                            //if(parseInt(result) > 0)
                            {
                                //window.open("/sales/print/"+result);
                                window.location.href = "/{{ asset('cash-payments') }}";
                                //alert("Cash Receipt successfully saved.");
                                //window.open("/sales/print/"+result);
                                //alert("Sale successfully saved.");
                                //Session::flash('flash_message', 'Sale Added Successfully!');
                                //window.location.href = "/sales";

                            }
                        },
                        error: function(xhr, ajaxOptions, thrownError) {
                            $("#spanWait").hide();
                            alert(xhr.status);
                            alert(thrownError);
                        }
                    });
                } else {
                    alertify.alert("Not Saved!");
                }
            });
        });



        //Select Account Type, SHow Related Acccounts
        $('#account_type').change(function() {
            var account_type = $(this).val();
            $.ajax({
                url: "{{ asset('get_account_group_parties') }}?id=" + account_type,
                type: 'get',
                dataType: 'json',
                success: function(response) {
                    if (response.length == 0) {
                        $('#select2-account_head_id-container').text('Account Not Found');
                        $('#account_head_id').html('<option>Account Not Found</option>');
                    } else {
                        var str = '';
                        $('#select2-account_head_id-container').text('Select Account');
                        $.each(response, function(i, v) {
                            str +=
                                `<option value="${v.id+'_'+v.party_name}">${v.party_name}</option>`;
                        });

                        $('#account_head_id').html(str);
                    }
                }
            });
        });
        // End Here
    </script>
@stop
