@extends("app")

<head>
    <link href="{{ asset('css/select2.min.css') }}" rel="stylesheet" />
    <meta name="csrf-token" content="{{ csrf_token() }}" />
</head>
@section('contents')
    <!-- <body onload="AddRowFunction()"> -->

    <body>
        <div class="container-fluid">
            @if (Session::has('flash_message'))
                <button type="button" class="close" data-dismiss="alert" aria-hidden="true"
                    style="margin-right: 20px;margin-top: 15px;">&times;</button>
                <div class="alert alert-success"> {{ Session::get('flash_message') }} </div>
            @endif
        </div>
        <div class="row">
            <div class="col-lg-12">
                <div class="panel panel-default">
                    <div class="panel-heading clearfix" id="panelbg">
                        <h2 class="panel-title"><b>Cash Payment Voucher</b></h2>
                    </div>
                    <div class="panel-body">
                        <input id="token" type="hidden" value="{{ $encrypted_token }}">
                        @include('errors.validation')
                        {!! Form::open(['url' => 'cash-payments', 'class' => 'form-horizontal']) !!}
                        {!! Form::hidden('company_id', session()->get('company_id'), ['id' => 'company_id']) !!}
                        <input type="hidden" id="shop_id" name="shop_id" value="{{ Auth::User()->shop_id }}">
                        <div class="row">
                            <div class="form-group" style="margin-left: 1%; margin-right: 1%;">
                                <label class="col-sm-1 control-label">Vr. No</label>
                                <div class="col-sm-2">
                                    <div id="year-view" class="input-group date">
                                        {!! Form::text('voucher_no', $codes, ['id' => 'voucher_no', 'class' => 'form-control', 'disabled' => 'disabled']) !!}
                                    </div>
                                </div>
                                <label class="col-sm-1 control-label">Vr. Date</label>
                                <div class="col-sm-2">
                                    <div id="year-view" class="input-group date">
                                        <input id="voucher_date" type="date" name="voucher_date" value="<?php echo date('Y-m-d'); ?>"
                                            class="form-control" autofocus>

                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row" style="display: none;">
                            <div class="form-group" style="margin-left: 1%; margin-right: 1%;">
                                <label class="col-sm-1 control-label">Voucher Type</label>
                                <div class="col-sm-5" style="height: 40px;">
                                    {!! Form::text('v_type', 'Cash Payment', ['id' => 'v_type', 'class' => 'form-control']) !!}
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group" style="margin-left: 1%; margin-right: 1%;">
                                <label class="col-sm-1 control-label">Account&nbsp;Name</label>
                                <div class="col-sm-3" style="height: 40px;">
                                    {!! Form::select('account_id', $cashAccount, null, ['id' => 'account_id', 'class' => 'form-control']) !!}
                                </div>
                            </div>
                        </div>
                        <div class="row" style="display:none;">
                            <div class="form-group" style="margin-left: 1%; margin-right: 1%;">
                                <label class="col-sm-1 control-label">Biller</label>
                                <div class="col-sm-3" style="height: 40px;">
                                    <select name="biller" id="biller" class="form-control" disabled>
                                        <option value="{{ Auth::user()->id }}">{{ Auth::user()->name }}</option>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="panel panel-default">
                            <div class="panel-body">
                                <div class="form-group">
                                    <table id="myTable">
                                        <div class="container-fluid">
                                            <div class="row">
                                                <tr>

                                                    <!-- <div class="col-md-3"> 
         <div class="form-group"> 
          <label for="H.S" class="control-label">Id</label> -->
                                                    {!! Form::hidden('product_id', null, ['id' => 'product_id', 'class' => 'form-control']) !!}
                                                    <!-- </div>
        </div>  -->
                                                    <div class="col-md-1" style="margin-left: 1%; margin-right: 1%;">
                                                        <div class="form-group">
                                                            <label for="H.S" class="control-label">Date</label>
                                                            <input id="date" type="date" name="date"
                                                                value="<?php echo date('Y-m-d'); ?>" class="form-control"
                                                                onkeyup="if(event.keyCode == 13) SaveFunction()">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-2" style="display:none;">
                                                        <div class="form-group">
                                                            <label for="password"
                                                                class="control-label">Voucher&nbsp;No</label>
                                                            {!! Form::text('voucher_no', $codes, ['id' => 'voucher_no', 'class' => 'form-control']) !!}
                                                        </div>
                                                    </div>
                                                    <div class="col-md-2" style="display:none;">
                                                        <div class="form-group">
                                                            <label for="password" class="control-label">Type</label>
                                                            {!! Form::text('v_type', 'Cash Payment', ['id' => 'v_type', 'class' => 'form-control']) !!}
                                                        </div>
                                                    </div>
                                                    <div class="col-md-1">
                                                        <div class="form-group">
                                                            <label for="Name"
                                                                class="control-label">Account Type</label>
                                                            {!! Form::select('account_type', $accountGroups, null, ['id' => 'account_type', 'class' => 'form-control']) !!}
                                                        </div>
                                                    </div>
                                                    <div class="col-md-2" style="margin-left: 1%; margin-right: 1%;">
                                                        <div class="form-group">
                                                            <label for="Name" class="control-label">Account
                                                                &nbsp;/&nbsp;Name</label>
                                                            {!! Form::select('account_head_id', $Accounts, null, ['id' => 'account_head_id', 'class' => 'form-control']) !!}
                                                        </div>
                                                    </div>
                                                    <div class="col-md-1" style="margin-left: 1%; margin-right: 1%;">
                                                        <div class="form-group">
                                                            <label for="password" class="control-label">Description</label>
                                                            {!! Form::text('narration', 'CASH PAID', ['id' => 'narration', 'class' => 'form-control']) !!}
                                                        </div>
                                                    </div>
                                                    <div class="col-md-1" style="margin-left: 1%; margin-right: 1%;">
                                                        <div class="form-group">
                                                            <label for="password" class="control-label">Amount</label>
                                                            {!! Form::text('amount', null, ['id' => 'amount', 'class' => 'form-control', 'onkeypress' => 'return onlyNumberKey(event)', 'onfocus' => 'this.value=""']) !!}
                                                        </div>
                                                    </div>
                                                    <div class="col-md-1" style="margin-left: 1%; margin-right: 1%;">
                                                        <div class="form-group">
                                                            <label for="password" class="control-label">Tax</label>
                                                            {!! Form::text('tax', null, ['id' => 'tax', 'class' => 'form-control', 'onfocus' => 'this.value=""', 'onkeypress' => 'return onlyNumberKey(event)','onchange'=>'changeAmount(this.value)']) !!}
                                                        </div>
                                                    </div>
                                                    <div class="col-md-1" style="margin-left: 1%; margin-right: 1%;">
                                                        <div class="form-group">
                                                            <label for="taxamount" class="control-label">Tax Amount</label>
                                                            {!! Form::text('taxamount', null, ['id' => 'taxamount', 'class' => 'form-control', 'disabled'=>'disabled']) !!}
                                                        </div>
                                                    </div>
                                                    <div class="col-md-1" style="margin-left: 1%; margin-right: 1%;">
                                                        <div class="form-group">
                                                            <label for="taxamount" class="control-label">Title</label>
                                                            {!! Form::select('title',$titles, null, ['id' => 'title', 'class' => 'form-control']) !!}
                                                        </div>
                                                    </div>
                                                    <!-- <div class="col-md-2"> 
         <div class="form-group"> 
          <label for="password" class="control-label">Credit</label> 
          {!! Form::text('credit', 0, ['id' => 'credit', 'class' => 'form-control']) !!}
         </div> 
        </div> -->
                                                    <div class="col-md-1" style="margin-left: 1%; margin-right: 1%;">
                                                        <div class="form-group">
                                                            <label for="password" class="control-label">Add</label>
                                                            <button class="form-control" style="background: #e20707;"
                                                                type="button" class="btn btn-red"
                                                                onkeyup="AddGridData();">Add</button>
                                                            <!-- <button type="button" onclick="AddGridData()" class="btn btn-red"><i class="fa fa-plus"></i> </button> -->
                                                        </div>
                                                    </div>
                                                </tr>
                                            </div>
                                        </div>
                                    </table><br><br>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="panel panel-default">
                                    <div class="panel-heading clearfix" id="subpanelbg">
                                        <h3 class="panel-title">Cash Payment Grid</h3>
                                    </div>
                                    <div class="panel-body">
                                        <div class="table-responsive">
                                            <table class="table table-bordered">
                                                <thead>
                                                    <tr>
                                                        <th>Dlt</th>
                                                        <th style="display:none;">Head&nbsp;ID</th>
                                                        <th>Date</th>
                                                        <th style="display:none;">Voucher&nbsp;No</th>
                                                        <th style="display:none;">Voucher&nbsp;Type</th>
                                                        <th>Account</th>
                                                        <th>Narration</th>
                                                        <th>Amount</th>
                                                        <th>Tax</th>
                                                        <th>Tax Amount</th>
                                                        <th>Title</th>
                                                        <!-- <th>Credit</th>  -->
                                                    </tr>
                                                </thead>
                                                <tbody id="GridTable">
                                                    <div class="row">
                                                    </div>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="panel panel-default">
                                    <div class="panel-heading clearfix" id="panelbg">
                                        <div class="container">
                                            <div class="col-lg-5"> </div>
                                            <div class="col-lg-3"> <b>Total&nbsp;Amount</b> <input type="text"
                                                    id="TotalAmount" name="TotalAmount" value="0" disabled> </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <center>
                            <div class="form-actions">
                                <button type="button" class="btn btn-primary" id="btnSave" name="btnSave">Save</button>
                            </div>
                        </center>
                        <div class="col-lg-3"></div>
                        {!! Form::close() !!}
                    </div>
                </div>
            </div>
        </div>
    </body>
@stop
@section('scripts')
    <script src="{{ asset('js/plugins/select2/select2.full.min.js') }}"></script>
    <script type="text/javascript">
        $("#account_id").select2();
        $("#account_id").next(".select2").find(".select2-selection").focus(function() {
            $("#account_id").select2("open");
        });

        $("#account_type").select2();
        $("#account_type").next(".select2").find(".select2-selection").focus(function() {
            $("#account_type").select2("open");
        });

        $("#account_head_id").select2();
        $("#account_head_id").next(".select2").find(".select2-selection").focus(function() {
            $("#account_head_id").select2("open");
        });

        $("#title").select2();
        $("#title").next(".select2").find(".select2-selection").focus(function() {
            $("#title").select2("open");
        });

        $('#account_id').change(function() {
            $('#account_id').select2().trigger('select2:close');
            $("#date").focus();
        });
        $('#account_head_id').change(function() {
            $('#account_head_id').select2().trigger('select2:close');
            $("#amount").focus();
        });

        
    </script>
    <script type="text/javascript">
        function changeAmount(tax)
        {
            var amount = parseInt(document.getElementById('amount').value);
            var taxAmount = parseInt((tax*amount)/100);

            document.getElementById('taxamount').value=taxAmount;
            var calculateAmount = amount-taxAmount;
            document.getElementById('amount').value = calculateAmount;
        }
        
        function AddGridData() {
            if ($("#amount").val() == "" || $("#account_head_id").val() == "") {
                alert('Account Name or Amount Value Cant be Empty!');
                document.getElementById("amount").focus();
                e.preventdefault();
            }
            var date = document.getElementById('date').value;
            var VoucherNo = document.getElementById('voucher_no').value;
            var v_type = document.getElementById('v_type').value;
            var HeadTitle = document.getElementById('account_head_id').value.split("_").pop();
            var HeadId = document.getElementById('account_head_id').value.split("_")[0];
            var Narration = document.getElementById('narration').value;
            var Amount = document.getElementById('amount').value;
            var total = document.getElementById('TotalAmount').value;
            var tax = document.getElementById('tax').value;
            var taxAmount = document.getElementById('taxamount').value;
            var title = document.getElementById('title').value;
            var grand = parseInt(Amount) + parseInt(total);
            document.getElementById('TotalAmount').value = grand;
            // var Credit = document.getElementById('credit').value;

            var tableHtml = '<tr>';
            tableHtml +=
                '<td class="text-center"><i onclick="javascript:myDeleteFunction($(this).closest(\'tr\'));" class="icon-cancel icon-larger red-color" title="Delete Row"></i> </td>';
            tableHtml += '<td style="display:none;">' + HeadId + '</td>';
            tableHtml += '<td>' + date + '</td>';
            tableHtml += '<td style="display:none;">' + VoucherNo + '</td>';
            tableHtml += '<td style="display:none;">' + v_type + '</td>';
            tableHtml += '<td>' + HeadTitle + '</td>';
            tableHtml += '<td>' + Narration + '</td>';
            tableHtml += '<td>' + Amount + '</td>';
            tableHtml += '<td>' + tax + '</td>';
            tableHtml += '<td>' + taxAmount + '</td>';
            tableHtml += '<td>' + title + '</td>';
            // tableHtml += '<td>'+ Credit +'</td>';
            tableHtml += '</tr>';
            $('#GridTable').append(tableHtml);
            document.getElementById("date").focus();
        }

        // function TotalRecords() {
        // 	var rowCount = document.getElementById('myTable').rows.length;
        // 	alert("Total Number of Records Are: " + rowCount);
        // }

        // function PartyKeyUp(partyId){
        // 	$.ajax({
        // 		type: "GET",
        // 		url: "/partyonchange-ajax?party_id=" + partyId,
        // 		success:function(result)
        // 		{
        // 			if(result.length > 0){
        // 				$('#party_id').val(result[0].id);
        // 				$('#address').val(result[0].address);
        // 				$('#strn').val(result[0].strn);
        // 				$('#ntn').val(result[0].ntn);
        // 			}
        // 		}
        // 	})
        // }

        function myDeleteFunction(row) {
            Swal.fire({
                    title: "Are You Sure?",
                    text: "Confirm Transaction?",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonText: 'Yes, Create it!',
                    confirmButtonColor: '#28A745',
                    cancelButtonText: 'No, cancel!',
                    cancelButtonColor: '#DC3545',
                }).then((result) => {
                    if (result.isConfirmed) {
                    var total = document.getElementById('TotalAmount').value;
                    var amount = $(row).find("td:eq('7')").text();
                    var grand = parseInt(total) - parseInt(amount);
                    document.getElementById('TotalAmount').value = grand;
                    $(row).remove();
                    document.getElementById("date").focus();
                }
            });

        }

        $("#btnSave").click(function() {
            if ($('#account_id').val() == '') {
                        //  alert('Please Select Supplier');
                         Swal.fire('Select Cash Account First');
                        //   $('#account_id').select2('open');
                          return false;
                    }
            Swal.fire({
                    title: "Are You Sure?",
                    text: "Confirm Transaction?",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonText: 'Yes, Create it!',
                    confirmButtonColor: '#28A745',
                    cancelButtonText: 'No, cancel!',
                    cancelButtonColor: '#DC3545',
                }).then((result) => {
                    if (result.isConfirmed) {
                    var voucher = new Object();
                    voucher.voucher_no = $("#voucher_no").val();
                    voucher.voucher_date = $("#voucher_date").val();
                    voucher.account_id = $("#account_id").val().split("_")[0];
                    voucher.shop_id = $("#shop_id").val();
                    voucher.v_type = $("#v_type").val();
                    voucher.biller = $("#biller").val();
                    voucher.company_id = $('#company_id').val();

                    var products = [];
                    $.each($("#GridTable tr"), function(index, row) {
                        var columns = $(row).find("td");
                        var product = new Object();
                        // product.party_id = $("#party_id").val();
                        product.head_id = $(columns[1]).text();
                        product.date = $(columns[2]).text();
                        product.voucher_no = $(columns[3]).text();
                        product.v_type = $(columns[4]).text();
                        product.narration = $(columns[6]).text();
                        product.amount = $(columns[7]).text();
                        product.company_id = $('#company_id').val();
                        product.tax = $(columns[8]).text();
                        product.taxAmount = $(columns[9]).text();
                        product.title = $(columns[10]).text();
                        products.push(product);
                    });

                    var $_token = jQuery('#token').val();
                    if(products != ""){
                    jQuery.ajax({
                        method: "POST",
                        cache: false,
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        data: {
                            voucher: JSON.stringify(voucher),
                            product_data: products
                        },
                        url: "{{ asset('cash-payments') }}",
                        success: function(result) {
                            if (result == "saved")
                            {
                                window.location.href = "{{ asset('cash-payments/create') }}";
                            }
                        },
                        error: function(xhr, ajaxOptions, thrownError) {
                            $("#spanWait").hide();
                            alert(xhr.status);
                            alert(thrownError);
                        }
                    });
                } else {
                    Swal.fire('Add your Account in Grid');
                    // $('#date').focus();
                }
            }
            });
        });


        //Select Account Type, SHow Related Acccounts
        $('#account_type').change(function(){
            var account_type = $(this).val();
            $.ajax({
                url:"{{ asset('get_account_group_parties') }}?id="+account_type,
                type:'get',
                dataType:'json',
                success:function(response){
                    if(response.length==0)
                    {
                        $('#select2-account_head_id-container').text('Account Not Found');
                        $('#account_head_id').html('<option>Account Not Found</option>');
                    }else{
                        // var str = '';
                        $('#select2-account_head_id-container').text('Select Value');
                        var str=`<option value="">Select Value</option>`;
                        $.each(response,function(i,v){
                            str+=`<option value="${v.id+'_'+v.party_name}">${v.party_name}</option>`;
                        });
  
                        $('#account_head_id').html(str);
                        $('#account_head_id').select2('open');
                    }   
                }
            });
        });
        // End Here
    </script>
@stop
