@extends("app")
@section('contents')
    <!-- <body onload="AddRowFunction()"> -->
    <link rel="stylesheet" href="https://ajax.googleapis.com/ajax/libs/jqueryui/1.8.9/themes/base/jquery-ui.css"
        type="text/css" />
    <meta name="csrf-token" content="{{ csrf_token() }}" />

    <body>
        <div class="container-fluid">
            @if (Session::has('flash_message'))
                <button type="button" class="close" data-dismiss="alert" aria-hidden="true"
                    style="margin-right: 20px;margin-top: 15px;">&times;</button>
                <div class="alert alert-success"> {{ Session::get('flash_message') }} </div>
            @endif
        </div>
        <div class="row">
            <div class="col-lg-12">
                <div class="panel panel-default">
                    <div class="panel-heading clearfix" id="panelbg">
                        <h2 class="panel-title"><b>Edit Bank Payment</b></h2>
                        <!-- <ul class="panel-tool-options"> 
             <li><a data-rel="collapse" href="#"><i class="icon-down-open"></i></a></li>
             <li><a data-rel="reload" href="#"><i class="icon-arrows-ccw"></i></a></li>
             <li><a data-rel="close" href="#"><i class="icon-cancel"></i></a></li>
            </ul> -->
                    </div>
                    <div class="panel-body">
                        <input id="token" type="hidden" value="{{ $encrypted_token }}">
                        @include('errors.validation')
                        {!! Form::model($edit, ['method' => 'PATCH', 'action' => ['App\Http\Controllers\BankPaymentController@update', $edit->id], 'class' => 'form-horizontal']) !!}
                        {!! Form::hidden('company_id', session()->get('company_id'), ['id' => 'company_id']) !!}
                        <div class="row">
                            <div class="form-group" style="margin-left: 1%; margin-right: 1%;">
                                <label class="col-sm-1 control-label">Vr. No</label>
                                <div class="col-sm-2">
                                    <div id="year-view" class="input-group date">
                                        {!! Form::text('voucher_no', null, ['id' => 'voucher_no', 'class' => 'form-control', 'disabled' => 'disabled']) !!}
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group" style="margin-left: 1%; margin-right: 1%;">
                                <label class="col-sm-1 control-label">Vr. Date</label>
                                <div class="col-sm-2">
                                    <div id="year-view" class="input-group date">
                                        <input id="voucher_date" type="date" name="voucher_date" value="<?php echo date('Y-m-d'); ?>"
                                            class="form-control" autofocus>
                                        <!-- <span class="input-group-addon"><i class="fa fa-calendar"></i></span>  -->
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row" style="display: none;">
                            <div class="form-group" style="margin-left: 1%; margin-right: 1%;">
                                <label class="col-sm-1 control-label">Voucher Type</label>
                                <div class="col-sm-5" style="height: 40px;">
                                    {!! Form::text('v_type', 'Bank Payment', ['id' => 'v_type', 'class' => 'form-control']) !!}
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group" style="margin-left: 1%; margin-right: 1%;">
                                <label class="col-sm-1 control-label">Cash&nbsp;Account</label>
                                <div class="col-sm-3" style="height: 40px;">
                                    {!! Form::select('account_id', $Accounts, $edit->account_id, ['id' => 'account_id', 'class' => 'form-control livesearch']) !!}
                                </div>
                            </div>
                        </div>
                        <div class="row" style="display:none;">
                            <div class="form-group" style="margin-left: 1%; margin-right: 1%;">
                                <label class="col-sm-1 control-label">Biller</label>
                                <div class="col-sm-3" style="height: 40px;">
                                    <select name="biller" id="biller" class="form-control" disabled>
                                        <option value="{{ Auth::user()->id }}">{{ Auth::user()->name }}</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="panel panel-default">
                            <div class="panel-body">
                                <div class="form-group">
                                    <table>
                                        <div class="container-fluid">
                                            <div class="row" id="myTable">
                                                <tr>

                                                    <!-- <div class="col-md-3"> 
         <div class="form-group"> 
          <label for="H.S" class="control-label">Id</label> -->
                                                    {!! Form::hidden('product_id', null, ['id' => 'product_id', 'class' => 'form-control']) !!}
                                                    <!-- </div>
        </div>  -->
                                                    <div class="col-md-1" style="margin-left: 1%; margin-right: 1%;">
                                                        <div class="form-group">
                                                            <label for="H.S" class="control-label">Date</label>
                                                            <input id="date" type="date" name="date"
                                                                value="<?php echo date('Y-m-d'); ?>" class="form-control">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-1" style="margin-left: 1%; margin-right: 1%;">
                                                        <div class="form-group">
                                                            <label for="password"
                                                                class="control-label">Cheque&nbsp;No</label>
                                                            {!! Form::text('cheque_no', null, ['id' => 'cheque_no', 'class' => 'form-control']) !!}
                                                        </div>
                                                    </div>
                                                    <div class="col-md-1"
                                                        style="display:none;margin-left: 1%; margin-right: 1%;">
                                                        <div class="form-group">
                                                            <label for="password"
                                                                class="control-label">Voucher&nbsp;No</label>
                                                            {!! Form::text('voucher_no', $codes, ['id' => 'voucher_no', 'class' => 'form-control']) !!}
                                                        </div>
                                                    </div>

                                                    <div class="col-md-2" style="display:none;">
                                                        <div class="form-group">
                                                            <label for="password" class="control-label">Type</label>
                                                            {!! Form::text('v_type', 'Bank Payment', ['id' => 'v_type', 'class' => 'form-control']) !!}
                                                        </div>
                                                    </div>
                                                    <div class="col-md-1">
                                                        <div class="form-group">
                                                            <label for="Name"
                                                                class="control-label">Account Type</label>
                                                            {!! Form::select('account_type', $accountGroups, null, ['id' => 'account_type', 'class' => 'form-control']) !!}
                                                        </div>
                                                    </div>
                                                    <div class="col-md-2" style="margin-left: 1%; margin-right: 1%;">
                                                        <div class="form-group">
                                                            <label for="Name"
                                                                class="control-label">Account&nbsp;Name</label>
                                                            {!! Form::select('account_head_id', $Accounts, null, ['id' => 'account_head_id', 'class' => 'form-control']) !!}
                                                        </div>
                                                    </div>
                                                    <div class="col-md-2" style="margin-left: 1%; margin-right: 1%;">
                                                        <div class="form-group">
                                                            <label for="password" class="control-label">Description</label>
                                                            {!! Form::text('narration', 'Bank Payment', ['id' => 'narration', 'class' => 'form-control']) !!}
                                                        </div>
                                                    </div>
                                                    <div class="col-md-1" style="margin-left: 1%; margin-right: 1%;">
                                                        <div class="form-group">
                                                            <label for="password" class="control-label">Amount</label>
                                                            {!! Form::text('credit', null, ['id' => 'credit', 'class' => 'form-control']) !!}
                                                        </div>
                                                    </div>
                                                    <div class="col-md-1" style="margin-left: 1%; margin-right: 1%;">
                                                        <div class="form-group">
                                                            <label for="tax" class="control-label">Tax</label>
                                                            {!! Form::text('tax', null, ['id' => 'tax', 'class' => 'form-control']) !!}
                                                        </div>
                                                    </div>
                                                    <div class="col-md-1">
                                                        <div class="form-group">
                                                            <label for="password" class="control-label">Add</label>

                                                            <button class="form-control" style="background: #e20707;"
                                                                type="button" class="btn btn-red"
                                                                onkeyup="AddGridData();">Add</button>
                                                            <!-- <button type="button" onclick="AddGridData()" class="btn btn-red"><i class="fa fa-plus"></i> </button> -->
                                                        </div>
                                                    </div>
                                                </tr>
                                            </div></br>
                                            <table id="myData" class="table">
                                                <?php $totalRate = 0;
                                                $totalAmount = 0; ?>
                                                @foreach ($edit->voucher_details as $details)
                                                    @if ($details->debit != null)
                                                    <tbody>
                                                        <tr>
                                                            <!-- 0 -->
                                                            <td style="display:none;">
                                                                <input id="account_head_id"
                                                                    value="{{ $details->account_head_id }}" type="text"
                                                                    class="form-control" disabled>
                                                            </td>
                                                            <!-- 1 -->
                                                            <td style="display:none;">
                                                                <input id="voucher_no" value="{{ $details->voucher_no }}"
                                                                    type="text" class="form-control" disabled>
                                                            </td>
                                                            <!-- 2 -->
                                                            <td style="display:none;">
                                                                <input id="v_type" value="Bank Payment" type="text"
                                                                    class="form-control" disabled>
                                                            </td>
                                                            <!-- 3 -->
                                                            <td style="margin-left: 1%; margin-right: 1%; padding-top:2%">
                                                                <input id="date" value="{{ $details->date }}"
                                                                    style="margin-left: 7%; width: 102%;" type="text"
                                                                    class="form-control" disabled>
                                                            </td>
                                                            <!-- 4 -->
                                                            <td style="margin-left: 1%; margin-right: 1%; padding-top:2%">
                                                                <input id="cheque_no" value="{{ $details->cheque_no }}"
                                                                    style="margin-left: 22%; width: 54%;" type="text"
                                                                    class="form-control" disabled>
                                                            </td>
                                                            <!-- 5 -->
                                                            <td style="margin-left: 1%; margin-right: 1%; padding-top:2%">
                                                                <input id="account_head_name"
                                                                    value="{{ $details->parties->party_name }}"
                                                                    style="margin-left: -12%; width: 103%;" type="text"
                                                                    class="form-control" disabled>
                                                            </td>
                                                            <!-- 6 -->
                                                            <td style="margin-left: 1%; margin-right: 1%; padding-top:2%">
                                                                <input id="narration" value="{{ $details->narration }}"
                                                                    style="margin-left: 2%; width: 104%;" type="text"
                                                                    class="form-control" disabled>
                                                            </td>
                                                            <!-- 7 -->
                                                            <td style="margin-left: 1%; margin-right: 1%; padding-top:2%">
                                                                <input id="credit" value="{{ $details->debit }}"
                                                                    style="margin-left: 22%; width: 54%;" type="text"
                                                                    class="form-control" disabled>
                                                            </td>
                                                            <!-- 8 -->
                                                            <td style="margin-left: 1%; margin-right: 1%; padding-top:2%">
                                                                <input id="tax" value="{{ $details->tax }}"
                                                                    style="margin-left: -18%; width: 56%;" type="text"
                                                                    class="form-control" disabled>
                                                            </td>
                                                            <!-- 9 -->
                                                            <td style="padding-top:2%"><button class="btn btn-red"
                                                                    type="button" style="margin-left: -106%;"> <i
                                                                        onclick="javascript:myDeleteFunction($(this).closest('tr'));"
                                                                        class="icon-trash"
                                                                        title="Delete Row"></i></button></td>
                                                            <?php $totalAmount = $totalAmount + $details->debit; ?>
                                                        </tr>
                                                    </tbody>
                                                         <br />
                                                    @endif
                                                @endforeach

                                            </table>
                                        </div>
                                    </table><br><br>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="panel panel-default">
                                    <div class="panel-heading clearfix" id="panelbg">
                                        <div class="container">
                                            <div class="col-lg-5"> </div>
                                            <!-- <div class="col-xs-3">  </div> -->
                                            <!-- <div class="col-xs-3"> <b>Total Rate</b> <input type="text" id="TotalRate" name="TotalRate" value="{{ $totalRate }}" disabled	></div> -->
                                            <div class="col-lg-3"> <b>Total&nbsp;Amount</b> <input type="text"
                                                    id="TotalAmount" name="TotalAmount" value="{{ $totalAmount }}"
                                                    disabled> </div>
                                        </div>
                                    </div>
                                    <!-- 		<div class="panel-body">
           <div class="table-responsive">
            <table class="table table-bordered">
             <thead> 
              <tr> 
               <th></th>  
               <th>Product&nbsp;ID</th>  
               <th>Code</th>  
                <th>Product&nbsp;Name</th> 
               <th>Cost</th> 
               <th>Quantity</th>
               <th>Cost&nbsp;Amount</th>
               <th>Sale&nbsp;Rate</th> 
               <th>Sale&nbsp;Amount</th>  
              </tr> 
             </thead> 
             <tbody id="GridTable">
             
             </tbody> 
            </table>
           </div>
          </div> -->
                                </div>
                            </div>
                        </div>
                        <center>
                            <div class="form-actions">
                                <button type="button" class="btn btn-primary" id="btnSave" name="btnSave">Save</button>
                            </div>
                        </center>
                        <!-- <div class="col-lg-3">
            <button type="button" onclick="AddRowFunction()" class="btn btn-success"><i class="fa fa-plus"></i> </button>
            <button type="button" onclick="AddGridData()" class="btn btn-success"><i class="fa fa-plus"></i> </button>
            <button type="button" onclick="TotalRecords()" class="btn btn-success">Total Records</button>
           </div> -->
                        {!! Form::close() !!}
                    </div>
                </div>
            </div>
        </div>
    </body>
@stop
@section('scripts')

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
    <script type="text/javascript" src="https://ajax.googleapis.com/ajax/libs/jqueryui/1.10.2/jquery-ui.min.js"></script>

    <script src="{{ asset('js/plugins/nouislider/nouislider.min.js') }}"></script>
    <!-- Input Mask-->
    <script src="{{ asset('js/plugins/jasny/jasny-bootstrap.min.js') }}"></script>
    <!-- Select2-->
    <script src="{{ asset('js/plugins/select2/select2.full.min.js') }}"></script>
    <!--Bootstrap ColorPicker-->
    <script src="{{ asset('js/plugins/colorpicker/bootstrap-colorpicker.min.js') }}"></script>
    <!--Bootstrap DatePicker-->
    <script src="{{ asset('js/plugins/datepicker/bootstrap-datepicker.js') }}"></script>

    <script type="text/javascript">
        function AddGridData() {
            if ($("#credit").val() == "" || $("#account_head_id").val() == "") {
                alert('Account Name or Amount Value Cant be Empty!');
                document.getElementById("credit").focus();
                e.preventdefault();
            }
            var date = document.getElementById('date').value;
            var ChequeNo = document.getElementById('cheque_no').value;
            var VoucherNo = document.getElementById('voucher_no').value;
            var v_type = document.getElementById('v_type').value
            var HeadTitle = document.getElementById('account_head_id').value.split("_").pop();
            var HeadId = document.getElementById('account_head_id').value.split("_")[0];
            var Narration = document.getElementById('narration').value;
            var Amount = document.getElementById('credit').value;
            var TotalAmount = document.getElementById('TotalAmount').value;
            var tax = document.getElementById('tax').value;
            var grand = parseInt(Amount) + parseInt(TotalAmount);
            document.getElementById('TotalAmount').value = grand;
            // var Credit = document.getElementById('credit').value;
            var tableHtml = '</br><tr>';
            //0
            tableHtml +=
                `<td style="display:none;"><input id="product_id" value="${HeadId}" type="text" class="form-control" disabled></td>`;
            //1
            tableHtml +=
                `<td style="display:none;"><input id="product_id" value="${VoucherNo}" type="text" class="form-control" disabled></td>`;
            //2
            tableHtml +=
                `<td style="display:none;"><input id="product_id" value="${v_type}" type="text" class="form-control" disabled></td>`;
            //3
            tableHtml +=
                `<td style="margin-left: 1%; margin-right: 1%; padding-top:2%;"><input id="product_id" value="${date}" style="margin-left: 7%; width: 102%;" type="text" class="form-control" disabled></td>`;
            //4
            tableHtml += `<td style="margin-left: 1%; margin-right: 1%; padding-top:2%">
				<input id="cheque_no" value="${ChequeNo}" style="margin-left: 22%; width: 54%;" type="text" class="form-control" disabled>
			</td>`;
            //5
            tableHtml += `<td style="margin-left: 1%; margin-right: 1%; padding-top:2%">
				<input id="account_head_name" value="${HeadTitle}" style="margin-left: -12%; width: 103%;" type="text" class="form-control" disabled>
			</td>`;
            //6
            tableHtml += `<td style="margin-left: 1%; margin-right: 1%; padding-top:2%">
			
				<input id="narration" value="${Narration}" style="margin-left: 2%; width: 104%;" type="text" class="form-control" disabled>
			</td>`;
            //7
            tableHtml += `<td style="margin-left: 1%; margin-right: 1%; padding-top:2%">
				<input id="credit" value="${Amount}" style="margin-left: 17%; width: 52%;" type="text" class="form-control" disabled>
			</td>`;
            //8
            tableHtml += `<td style="margin-left: 1%; margin-right: 1%; padding-top:2%">
				<input id="credit" value="${tax}" style="margin-left: 17%; width: 52%;" type="text" class="form-control" disabled>
			</td>`;
            //9
            tableHtml +=
                '<td style="padding-top:2%"><button class="btn btn-red" type="button" style="margin-left: -106%;"> <i onclick="javascript:myDeleteFunction($(this).closest(\'tr\'));" class="icon-trash" title="Delete Row"></i></button></td>';
            tableHtml += '</tr>';
            $('#myData').append(tableHtml);
            document.getElementById("date").focus();
        }


        function TotalRecords() {
            var rowCount = document.getElementById('myTable').rows.length;
            alert("Total Number of Records Are: " + rowCount);
        }

        // on javascript onclick on product dropdown 
        function ProductKeyUp(productID) {
            $.ajax({
                type: "GET",
                url: "{{ asset('productkeyup-ajax') }}?prodID=" + productID,
                success: function(result) {
                    if (result.length > 0) {
                        $('#product_code').val(result[0].product_code);
                        $('#product_id').val(result[0].id);
                        $("#product_cost").val(result[0].unit_cost);
                        $("#price_per_unit").val(result[0].price_per_unit);

                        var price = $("#price_per_unit").val();
                        var quantity = $("#quantity").val();
                        var cost = $("#product_cost").val();
                        var CostAmount = cost * quantity;
                        var SaleAmount = price * quantity;
                        document.getElementById('cost_amount').value = CostAmount;
                        document.getElementById('balance').value = SaleAmount;
                    }
                },
                error: function(xhr, ajaxOptions, thrownError) {
                    alert(xhr.status);
                    alert(thrownError);
                }
            });
        }


        function PartyKeyUp(partyId) {
            $.ajax({
                type: "GET",
                url: "{{ asset('partyonchange-ajax') }}?party_id=" + partyId,
                success: function(result) {
                    if (result.length > 0) {
                        $('#party_id').val(result[0].id);
                        $('#address').val(result[0].address);
                        $('#strn').val(result[0].strn);
                        $('#ntn').val(result[0].ntn);
                    }
                }
            })
        }

        function myDeleteFunction(row) {
            alertify.confirm("Are you sure you want to delete this Record?", function(e) {
                if (e) {
                    var TotalAmount = document.getElementById('TotalAmount').value;
                    var CurrentValue = $(row).find("td:eq('7')").find('input').val();
                    var grand = parseInt(TotalAmount) - parseInt(CurrentValue);
                    document.getElementById('TotalAmount').value = grand;
                    $(row).remove();
                    alertify.alert("Row is Removed!");
                } else {
                    alertify.alert("Row Not Deleted!");
                }
            });
        }

        $("#btnSave").click(function() {
            alertify.confirm("Are you sure you want update Bank Payment Voucher?", function(e) {
                if (e) {
                    var voucher = new Object();
                    voucher.account_id = $("#account_id").val().split("_")[0];
                    voucher.voucher_no = $("#voucher_no").val();
                    voucher.voucher_date = $("#voucher_date").val();
                    voucher.v_type = $("#v_type").val();
                    voucher.biller = $("#biller").val();
                    voucher.company_id = $('#company_id').val();

                    var products = [];
                    $.each($("#myData tr"), function(index, row) {
                        var columns = $(row).find("td");
                        var product = new Object();
                        // product.party_id = $("#party_id").val();
                        product.head_id = $(columns[0]).find("input").val();
                        product.voucher_no = $(columns[1]).find("input").val();
                        product.v_type = $(columns[2]).find("input").val();
                        product.date = $(columns[3]).find("input").val();
                        product.cheque_no = $(columns[4]).find("input").val();
                        product.narration = $(columns[6]).find("input").val();
                        product.amount = $(columns[7]).find("input").val();
                        product.company_id = $('#company_id').val();
                        product.tax = $(columns[8]).find("input").val();
                        products.push(product);
                    });

                    var $_token = jQuery('#token').val();
                    jQuery.ajax({
                        url: "{{ asset('bank-payments') }}/<?php echo $edit->id; ?>",
                        method: "PATCH",
                        cache: false,
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        data: {
                            voucher: JSON.stringify(voucher),
                            product_data: products
                        },
                        success: function(result) {
                            if (parseInt(result) > 0)
                            //if(parseInt(result) > 0)
                            {
                                //window.open("/sales/print/"+result);
                                window.location.href = "{{ asset('bank-payments') }}";
                                //alert("Cash Receipt successfully saved.");
                                window.open("/{{ asset('bank-payments') }}/" + result);
                                //alert("Sale successfully saved.");
                                //Session::flash('flash_message', 'Sale Added Successfully!');
                                //window.location.href = "/sales";

                            }
                        },
                        error: function(xhr, ajaxOptions, thrownError) {
                            $("#spanWait").hide();
                            alert(xhr.status);
                            alert(thrownError);
                        }
                    });
                } else {
                    alertify.alert("Not Saved!");
                }
            });
        });


        //Select Account Type, SHow Related Acccounts
        $('#account_type').change(function(){
            var account_type = $(this).val();
            $.ajax({
                url:"{{ asset('get_account_group_parties') }}?id="+account_type,
                type:'get',
                dataType:'json',
                success:function(response){
                    if(response.length==0)
                    {
                        $('#select2-account_head_id-container').text('Account Not Found');
                        $('#account_head_id').html('<option>Account Not Found</option>');
                    }else{
                        var str = '';
                        $('#select2-account_head_id-container').text('Select Account');
                        $.each(response,function(i,v){
                            str+=`<option value="${v.id+'_'+v.party_name}">${v.party_name}</option>`;
                        });
  
                        $('#account_head_id').html(str);
                    }   
                }
            });
        });
        // End Here


    </script>
@stop
