<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\RawMaterialStock;
use App\Models\Setting;
use App\Models\Product;
use App\Models\Warehouse;
use Illuminate\Support\Facades\DB;

class RawMaterialStockController extends Controller
{
    public function index()
    {
        $products = Product::OrderBy('product_name', 'asc')->where('catagory_id', 5)->where('company_id', session()->get('company_id'))->pluck('product_name', 'id')->prepend('ALL PRODUCTS', '0')->toArray();
        $warehouse = Warehouse::OrderBy('name', 'asc')->pluck('name', 'id')->toArray();
        $encrypter = app('Illuminate\Encryption\Encrypter');
        $encrypted_token = $encrypter->encrypt(csrf_token());
        return view('warehouse-stock-report.stock.raw-create', Compact('products', 'warehouse', 'encrypted_token'));
    }

    public function create()
    {
        //
    }

    public function store(Request $request)
    {
        $ProductID = $request->get('product_id');
        //return $ProductID;
        $fromDate = $request->get('from_date');
        //return $fromDate;
        $toDate = $request->get('to_date');
        $company_detail = Setting::where('id', '=', 1)->get();
        if ($ProductID == "0") {
            $RawMaterial = RawMaterialStock::join('products', 'products.id', 'raw_material_stocks.product_id')
                ->select(DB::raw('product_code, product_name, product_cost, sum(cost_amount) as CostAmount, sum(stockin) as stockin ,sum(stockout) as stockout'))
                ->groupBy('product_id')
                //->where('warehouse_id', '=', $warehouse[0]->id)
                ->where('products.catagory_id', '=', 5)
                //->Orwhere('products.catagory_id', '=', 7)
                ->whereDate('date', '>=', $fromDate)
                ->whereDate('date', '<=', $toDate)
                ->where('raw_material_stocks.company_id', session()->get('company_id'))
                ->get();

            //return $RawMaterial;
            return view('warehouse-stock-report.stock.all', Compact('RawMaterial', 'company_detail', 'fromDate', 'toDate'));
        } else {
            $items = RawMaterialStock::with('uoms')->with('warehouse')->with('products')->where('product_id', '=', $ProductID)
                ->whereDate('date', '>=', $fromDate)
                ->whereDate('date', '<=', $toDate)
                ->where('company_id', session()->get('company_id'))
                ->OrderBy('id', 'asc')->get();
            //return $items;

            $openingStock = RawMaterialStock::with('parties')->where('product_id', '=', $ProductID)
                ->whereDate('date', '>=', '2019-01-01')
                ->whereDate('date', '<', $fromDate)
                ->where('raw_material_stocks.company_id', session()->get('company_id'))
                ->select(DB::raw('SUM(stockin) as stockin, SUM(stockout) as stockout'))
                ->OrderBy('date', 'asc')->get();
            $product = Product::where('id', '=', $ProductID)->get();
            //return $openingStock;

            return view('warehouse-stock-report.stock.single', Compact('items', 'company_detail', 'product', 'fromDate', 'toDate', 'openingStock'));
        }
    }

    public function show($id)
    {
        //
    }

    public function edit($id)
    {
        //
    }

    public function update(Request $request, $id)
    {
        //
    }

    public function destroy($id)
    {
        //
    }
}