<?php

namespace App\Http\Controllers;

use App\Models\AccountGroup;
use App\Models\Party;
use App\Models\PurchaseTax;
use App\Models\SaleTax;
use App\Models\Vouchers;
use Illuminate\Http\Request;

class PrintReportsController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function create()
    {
        $AccountGroups = AccountGroup::where('code','!=',10)
                        ->where('code','!=',11)
                        ->where('code','!=',12)
                        ->OrderBy('name', 'asc')
                        ->pluck('name', 'id')
                        ->prepend('Select Category','');
        $Heads = Party::OrderBy('party_name', 'asc')
                        ->where('party_name', '!=', 'CASH IN HAND')
                        ->where('company_id', session()->get('company_id'))
                        ->pluck('party_name', 'id')
                        ->prepend('Select Account', '')
                        ->toArray();
        return view('print-reports.create',compact('AccountGroups','Heads'));
    }

    public function findReport(Request $request)
    {
        $fromDate = $request->from_date;
        $toDate = $request->to_date;
        $HeadID = $request->head_id;

        if($request->report_type=='cr'){
            $cash_receipt_detail = Vouchers::with(['voucher_details' => function ($query){
                $query->with('parties');
            }])
                ->with('parties')
                ->whereDate('created_at','>=',$fromDate)
                ->whereDate('created_at','<=',$toDate)
                ->where('company_id', session()->get('company_id'))
                ->where('v_type','Cash Receipt')
                ->OrderBy('id','desc')
                ->get();



            return view('print-reports.cash-reciept-report',compact('cash_receipt_detail','fromDate','toDate','HeadID'));
        }
        else 
        if($request->report_type=='cp'){
            $cash_payment_detail = Vouchers::with(['voucher_details' => function ($query) {
                $query->with('parties');
            }])
                ->with('parties')
                ->whereDate('created_at','>=',$fromDate)
                ->whereDate('created_at','<=',$toDate)
                ->where('company_id', session()->get('company_id'))
                ->where('v_type','Cash Payment')
                ->get();

            return view('print-reports.cash-payment-report',compact('cash_payment_detail','fromDate','toDate'));
        }
        else 
        if($request->report_type=='br'){
            $bank_receipt_detail = Vouchers::with(['voucher_details' => function ($query) {
                $query->with('banks');
                $query->with('parties');
            }])->with('parties')
                ->whereDate('created_at','>=',$fromDate)
                ->whereDate('created_at','<=',$toDate)
                ->where('company_id', session()->get('company_id'))
                ->where('v_type','Bank Receipt')
                ->get();

            return view('print-reports.bank-receipt-report',compact('bank_receipt_detail','fromDate','toDate'));
        }
        else 
        if($request->report_type=='bp'){
            $bank_payment_detail = Vouchers::with(['voucher_details' => function ($query) {
                $query->with('banks');
                $query->with('parties');
            }])->with('parties')
                ->whereDate('created_at','>=',$fromDate)
                ->whereDate('created_at','<=',$toDate)
                ->where('company_id', session()->get('company_id'))
                ->where('v_type','Bank Payment')
                ->get();

            return view('print-reports.bank-payment-report',compact('bank_payment_detail','fromDate','toDate'));
        }
        else 
        if($request->report_type=='pt'){
            $purchase_tax_detail = PurchaseTax::with(['purchasetax_details' => function ($query) {
                $query->with('products');
            }])->whereDate('created_at','>=',$fromDate)
                ->whereDate('created_at','<=',$toDate)
                ->where('company_id', session()->get('company_id'))
                ->get();

            return view('print-reports.purchase-tax-report',compact('purchase_tax_detail','fromDate','toDate'));
        }
        else 
        if($request->report_type=='st'){
            $sales_tax_detail = SaleTax::with(['saletax_details' => function ($query) {
                $query->with('unit')->with('products');
            }])->with('parties')->with('shop')
                ->where('company_id', session()->get('company_id'))
                ->whereDate('created_at','>=',$fromDate)
                ->whereDate('created_at','<=',$toDate)
                ->get();

            return view('print-reports.sales-tax-report',compact('sales_tax_detail','fromDate','toDate'));
        }
        else 
        if($request->report_type=='jv'){
            $general_voucher =  Vouchers::with(['voucher_details' => function ($query) {
                $query->with('banks');
                $query->with('parties');
            }])->with('parties')
                ->whereDate('created_at','>=',$fromDate)
                ->whereDate('created_at','<=',$toDate)
                ->where('company_id', session()->get('company_id'))
                ->where('v_type','Journal Voucher')
                ->get();

            return view('print-reports.jv-report',compact('general_voucher','fromDate','toDate'));
        }else{
            abort(404);
        }
    }
}
