<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Mail\FbrInvoice;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;

class FbrInvoiceController extends Controller
{

    public function index()
    {
        return view('fbr_invoice');
    }

    public function submitForm(Request $request)
    {
        $validatedData = $request->validate([
            'business_name' => 'required|string|max:255',
            'ntn_number' => 'required|string|max:50',
            'email' => 'required|email',
            'phone' => 'required|string|max:20',
        ]);
        // dd($validatedData);
        Mail::to('waseemkamboh424@gmail.com')->send(new FbrInvoice($validatedData));

        return back()->with('success', 'Your registration for FBR Digital Invoicing has been submitted successfully!');
    }
}
